/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import java.net.Socket;
import org.apache.geode.cache.client.internal.AbstractOp;
import org.apache.geode.cache.client.internal.Connection;

public abstract class AbstractOpWithTimeout
extends AbstractOp {
    private final int timeoutMs;

    AbstractOpWithTimeout(int msgType, int msgParts, int timeoutMs) {
        super(msgType, msgParts);
        this.timeoutMs = timeoutMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object attempt(Connection connection) throws Exception {
        int timeoutMs;
        boolean changeTimeout;
        Socket socket = connection.getSocket();
        int previousTimeoutMs = socket.getSoTimeout();
        boolean bl = changeTimeout = previousTimeoutMs != (timeoutMs = this.getTimeoutMs());
        if (changeTimeout) {
            socket.setSoTimeout(timeoutMs);
        }
        try {
            Object object = super.attempt(connection);
            return object;
        }
        finally {
            if (changeTimeout) {
                socket.setSoTimeout(previousTimeoutMs);
            }
        }
    }

    final int getTimeoutMs() {
        return this.timeoutMs;
    }
}

