/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.geode.internal.lang.SystemUtils;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.internal.cli.commands.OfflineGfshCommand;
import org.apache.geode.management.internal.cli.result.model.InfoResultModel;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.shell.Gfsh;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class ShCommand
extends OfflineGfshCommand {
    @CliCommand(value={"sh"}, help="Allows execution of operating system (OS) commands. Use '&' to return to gfsh prompt immediately. NOTE: Commands which pass output to another shell command are not currently supported.")
    @CliMetaData(shellOnly=true, relatedTopic={"GFSH"})
    public ResultModel sh(@CliOption(key={"", "command"}, mandatory=true, help="The command to execute.") String command, @CliOption(key={"use-console"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Useful on Unix systems for applications which need handle of console. Adds \"</dev/tty >/dev/tty\" to the user specified command.") boolean useConsole) throws IOException {
        ResultModel result = new ResultModel();
        InfoResultModel info = result.getInfoSection("info");
        this.executeCommand(info, Gfsh.getCurrentInstance(), command, useConsole);
        return result;
    }

    private void executeCommand(InfoResultModel result, Gfsh gfsh, String userCommand, boolean useConsole) throws IOException {
        String cmdToExecute = userCommand;
        String cmdExecutor = "/bin/sh";
        String cmdExecutorOpt = "-c";
        if (SystemUtils.isWindows()) {
            cmdExecutor = "cmd";
            cmdExecutorOpt = "/c";
        } else if (useConsole) {
            cmdToExecute = cmdToExecute + " </dev/tty >/dev/tty";
        }
        String[] commandArray = new String[]{cmdExecutor, cmdExecutorOpt, cmdToExecute};
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.command(commandArray);
        builder.directory();
        builder.redirectErrorStream();
        Process proc = builder.start();
        try (InputStreamReader inputStreamReader = new InputStreamReader(proc.getInputStream());
             BufferedReader input = new BufferedReader(inputStreamReader);){
            String lineRead;
            while ((lineRead = input.readLine()) != null) {
                result.addLine(lineRead);
            }
        }
        proc.getOutputStream().close();
        try {
            if (proc.waitFor() != 0) {
                gfsh.logWarning("The command '" + userCommand + "' did not complete successfully", null);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

