/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.scalar;

import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.binary.BinaryStringData;
import org.apache.flink.table.data.binary.BinaryStringDataUtil;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.SpecializedFunction;
import org.apache.flink.table.runtime.functions.scalar.BuiltInScalarFunction;

@Internal
public class StartsWithFunction
extends BuiltInScalarFunction {
    public StartsWithFunction(SpecializedFunction.SpecializedContext context) {
        super(BuiltInFunctionDefinitions.STARTS_WITH, context);
    }

    @Nullable
    public Boolean eval(@Nullable StringData expr, @Nullable StringData startExpr) {
        if (expr == null || startExpr == null) {
            return null;
        }
        if (BinaryStringDataUtil.isEmpty((BinaryStringData)startExpr)) {
            return true;
        }
        return ((BinaryStringData)expr).startsWith((BinaryStringData)startExpr);
    }

    @Nullable
    public Boolean eval(@Nullable byte[] expr, @Nullable byte[] startExpr) {
        if (expr == null || startExpr == null) {
            return null;
        }
        if (startExpr.length == 0) {
            return true;
        }
        return StartsWithFunction.matchAtStart(expr, startExpr);
    }

    private static boolean matchAtStart(byte[] source, byte[] target) {
        if (source.length < target.length) {
            return false;
        }
        for (int i = 0; i < target.length; ++i) {
            if (source[i] == target[i]) continue;
            return false;
        }
        return true;
    }
}

