/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.fineract.mix.service;

import java.sql.ResultSet;
import java.sql.SQLException;
import lombok.RequiredArgsConstructor;
import org.apache.fineract.mix.data.MixTaxonomyMappingData;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

@RequiredArgsConstructor
public class MixTaxonomyMappingReadPlatformServiceImpl implements MixTaxonomyMappingReadPlatformService {

    private final JdbcTemplate jdbcTemplate;

    private static final class TaxonomyMappingMapper implements RowMapper<MixTaxonomyMappingData> {

        public String schema() {
            return "identifier, config " + "from mix_taxonomy_mapping";
        }

        @Override
        public MixTaxonomyMappingData mapRow(final ResultSet rs, @SuppressWarnings("unused") final int rowNum) throws SQLException {
            final String identifier = rs.getString("identifier");
            final String config = rs.getString("config");
            return new MixTaxonomyMappingData().setIdentifier(identifier).setConfig(config);
        }

    }

    @Override
    public MixTaxonomyMappingData retrieveTaxonomyMapping() {
        try {
            final TaxonomyMappingMapper rm = new TaxonomyMappingMapper();
            final String sqlString = "select " + rm.schema();
            return this.jdbcTemplate.queryForObject(sqlString, rm); // NOSONAR
        } catch (final EmptyResultDataAccessException e) {
            return null;
        }

    }
}
