/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl.tl;

import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.ext.ContextResolver;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Providers;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.apache.cxf.jaxrs.impl.ProvidersImpl;
import org.apache.cxf.jaxrs.impl.tl.AbstractThreadLocalProxy;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;

public class ThreadLocalProviders
extends AbstractThreadLocalProxy<Providers>
implements Providers {
    public <T> MessageBodyReader<T> getMessageBodyReader(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        Providers p = this.getCurrentProviders();
        return p != null ? p.getMessageBodyReader(type, genericType, annotations, mediaType) : null;
    }

    public <T> MessageBodyWriter<T> getMessageBodyWriter(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        Providers p = this.getCurrentProviders();
        return p != null ? p.getMessageBodyWriter(type, genericType, annotations, mediaType) : null;
    }

    public <T> ContextResolver<T> getContextResolver(Class<T> contextType, MediaType mediaType) {
        Providers p = this.getCurrentProviders();
        return p != null ? p.getContextResolver(contextType, mediaType) : null;
    }

    public <T extends Throwable> ExceptionMapper<T> getExceptionMapper(Class<T> type) {
        Providers p = this.getCurrentProviders();
        return p != null ? p.getExceptionMapper(type) : null;
    }

    private Providers getCurrentProviders() {
        Providers p = (Providers)this.get();
        return p != null ? p : this.getProvidersImpl();
    }

    private Providers getProvidersImpl() {
        Message m = JAXRSUtils.getCurrentMessage();
        return m != null ? new ProvidersImpl(JAXRSUtils.getContextMessage(m)) : null;
    }
}

