/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import java.util.Objects;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;

public class SessionConsumerFlowCreditMessage
extends PacketImpl {
    private long consumerID;
    private int credits;

    public SessionConsumerFlowCreditMessage(long consumerID, int credits) {
        super((byte)70);
        this.consumerID = consumerID;
        this.credits = credits;
    }

    public SessionConsumerFlowCreditMessage() {
        super((byte)70);
    }

    public long getConsumerID() {
        return this.consumerID;
    }

    public int getCredits() {
        return this.credits;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeLong(this.consumerID);
        buffer.writeInt(this.credits);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        this.consumerID = buffer.readLong();
        this.credits = buffer.readInt();
    }

    @Override
    protected String getPacketString() {
        return super.getPacketString() + ", consumerID=" + this.consumerID + ", credits=" + this.credits;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.consumerID, this.credits);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SessionConsumerFlowCreditMessage)) {
            return false;
        }
        SessionConsumerFlowCreditMessage other = (SessionConsumerFlowCreditMessage)obj;
        return this.consumerID == other.consumerID && this.credits == other.credits;
    }
}

