/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.corba.types;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Namespace;
import org.apache.cxf.binding.corba.runtime.CorbaObjectReader;
import org.apache.cxf.binding.corba.types.AbstractStartEndEventProducer;
import org.apache.cxf.binding.corba.types.CorbaAnyHandler;
import org.apache.cxf.binding.corba.types.CorbaHandlerUtils;
import org.apache.cxf.binding.corba.types.CorbaObjectHandler;
import org.apache.cxf.binding.corba.types.CorbaPrimitiveHandler;
import org.apache.cxf.binding.corba.types.CorbaTypeEventProducer;
import org.apache.cxf.binding.corba.utils.CorbaAnyHelper;
import org.apache.cxf.binding.corba.utils.CorbaUtils;
import org.apache.cxf.binding.corba.wsdl.CorbaConstants;
import org.apache.cxf.binding.corba.wsdl.CorbaType;
import org.apache.cxf.service.model.ServiceInfo;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.portable.InputStream;

public class CorbaAnyEventProducer
extends AbstractStartEndEventProducer {
    private static final String ANY_TYPE_PREFIX = "anytypens";
    private CorbaAnyHandler handler;
    private List<Attribute> attributes;
    private List<Namespace> namespaces;
    private CorbaObjectHandler containedType;

    public CorbaAnyEventProducer(CorbaObjectHandler h, ServiceInfo info, ORB orbRef) {
        CorbaTypeEventProducer containedProducer;
        this.handler = (CorbaAnyHandler)h;
        this.name = this.handler.getName();
        this.orb = orbRef;
        this.serviceInfo = info;
        this.containedType = this.getAnyContainedType(this.handler.getValue());
        this.handler.setAnyContainedType(this.containedType);
        if (this.containedType != null) {
            QName containedSchemaType = this.convertIdlToSchemaType(this.containedType);
            XMLEventFactory factory = XMLEventFactory.newInstance();
            this.attributes = new ArrayList<Attribute>();
            this.attributes.add(factory.createAttribute(new QName("http://www.w3.org/2001/XMLSchema-instance", "type"), "anytypens:" + containedSchemaType.getLocalPart()));
            this.namespaces = new ArrayList<Namespace>();
            this.namespaces.add(factory.createNamespace(ANY_TYPE_PREFIX, containedSchemaType.getNamespaceURI()));
        }
        if ((containedProducer = CorbaHandlerUtils.getTypeEventProducer(this.containedType, this.serviceInfo, this.orb)) instanceof AbstractStartEndEventProducer) {
            this.iterator = ((AbstractStartEndEventProducer)containedProducer).getNestedTypes();
        } else {
            ArrayList<CorbaSimpleAnyContainedTypeEventProducer> prods = new ArrayList<CorbaSimpleAnyContainedTypeEventProducer>();
            CorbaSimpleAnyContainedTypeEventProducer simpleProducer = new CorbaSimpleAnyContainedTypeEventProducer(containedProducer.getText());
            prods.add(simpleProducer);
            this.producers = prods.iterator();
        }
    }

    @Override
    public List<Attribute> getAttributes() {
        if (this.currentEventProducer == null) {
            return this.attributes;
        }
        return null;
    }

    @Override
    public List<Namespace> getNamespaces() {
        return this.namespaces;
    }

    private CorbaObjectHandler getAnyContainedType(Any a) {
        CorbaObjectHandler result;
        TypeCode tc = a.type();
        QName containedName = new QName("AnyContainedType");
        if (CorbaUtils.isPrimitiveTypeCode(tc)) {
            idlType = CorbaAnyHelper.getPrimitiveIdlTypeFromTypeCode(tc);
            result = new CorbaPrimitiveHandler(containedName, idlType, tc, null);
        } else if (tc.kind().value() == 11) {
            idlType = CorbaConstants.NT_CORBA_ANY;
            result = new CorbaAnyHandler(containedName, idlType, tc, null);
            ((CorbaAnyHandler)result).setTypeMap(this.handler.getTypeMap());
        } else {
            idlType = this.handler.getTypeMap().getIdlType(tc);
            result = CorbaHandlerUtils.initializeObjectHandler(this.orb, containedName, idlType, this.handler.getTypeMap(), this.serviceInfo);
        }
        InputStream is = a.create_input_stream();
        CorbaObjectReader reader = new CorbaObjectReader(is);
        reader.read(result);
        return result;
    }

    private QName convertIdlToSchemaType(CorbaObjectHandler obj) {
        QName result;
        QName idlType = obj.getIdlType();
        if (CorbaAnyHelper.isPrimitiveIdlType(idlType)) {
            result = CorbaAnyHelper.convertPrimitiveIdlToSchemaType(obj.getIdlType());
        } else {
            CorbaType impl = obj.getType();
            result = impl.getType();
        }
        return result;
    }

    class CorbaSimpleAnyContainedTypeEventProducer
    implements CorbaTypeEventProducer {
        int state;
        int[] states = new int[]{4};
        String value;

        CorbaSimpleAnyContainedTypeEventProducer(String text) {
            this.value = text;
            this.state = 0;
        }

        @Override
        public String getLocalName() {
            return null;
        }

        @Override
        public String getText() {
            return this.value;
        }

        @Override
        public int next() {
            return this.states[this.state++];
        }

        @Override
        public QName getName() {
            return null;
        }

        @Override
        public boolean hasNext() {
            return this.state < this.states.length;
        }

        @Override
        public List<Attribute> getAttributes() {
            return null;
        }

        @Override
        public List<Namespace> getNamespaces() {
            return null;
        }
    }
}

