/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.corba.common;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import org.apache.cxf.common.xmlschema.SchemaCollection;
import org.apache.cxf.tools.corba.common.SchemaFactory;
import org.apache.cxf.tools.corba.common.SchemaFactoryImpl;
import org.apache.cxf.tools.corba.common.WSDLCorbaFactory;
import org.apache.cxf.tools.corba.common.WSDLCorbaFactoryImpl;
import org.apache.cxf.tools.util.FileWriterUtil;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaExternal;
import org.apache.ws.commons.schema.XmlSchemaForm;

public final class WSDLUtils {
    private WSDLUtils() {
    }

    public static boolean isElementFormQualified(SchemaCollection schemas, QName type) {
        XmlSchema sch;
        if (type != null && (sch = schemas.getSchemaByTargetNamespace(type.getNamespaceURI())) != null) {
            return sch.getElementFormDefault() == XmlSchemaForm.QUALIFIED;
        }
        return false;
    }

    public static boolean isElementFormQualified(XmlSchema schema, QName type) {
        if (type != null) {
            String uri = type.getNamespaceURI();
            if (uri.equals(schema.getTargetNamespace())) {
                return schema.getElementFormDefault() == XmlSchemaForm.QUALIFIED;
            }
            Iterator iterator = schema.getExternals().iterator();
            if (iterator.hasNext()) {
                XmlSchemaExternal extSchema = (XmlSchemaExternal)iterator.next();
                return WSDLUtils.isElementFormQualified(extSchema.getSchema(), type);
            }
        }
        return false;
    }

    public static void writeWSDL(Definition def, String outputdir, String wsdlOutput) throws WSDLException, IOException {
        FileWriterUtil fw = new FileWriterUtil(outputdir, null);
        Writer outputWriter = fw.getWriter("", wsdlOutput);
        WSDLUtils.writeWSDL(def, outputWriter);
    }

    public static void writeWSDL(Definition def, Writer outputWriter) throws WSDLException, IOException {
        WSDLCorbaFactoryImpl wsdlfactory = new WSDLCorbaFactoryImpl();
        WSDLWriter writer = ((WSDLCorbaFactory)wsdlfactory).newWSDLWriter();
        writer.writeWSDL(def, outputWriter);
        outputWriter.flush();
        outputWriter.close();
    }

    public static void writeSchema(Definition def, Writer outputWriter) throws WSDLException, IOException {
        SchemaFactoryImpl sfactory = new SchemaFactoryImpl();
        WSDLWriter swriter = ((SchemaFactory)sfactory).newWSDLWriter();
        swriter.writeWSDL(def, outputWriter);
        outputWriter.flush();
        outputWriter.close();
    }
}

