/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.journal.impl;

import java.util.Objects;
import org.apache.activemq.artemis.core.journal.impl.JournalFile;
import org.apache.activemq.artemis.core.journal.impl.ObjIntIntArrayList;

public class JournalRecord {
    private static int INITIAL_FILES_CAPACITY = 5;
    private final JournalFile addFile;
    private final int size;
    private static final ObjIntIntArrayList<JournalFile> DELETED = new ObjIntIntArrayList(0);
    private ObjIntIntArrayList<JournalFile> fileUpdates;

    public JournalRecord(JournalFile addFile, int size) {
        this.addFile = Objects.requireNonNull(addFile);
        this.size = size;
        addFile.incPosCount();
        addFile.addSize(size);
        addFile.incAddRecord();
    }

    void addUpdateFile(JournalFile updateFile, int bytes, boolean replaceableUpdate) {
        int lastIndex;
        int files;
        this.checkNotDeleted();
        if (bytes == 0) {
            return;
        }
        if (this.fileUpdates == null) {
            this.fileUpdates = new ObjIntIntArrayList(INITIAL_FILES_CAPACITY);
        }
        if ((files = this.fileUpdates.size()) > 0 && this.fileUpdates.addToIntsIfMatch(lastIndex = files - 1, updateFile, bytes, 1)) {
            updateFile.incPosCount();
            updateFile.addSize(bytes);
            return;
        }
        this.fileUpdates.add(updateFile, bytes, 1);
        updateFile.incPosCount();
        updateFile.addSize(bytes);
        if (replaceableUpdate) {
            updateFile.incReplaceableCount();
        }
    }

    void delete(JournalFile file) {
        this.checkNotDeleted();
        ObjIntIntArrayList<JournalFile> fileUpdates = this.fileUpdates;
        try {
            file.incNegCount(this.addFile);
            this.addFile.decSize(this.size);
            if (fileUpdates != null) {
                fileUpdates.forEach((updFile, bytes, posCount, f) -> {
                    f.incNegCount((JournalFile)updFile, posCount);
                    updFile.decSize(bytes);
                }, file);
            }
        }
        finally {
            if (fileUpdates != null) {
                fileUpdates.clear();
                this.fileUpdates = DELETED;
            }
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("JournalRecord(add=" + this.addFile.getFile().getFileName());
        ObjIntIntArrayList<JournalFile> fileUpdates = this.fileUpdates;
        if (fileUpdates != null) {
            if (fileUpdates == DELETED) {
                buffer.append(", deleted");
            } else {
                fileUpdates.forEach((file, ignoredA, ignoredB, builder) -> builder.append(", update=").append(file.getFile().getFileName()), buffer);
            }
        }
        buffer.append(")");
        return buffer.toString();
    }

    private void checkNotDeleted() {
        if (this.fileUpdates == DELETED) {
            throw new IllegalStateException("the record is already deleted");
        }
    }
}

