/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config;

import java.io.Serializable;
import java.net.URI;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.ConfigurationUtils;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.uri.ClusterConnectionConfigurationParser;
import org.apache.activemq.artemis.utils.uri.URISupport;

public final class ClusterConnectionConfiguration
implements Serializable {
    private static final long serialVersionUID = 8948303813427795935L;
    private String name;
    private String address = ActiveMQDefaultConfiguration.getDefaultClusterAddress();
    private String connectorName;
    private long clientFailureCheckPeriod = ActiveMQDefaultConfiguration.getDefaultClusterFailureCheckPeriod();
    private long connectionTTL = ActiveMQDefaultConfiguration.getDefaultClusterConnectionTtl();
    private long retryInterval = ActiveMQDefaultConfiguration.getDefaultClusterRetryInterval();
    private double retryIntervalMultiplier = ActiveMQDefaultConfiguration.getDefaultClusterRetryIntervalMultiplier();
    private long maxRetryInterval = ActiveMQDefaultConfiguration.getDefaultClusterMaxRetryInterval();
    private int initialConnectAttempts = ActiveMQDefaultConfiguration.getDefaultClusterInitialConnectAttempts();
    private int reconnectAttempts = ActiveMQDefaultConfiguration.getDefaultClusterReconnectAttempts();
    private long callTimeout = ActiveMQDefaultConfiguration.getDefaultClusterCallTimeout();
    private long callFailoverTimeout = ActiveMQDefaultConfiguration.getDefaultClusterCallFailoverTimeout();
    private boolean duplicateDetection = ActiveMQDefaultConfiguration.isDefaultClusterDuplicateDetection();
    private MessageLoadBalancingType messageLoadBalancingType = Enum.valueOf(MessageLoadBalancingType.class, ActiveMQDefaultConfiguration.getDefaultClusterMessageLoadBalancingType());
    private URISupport.CompositeData compositeMembers;
    private List<String> staticConnectors = Collections.emptyList();
    private String discoveryGroupName = null;
    private int maxHops = ActiveMQDefaultConfiguration.getDefaultClusterMaxHops();
    private int confirmationWindowSize = ActiveMQDefaultConfiguration.getDefaultClusterConfirmationWindowSize();
    private int producerWindowSize = ActiveMQDefaultConfiguration.getDefaultBridgeProducerWindowSize();
    private boolean allowDirectConnectionsOnly = false;
    private int minLargeMessageSize = 102400;
    private long clusterNotificationInterval = ActiveMQDefaultConfiguration.getDefaultClusterNotificationInterval();
    private int clusterNotificationAttempts = ActiveMQDefaultConfiguration.getDefaultClusterNotificationAttempts();
    private String clientId;
    private int topologyScannerAttempts = ActiveMQDefaultConfiguration.getClusterTopologyScannerAttempts();

    public ClusterConnectionConfiguration() {
    }

    public ClusterConnectionConfiguration(URI uri) throws Exception {
        ClusterConnectionConfigurationParser parser = new ClusterConnectionConfigurationParser();
        parser.populateObject(uri, this);
    }

    public String getName() {
        return this.name;
    }

    public ClusterConnectionConfiguration setName(String name) {
        this.name = name;
        return this;
    }

    public String getAddress() {
        return this.address;
    }

    public ClusterConnectionConfiguration setAddress(String address) {
        this.address = address;
        return this;
    }

    public URISupport.CompositeData getCompositeMembers() {
        return this.compositeMembers;
    }

    public ClusterConnectionConfiguration setCompositeMembers(URISupport.CompositeData members) {
        this.compositeMembers = members;
        return this;
    }

    public long getClientFailureCheckPeriod() {
        return this.clientFailureCheckPeriod;
    }

    public ClusterConnectionConfiguration setClientFailureCheckPeriod(long clientFailureCheckPeriod) {
        this.clientFailureCheckPeriod = clientFailureCheckPeriod;
        return this;
    }

    public long getConnectionTTL() {
        return this.connectionTTL;
    }

    public ClusterConnectionConfiguration setConnectionTTL(long connectionTTL) {
        this.connectionTTL = connectionTTL;
        return this;
    }

    public double getRetryIntervalMultiplier() {
        return this.retryIntervalMultiplier;
    }

    public ClusterConnectionConfiguration setRetryIntervalMultiplier(double retryIntervalMultiplier) {
        this.retryIntervalMultiplier = retryIntervalMultiplier;
        return this;
    }

    public long getMaxRetryInterval() {
        return this.maxRetryInterval;
    }

    public ClusterConnectionConfiguration setMaxRetryInterval(long maxRetryInterval) {
        this.maxRetryInterval = maxRetryInterval;
        return this;
    }

    public int getInitialConnectAttempts() {
        return this.initialConnectAttempts;
    }

    public ClusterConnectionConfiguration setInitialConnectAttempts(int initialConnectAttempts) {
        this.initialConnectAttempts = initialConnectAttempts;
        return this;
    }

    public int getReconnectAttempts() {
        return this.reconnectAttempts;
    }

    public ClusterConnectionConfiguration setReconnectAttempts(int reconnectAttempts) {
        this.reconnectAttempts = reconnectAttempts;
        return this;
    }

    public long getCallTimeout() {
        return this.callTimeout;
    }

    public ClusterConnectionConfiguration setCallTimeout(long callTimeout) {
        this.callTimeout = callTimeout;
        return this;
    }

    public long getCallFailoverTimeout() {
        return this.callFailoverTimeout;
    }

    public ClusterConnectionConfiguration setCallFailoverTimeout(long callFailoverTimeout) {
        this.callFailoverTimeout = callFailoverTimeout;
        return this;
    }

    public String getConnectorName() {
        return this.connectorName;
    }

    public ClusterConnectionConfiguration setConnectorName(String connectorName) {
        this.connectorName = connectorName;
        return this;
    }

    public boolean isDuplicateDetection() {
        return this.duplicateDetection;
    }

    public ClusterConnectionConfiguration setDuplicateDetection(boolean duplicateDetection) {
        this.duplicateDetection = duplicateDetection;
        return this;
    }

    public MessageLoadBalancingType getMessageLoadBalancingType() {
        return this.messageLoadBalancingType;
    }

    public ClusterConnectionConfiguration setMessageLoadBalancingType(MessageLoadBalancingType messageLoadBalancingType) {
        this.messageLoadBalancingType = messageLoadBalancingType;
        return this;
    }

    public int getMaxHops() {
        return this.maxHops;
    }

    public ClusterConnectionConfiguration setMaxHops(int maxHops) {
        this.maxHops = maxHops;
        return this;
    }

    public int getConfirmationWindowSize() {
        return this.confirmationWindowSize;
    }

    public ClusterConnectionConfiguration setConfirmationWindowSize(int confirmationWindowSize) {
        this.confirmationWindowSize = confirmationWindowSize;
        return this;
    }

    public int getProducerWindowSize() {
        return this.producerWindowSize;
    }

    public ClusterConnectionConfiguration setProducerWindowSize(int producerWindowSize) {
        this.producerWindowSize = producerWindowSize;
        return this;
    }

    public List<String> getStaticConnectors() {
        return this.staticConnectors;
    }

    public ClusterConnectionConfiguration setStaticConnectors(List<String> staticConnectors) {
        this.staticConnectors = staticConnectors;
        return this;
    }

    public String getDiscoveryGroupName() {
        return this.discoveryGroupName;
    }

    public ClusterConnectionConfiguration setDiscoveryGroupName(String discoveryGroupName) {
        this.discoveryGroupName = discoveryGroupName;
        return this;
    }

    public long getRetryInterval() {
        return this.retryInterval;
    }

    public ClusterConnectionConfiguration setRetryInterval(long retryInterval) {
        this.retryInterval = retryInterval;
        return this;
    }

    public boolean isAllowDirectConnectionsOnly() {
        return this.allowDirectConnectionsOnly;
    }

    public ClusterConnectionConfiguration setAllowDirectConnectionsOnly(boolean allowDirectConnectionsOnly) {
        this.allowDirectConnectionsOnly = allowDirectConnectionsOnly;
        return this;
    }

    public int getMinLargeMessageSize() {
        return this.minLargeMessageSize;
    }

    public ClusterConnectionConfiguration setMinLargeMessageSize(int minLargeMessageSize) {
        this.minLargeMessageSize = minLargeMessageSize;
        return this;
    }

    public long getClusterNotificationInterval() {
        return this.clusterNotificationInterval;
    }

    public ClusterConnectionConfiguration setClusterNotificationInterval(long clusterNotificationInterval) {
        this.clusterNotificationInterval = clusterNotificationInterval;
        return this;
    }

    public int getClusterNotificationAttempts() {
        return this.clusterNotificationAttempts;
    }

    public ClusterConnectionConfiguration setClusterNotificationAttempts(int clusterNotificationAttempts) {
        this.clusterNotificationAttempts = clusterNotificationAttempts;
        return this;
    }

    public String getClientId() {
        return this.clientId;
    }

    public ClusterConnectionConfiguration setClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public int getTopologyScannerAttempts() {
        return this.topologyScannerAttempts;
    }

    public ClusterConnectionConfiguration setTopologyScannerAttempts(int topologyScannerAttempts) {
        this.topologyScannerAttempts = topologyScannerAttempts;
        return this;
    }

    public TransportConfiguration[] getTransportConfigurations(Configuration configuration) throws Exception {
        if (this.getCompositeMembers() != null) {
            URI[] members = this.getCompositeMembers().getComponents();
            LinkedList<TransportConfiguration> list = new LinkedList<TransportConfiguration>();
            for (URI member : members) {
                list.addAll(ConfigurationUtils.parseConnectorURI(null, member));
            }
            return list.toArray(new TransportConfiguration[list.size()]);
        }
        return this.staticConnectors != null ? configuration.getTransportConfigurations(this.staticConnectors) : null;
    }

    public DiscoveryGroupConfiguration getDiscoveryGroupConfiguration(Configuration configuration) {
        if (this.discoveryGroupName != null) {
            DiscoveryGroupConfiguration dg = configuration.getDiscoveryGroupConfigurations().get(this.discoveryGroupName);
            if (dg == null) {
                ActiveMQServerLogger.LOGGER.clusterConnectionNoDiscoveryGroup(this.discoveryGroupName);
                return null;
            }
            return dg;
        }
        return null;
    }

    public TransportConfiguration getTransportConfiguration(Configuration configuration) {
        TransportConfiguration connector = configuration.getConnectorConfigurations().get(this.getConnectorName());
        if (connector == null) {
            ActiveMQServerLogger.LOGGER.clusterConnectionNoConnector(this.connectorName);
            return null;
        }
        return connector;
    }

    public boolean validateConfiguration() {
        if (this.getName() == null) {
            ActiveMQServerLogger.LOGGER.clusterConnectionNotUnique();
            return false;
        }
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        result = 31 * result + (this.allowDirectConnectionsOnly ? 1231 : 1237);
        result = 31 * result + (int)(this.callFailoverTimeout ^ this.callFailoverTimeout >>> 32);
        result = 31 * result + (int)(this.callTimeout ^ this.callTimeout >>> 32);
        result = 31 * result + (int)(this.clientFailureCheckPeriod ^ this.clientFailureCheckPeriod >>> 32);
        result = 31 * result + this.clusterNotificationAttempts;
        result = 31 * result + (int)(this.clusterNotificationInterval ^ this.clusterNotificationInterval >>> 32);
        result = 31 * result + this.confirmationWindowSize;
        result = 31 * result + (int)(this.connectionTTL ^ this.connectionTTL >>> 32);
        result = 31 * result + (this.connectorName == null ? 0 : this.connectorName.hashCode());
        result = 31 * result + (this.discoveryGroupName == null ? 0 : this.discoveryGroupName.hashCode());
        result = 31 * result + (this.duplicateDetection ? 1231 : 1237);
        result = 31 * result + (this.messageLoadBalancingType == null ? 0 : this.messageLoadBalancingType.hashCode());
        result = 31 * result + this.maxHops;
        result = 31 * result + (int)(this.maxRetryInterval ^ this.maxRetryInterval >>> 32);
        result = 31 * result + this.minLargeMessageSize;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.initialConnectAttempts;
        result = 31 * result + this.reconnectAttempts;
        result = 31 * result + (int)(this.retryInterval ^ this.retryInterval >>> 32);
        long temp = Double.doubleToLongBits(this.retryIntervalMultiplier);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.staticConnectors == null ? 0 : this.staticConnectors.hashCode());
        result = 31 * result + (this.clientId == null ? 0 : this.clientId.hashCode());
        result = 31 * result + this.topologyScannerAttempts;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClusterConnectionConfiguration other = (ClusterConnectionConfiguration)obj;
        if (this.address == null ? other.address != null : !this.address.equals(other.address)) {
            return false;
        }
        if (this.allowDirectConnectionsOnly != other.allowDirectConnectionsOnly) {
            return false;
        }
        if (this.callFailoverTimeout != other.callFailoverTimeout) {
            return false;
        }
        if (this.callTimeout != other.callTimeout) {
            return false;
        }
        if (this.clientFailureCheckPeriod != other.clientFailureCheckPeriod) {
            return false;
        }
        if (this.clusterNotificationAttempts != other.clusterNotificationAttempts) {
            return false;
        }
        if (this.clusterNotificationInterval != other.clusterNotificationInterval) {
            return false;
        }
        if (this.confirmationWindowSize != other.confirmationWindowSize) {
            return false;
        }
        if (this.connectionTTL != other.connectionTTL) {
            return false;
        }
        if (this.connectorName == null ? other.connectorName != null : !this.connectorName.equals(other.connectorName)) {
            return false;
        }
        if (this.discoveryGroupName == null ? other.discoveryGroupName != null : !this.discoveryGroupName.equals(other.discoveryGroupName)) {
            return false;
        }
        if (this.duplicateDetection != other.duplicateDetection) {
            return false;
        }
        if (this.messageLoadBalancingType != other.messageLoadBalancingType) {
            return false;
        }
        if (this.maxHops != other.maxHops) {
            return false;
        }
        if (this.maxRetryInterval != other.maxRetryInterval) {
            return false;
        }
        if (this.minLargeMessageSize != other.minLargeMessageSize) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.initialConnectAttempts != other.initialConnectAttempts) {
            return false;
        }
        if (this.reconnectAttempts != other.reconnectAttempts) {
            return false;
        }
        if (this.retryInterval != other.retryInterval) {
            return false;
        }
        if (Double.doubleToLongBits(this.retryIntervalMultiplier) != Double.doubleToLongBits(other.retryIntervalMultiplier)) {
            return false;
        }
        if (this.staticConnectors == null ? other.staticConnectors != null : !this.staticConnectors.equals(other.staticConnectors)) {
            return false;
        }
        if (this.clientId == null ? other.clientId != null : !this.clientId.equals(other.clientId)) {
            return false;
        }
        return this.topologyScannerAttempts == other.topologyScannerAttempts;
    }

    public String toString() {
        return "ClusterConnectionConfiguration{name='" + this.name + "', address='" + this.address + "', connectorName='" + this.connectorName + "', clientFailureCheckPeriod=" + this.clientFailureCheckPeriod + ", connectionTTL=" + this.connectionTTL + ", retryInterval=" + this.retryInterval + ", retryIntervalMultiplier=" + this.retryIntervalMultiplier + ", maxRetryInterval=" + this.maxRetryInterval + ", initialConnectAttempts=" + this.initialConnectAttempts + ", reconnectAttempts=" + this.reconnectAttempts + ", callTimeout=" + this.callTimeout + ", callFailoverTimeout=" + this.callFailoverTimeout + ", duplicateDetection=" + this.duplicateDetection + ", messageLoadBalancingType=" + String.valueOf((Object)this.messageLoadBalancingType) + ", compositeMembers=" + String.valueOf(this.compositeMembers) + ", staticConnectors=" + String.valueOf(this.staticConnectors) + ", discoveryGroupName='" + this.discoveryGroupName + "', maxHops=" + this.maxHops + ", confirmationWindowSize=" + this.confirmationWindowSize + ", allowDirectConnectionsOnly=" + this.allowDirectConnectionsOnly + ", minLargeMessageSize=" + this.minLargeMessageSize + ", clusterNotificationInterval=" + this.clusterNotificationInterval + ", clusterNotificationAttempts=" + this.clusterNotificationAttempts + ", clientId=" + this.clientId + ", topologyScannerInterval=" + this.topologyScannerAttempts + "}";
    }
}

