/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.complex;

import java.util.Random;
import org.apache.commons.math3.complex.Quaternion;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.ZeroException;
import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.geometry.euclidean.threed.Rotation;
import org.apache.commons.math3.geometry.euclidean.threed.RotationConvention;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public class QuaternionTest {
    private static final double EPS = Math.ulp(1.0);
    private static final double COMPARISON_EPS = 1.0E-14;

    @Test
    public final void testAccessors1() {
        double q0 = 2.0;
        double q1 = 5.4;
        double q2 = 17.0;
        double q3 = 5.0E-4;
        Quaternion q = new Quaternion(2.0, 5.4, 17.0, 5.0E-4);
        Assert.assertEquals((double)2.0, (double)q.getQ0(), (double)0.0);
        Assert.assertEquals((double)5.4, (double)q.getQ1(), (double)0.0);
        Assert.assertEquals((double)17.0, (double)q.getQ2(), (double)0.0);
        Assert.assertEquals((double)5.0E-4, (double)q.getQ3(), (double)0.0);
    }

    @Test
    public final void testAccessors2() {
        double q0 = 2.0;
        double q1 = 5.4;
        double q2 = 17.0;
        double q3 = 5.0E-4;
        Quaternion q = new Quaternion(2.0, 5.4, 17.0, 5.0E-4);
        double sP = q.getScalarPart();
        double[] vP = q.getVectorPart();
        Assert.assertEquals((double)2.0, (double)sP, (double)0.0);
        Assert.assertEquals((double)5.4, (double)vP[0], (double)0.0);
        Assert.assertEquals((double)17.0, (double)vP[1], (double)0.0);
        Assert.assertEquals((double)5.0E-4, (double)vP[2], (double)0.0);
    }

    @Test
    public final void testAccessors3() {
        double q0 = 2.0;
        double q1 = 5.4;
        double q2 = 17.0;
        double q3 = 5.0E-4;
        Quaternion q = new Quaternion(2.0, new double[]{5.4, 17.0, 5.0E-4});
        double sP = q.getScalarPart();
        double[] vP = q.getVectorPart();
        Assert.assertEquals((double)2.0, (double)sP, (double)0.0);
        Assert.assertEquals((double)5.4, (double)vP[0], (double)0.0);
        Assert.assertEquals((double)17.0, (double)vP[1], (double)0.0);
        Assert.assertEquals((double)5.0E-4, (double)vP[2], (double)0.0);
    }

    @Test(expected=DimensionMismatchException.class)
    public void testWrongDimension() {
        new Quaternion(new double[]{1.0, 2.0});
    }

    @Test
    public final void testConjugate() {
        double q0 = 2.0;
        double q1 = 5.4;
        double q2 = 17.0;
        double q3 = 5.0E-4;
        Quaternion q = new Quaternion(2.0, 5.4, 17.0, 5.0E-4);
        Quaternion qConjugate = q.getConjugate();
        Assert.assertEquals((double)2.0, (double)qConjugate.getQ0(), (double)0.0);
        Assert.assertEquals((double)-5.4, (double)qConjugate.getQ1(), (double)0.0);
        Assert.assertEquals((double)-17.0, (double)qConjugate.getQ2(), (double)0.0);
        Assert.assertEquals((double)-5.0E-4, (double)qConjugate.getQ3(), (double)0.0);
    }

    @Test
    public final void testProductQuaternionQuaternion() {
        Quaternion qA = new Quaternion(1.0, 0.5, -3.0, 4.0);
        Quaternion qB = new Quaternion(6.0, 2.0, 1.0, -9.0);
        Quaternion qResult = Quaternion.multiply((Quaternion)qA, (Quaternion)qB);
        Assert.assertEquals((double)44.0, (double)qResult.getQ0(), (double)EPS);
        Assert.assertEquals((double)28.0, (double)qResult.getQ1(), (double)EPS);
        Assert.assertEquals((double)-4.5, (double)qResult.getQ2(), (double)EPS);
        Assert.assertEquals((double)21.5, (double)qResult.getQ3(), (double)EPS);
        Vector3D vectorA = new Vector3D(qA.getVectorPart());
        Vector3D vectorB = new Vector3D(qB.getVectorPart());
        Vector3D vectorResult = new Vector3D(qResult.getVectorPart());
        double scalarPartRef = qA.getScalarPart() * qB.getScalarPart() - Vector3D.dotProduct((Vector3D)vectorA, (Vector3D)vectorB);
        Assert.assertEquals((double)scalarPartRef, (double)qResult.getScalarPart(), (double)EPS);
        Vector3D vectorPartRef = vectorA.scalarMultiply(qB.getScalarPart()).add((Vector)vectorB.scalarMultiply(qA.getScalarPart())).add((Vector)Vector3D.crossProduct((Vector3D)vectorA, (Vector3D)vectorB));
        double norm = vectorResult.subtract((Vector)vectorPartRef).getNorm();
        Assert.assertEquals((double)0.0, (double)norm, (double)EPS);
        Quaternion conjugateOfProduct = qB.getConjugate().multiply(qA.getConjugate());
        Quaternion productOfConjugate = qA.multiply(qB).getConjugate();
        Assert.assertEquals((double)conjugateOfProduct.getQ0(), (double)productOfConjugate.getQ0(), (double)EPS);
        Assert.assertEquals((double)conjugateOfProduct.getQ1(), (double)productOfConjugate.getQ1(), (double)EPS);
        Assert.assertEquals((double)conjugateOfProduct.getQ2(), (double)productOfConjugate.getQ2(), (double)EPS);
        Assert.assertEquals((double)conjugateOfProduct.getQ3(), (double)productOfConjugate.getQ3(), (double)EPS);
    }

    @Test
    public final void testProductQuaternionVector() {
        Quaternion quaternion = new Quaternion(4.0, 7.0, -1.0, 2.0);
        double[] vector = new double[]{2.0, 1.0, 3.0};
        Quaternion qResultQxV = Quaternion.multiply((Quaternion)quaternion, (Quaternion)new Quaternion(vector));
        Assert.assertEquals((double)-19.0, (double)qResultQxV.getQ0(), (double)EPS);
        Assert.assertEquals((double)3.0, (double)qResultQxV.getQ1(), (double)EPS);
        Assert.assertEquals((double)-13.0, (double)qResultQxV.getQ2(), (double)EPS);
        Assert.assertEquals((double)21.0, (double)qResultQxV.getQ3(), (double)EPS);
        double[] vectorQ = quaternion.getVectorPart();
        double[] vectorResultQxV = qResultQxV.getVectorPart();
        double scalarPartRefQxV = -Vector3D.dotProduct((Vector3D)new Vector3D(vectorQ), (Vector3D)new Vector3D(vector));
        Assert.assertEquals((double)scalarPartRefQxV, (double)qResultQxV.getScalarPart(), (double)EPS);
        Vector3D vectorPartRefQxV = new Vector3D(vector).scalarMultiply(quaternion.getScalarPart()).add((Vector)Vector3D.crossProduct((Vector3D)new Vector3D(vectorQ), (Vector3D)new Vector3D(vector)));
        double normQxV = new Vector3D(vectorResultQxV).subtract((Vector)vectorPartRefQxV).getNorm();
        Assert.assertEquals((double)0.0, (double)normQxV, (double)EPS);
        Quaternion qResultVxQ = Quaternion.multiply((Quaternion)new Quaternion(vector), (Quaternion)quaternion);
        Assert.assertEquals((double)-19.0, (double)qResultVxQ.getQ0(), (double)EPS);
        Assert.assertEquals((double)13.0, (double)qResultVxQ.getQ1(), (double)EPS);
        Assert.assertEquals((double)21.0, (double)qResultVxQ.getQ2(), (double)EPS);
        Assert.assertEquals((double)3.0, (double)qResultVxQ.getQ3(), (double)EPS);
        double[] vectorResultVxQ = qResultVxQ.getVectorPart();
        double scalarPartRefVxQ = -Vector3D.dotProduct((Vector3D)new Vector3D(vectorQ), (Vector3D)new Vector3D(vector));
        Assert.assertEquals((double)scalarPartRefVxQ, (double)qResultVxQ.getScalarPart(), (double)EPS);
        Vector3D vectorPartRefVxQ = new Vector3D(vector).scalarMultiply(quaternion.getScalarPart()).add((Vector)Vector3D.crossProduct((Vector3D)new Vector3D(vector), (Vector3D)new Vector3D(vectorQ)));
        double normVxQ = new Vector3D(vectorResultVxQ).subtract((Vector)vectorPartRefVxQ).getNorm();
        Assert.assertEquals((double)0.0, (double)normVxQ, (double)EPS);
    }

    @Test
    public final void testDotProductQuaternionQuaternion() {
        double expected = -6.0;
        Quaternion q1 = new Quaternion(1.0, 2.0, 2.0, 1.0);
        Quaternion q2 = new Quaternion(3.0, -2.0, -1.0, -3.0);
        double actual1 = Quaternion.dotProduct((Quaternion)q1, (Quaternion)q2);
        double actual2 = q1.dotProduct(q2);
        Assert.assertEquals((double)-6.0, (double)actual1, (double)EPS);
        Assert.assertEquals((double)-6.0, (double)actual2, (double)EPS);
    }

    @Test
    public final void testScalarMultiplyDouble() {
        double w = 1.6;
        double x = -4.8;
        double y = 11.2;
        double z = 2.56;
        Quaternion q1 = new Quaternion(0.5, -1.5, 3.5, 0.8);
        double a = 3.2;
        Quaternion q = q1.multiply(3.2);
        Assert.assertEquals((double)1.6, (double)q.getQ0(), (double)1.0E-14);
        Assert.assertEquals((double)-4.8, (double)q.getQ1(), (double)1.0E-14);
        Assert.assertEquals((double)11.2, (double)q.getQ2(), (double)1.0E-14);
        Assert.assertEquals((double)2.56, (double)q.getQ3(), (double)1.0E-14);
    }

    @Test
    public final void testAddQuaternionQuaternion() {
        double w = 4.0;
        double x = -1.0;
        double y = 2.0;
        double z = -4.0;
        Quaternion q1 = new Quaternion(1.0, 2.0, -2.0, -1.0);
        Quaternion q2 = new Quaternion(3.0, -3.0, 4.0, -3.0);
        Quaternion qa = Quaternion.add((Quaternion)q1, (Quaternion)q2);
        Quaternion qb = q1.add(q2);
        Assert.assertEquals((double)4.0, (double)qa.getQ0(), (double)EPS);
        Assert.assertEquals((double)-1.0, (double)qa.getQ1(), (double)EPS);
        Assert.assertEquals((double)2.0, (double)qa.getQ2(), (double)EPS);
        Assert.assertEquals((double)-4.0, (double)qa.getQ3(), (double)EPS);
        Assert.assertEquals((double)4.0, (double)qb.getQ0(), (double)EPS);
        Assert.assertEquals((double)-1.0, (double)qb.getQ1(), (double)EPS);
        Assert.assertEquals((double)2.0, (double)qb.getQ2(), (double)EPS);
        Assert.assertEquals((double)-4.0, (double)qb.getQ3(), (double)EPS);
    }

    @Test
    public final void testSubtractQuaternionQuaternion() {
        double w = -2.0;
        double x = 5.0;
        double y = -6.0;
        double z = 2.0;
        Quaternion q1 = new Quaternion(1.0, 2.0, -2.0, -1.0);
        Quaternion q2 = new Quaternion(3.0, -3.0, 4.0, -3.0);
        Quaternion qa = Quaternion.subtract((Quaternion)q1, (Quaternion)q2);
        Quaternion qb = q1.subtract(q2);
        Assert.assertEquals((double)-2.0, (double)qa.getQ0(), (double)EPS);
        Assert.assertEquals((double)5.0, (double)qa.getQ1(), (double)EPS);
        Assert.assertEquals((double)-6.0, (double)qa.getQ2(), (double)EPS);
        Assert.assertEquals((double)2.0, (double)qa.getQ3(), (double)EPS);
        Assert.assertEquals((double)-2.0, (double)qb.getQ0(), (double)EPS);
        Assert.assertEquals((double)5.0, (double)qb.getQ1(), (double)EPS);
        Assert.assertEquals((double)-6.0, (double)qb.getQ2(), (double)EPS);
        Assert.assertEquals((double)2.0, (double)qb.getQ3(), (double)EPS);
    }

    @Test
    public final void testNorm() {
        double q0 = 2.0;
        double q1 = 1.0;
        double q2 = -4.0;
        double q3 = 3.0;
        Quaternion q = new Quaternion(2.0, 1.0, -4.0, 3.0);
        double norm = q.getNorm();
        Assert.assertEquals((double)FastMath.sqrt((double)30.0), (double)norm, (double)0.0);
        double normSquareRef = Quaternion.multiply((Quaternion)q, (Quaternion)q.getConjugate()).getScalarPart();
        Assert.assertEquals((double)FastMath.sqrt((double)normSquareRef), (double)norm, (double)0.0);
    }

    @Test
    public final void testNormalize() {
        Quaternion q = new Quaternion(2.0, 1.0, -4.0, -2.0);
        Quaternion versor = q.normalize();
        Assert.assertEquals((double)0.4, (double)versor.getQ0(), (double)0.0);
        Assert.assertEquals((double)0.2, (double)versor.getQ1(), (double)0.0);
        Assert.assertEquals((double)-0.8, (double)versor.getQ2(), (double)0.0);
        Assert.assertEquals((double)-0.4, (double)versor.getQ3(), (double)0.0);
        Assert.assertEquals((double)1.0, (double)versor.getNorm(), (double)0.0);
    }

    @Test(expected=ZeroException.class)
    public final void testNormalizeFail() {
        Quaternion zeroQ = new Quaternion(0.0, 0.0, 0.0, 0.0);
        zeroQ.normalize();
    }

    @Test
    public final void testObjectEquals() {
        double one = 1.0;
        Quaternion q1 = new Quaternion(1.0, 1.0, 1.0, 1.0);
        Assert.assertTrue((boolean)q1.equals((Object)q1));
        Quaternion q2 = new Quaternion(1.0, 1.0, 1.0, 1.0);
        Assert.assertTrue((boolean)q2.equals((Object)q1));
        Quaternion q3 = new Quaternion(1.0, FastMath.nextUp((double)1.0), 1.0, 1.0);
        Assert.assertFalse((boolean)q3.equals((Object)q1));
    }

    @Test
    public final void testQuaternionEquals() {
        double inc = 1.0E-5;
        Quaternion q1 = new Quaternion(2.0, 1.0, -4.0, -2.0);
        Quaternion q2 = new Quaternion(q1.getQ0() + 1.0E-5, q1.getQ1(), q1.getQ2(), q1.getQ3());
        Quaternion q3 = new Quaternion(q1.getQ0(), q1.getQ1() + 1.0E-5, q1.getQ2(), q1.getQ3());
        Quaternion q4 = new Quaternion(q1.getQ0(), q1.getQ1(), q1.getQ2() + 1.0E-5, q1.getQ3());
        Quaternion q5 = new Quaternion(q1.getQ0(), q1.getQ1(), q1.getQ2(), q1.getQ3() + 1.0E-5);
        Assert.assertFalse((boolean)q1.equals(q2, 9.0E-6));
        Assert.assertFalse((boolean)q1.equals(q3, 9.0E-6));
        Assert.assertFalse((boolean)q1.equals(q4, 9.0E-6));
        Assert.assertFalse((boolean)q1.equals(q5, 9.0E-6));
        Assert.assertTrue((boolean)q1.equals(q2, 1.1000000000000001E-5));
        Assert.assertTrue((boolean)q1.equals(q3, 1.1000000000000001E-5));
        Assert.assertTrue((boolean)q1.equals(q4, 1.1000000000000001E-5));
        Assert.assertTrue((boolean)q1.equals(q5, 1.1000000000000001E-5));
    }

    @Test
    public final void testQuaternionEquals2() {
        Quaternion q1 = new Quaternion(1.0, 4.0, 2.0, 3.0);
        double gap = 1.0E-5;
        Quaternion q2 = new Quaternion(1.00001, 4.00001, 2.00001, 3.00001);
        Assert.assertTrue((boolean)q1.equals(q2, 1.0E-4));
        Assert.assertFalse((boolean)q1.equals(q2, 1.0E-5));
        Assert.assertFalse((boolean)q1.equals(q2, 1.0000000000000002E-6));
    }

    @Test
    public final void testIsUnitQuaternion() {
        Random r = new Random(48L);
        int numberOfTrials = 1000;
        for (int i = 0; i < 1000; ++i) {
            Quaternion q1 = new Quaternion(r.nextDouble(), r.nextDouble(), r.nextDouble(), r.nextDouble());
            Quaternion q2 = q1.normalize();
            Assert.assertTrue((boolean)q2.isUnitQuaternion(1.0E-14));
        }
        Quaternion q = new Quaternion(1.0, 1.0, 1.0, 1.0);
        Assert.assertFalse((boolean)q.isUnitQuaternion(1.0E-14));
    }

    @Test
    public final void testIsPureQuaternion() {
        Quaternion q1 = new Quaternion(0.0, 5.0, 4.0, 8.0);
        Assert.assertTrue((boolean)q1.isPureQuaternion(EPS));
        Quaternion q2 = new Quaternion(0.0 - EPS, 5.0, 4.0, 8.0);
        Assert.assertTrue((boolean)q2.isPureQuaternion(EPS));
        Quaternion q3 = new Quaternion(0.0 - 1.1 * EPS, 5.0, 4.0, 8.0);
        Assert.assertFalse((boolean)q3.isPureQuaternion(EPS));
        Random r = new Random(48L);
        double[] v = new double[]{r.nextDouble(), r.nextDouble(), r.nextDouble()};
        Quaternion q4 = new Quaternion(v);
        Assert.assertTrue((boolean)q4.isPureQuaternion(0.0));
        Quaternion q5 = new Quaternion(0.0, v);
        Assert.assertTrue((boolean)q5.isPureQuaternion(0.0));
    }

    @Test
    public final void testPolarForm() {
        Random r = new Random(48L);
        int numberOfTrials = 1000;
        for (int i = 0; i < 1000; ++i) {
            Quaternion q = new Quaternion(2.0 * (r.nextDouble() - 0.5), 2.0 * (r.nextDouble() - 0.5), 2.0 * (r.nextDouble() - 0.5), 2.0 * (r.nextDouble() - 0.5));
            Quaternion qP = q.getPositivePolarForm();
            Assert.assertTrue((boolean)qP.isUnitQuaternion(1.0E-14));
            Assert.assertTrue((qP.getQ0() >= 0.0 ? 1 : 0) != 0);
            Rotation rot = new Rotation(q.getQ0(), q.getQ1(), q.getQ2(), q.getQ3(), true);
            Rotation rotP = new Rotation(qP.getQ0(), qP.getQ1(), qP.getQ2(), qP.getQ3(), true);
            Assert.assertEquals((double)rot.getAngle(), (double)rotP.getAngle(), (double)1.0E-14);
            Assert.assertEquals((double)rot.getAxis(RotationConvention.VECTOR_OPERATOR).getX(), (double)rot.getAxis(RotationConvention.VECTOR_OPERATOR).getX(), (double)1.0E-14);
            Assert.assertEquals((double)rot.getAxis(RotationConvention.VECTOR_OPERATOR).getY(), (double)rot.getAxis(RotationConvention.VECTOR_OPERATOR).getY(), (double)1.0E-14);
            Assert.assertEquals((double)rot.getAxis(RotationConvention.VECTOR_OPERATOR).getZ(), (double)rot.getAxis(RotationConvention.VECTOR_OPERATOR).getZ(), (double)1.0E-14);
        }
    }

    @Test
    public final void testGetInverse() {
        Quaternion q = new Quaternion(1.5, 4.0, 2.0, -2.5);
        Quaternion inverseQ = q.getInverse();
        Assert.assertEquals((double)0.05263157894736842, (double)inverseQ.getQ0(), (double)0.0);
        Assert.assertEquals((double)-0.14035087719298245, (double)inverseQ.getQ1(), (double)0.0);
        Assert.assertEquals((double)-0.07017543859649122, (double)inverseQ.getQ2(), (double)0.0);
        Assert.assertEquals((double)0.08771929824561403, (double)inverseQ.getQ3(), (double)0.0);
        Quaternion product = Quaternion.multiply((Quaternion)inverseQ, (Quaternion)q);
        Assert.assertEquals((double)1.0, (double)product.getQ0(), (double)EPS);
        Assert.assertEquals((double)0.0, (double)product.getQ1(), (double)EPS);
        Assert.assertEquals((double)0.0, (double)product.getQ2(), (double)EPS);
        Assert.assertEquals((double)0.0, (double)product.getQ3(), (double)EPS);
        Quaternion qNul = new Quaternion(0.0, 0.0, 0.0, 0.0);
        try {
            Quaternion inverseQNul = qNul.getInverse();
            Assert.fail((String)("expecting ZeroException but got : " + inverseQNul));
        }
        catch (ZeroException zeroException) {
            // empty catch block
        }
    }

    @Test
    public final void testToString() {
        Quaternion q = new Quaternion(1.0, 2.0, 3.0, 4.0);
        Assert.assertTrue((boolean)q.toString().equals("[1.0 2.0 3.0 4.0]"));
    }
}

