/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.worker.http.api.v1;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.Serializable;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.apache.celeborn.common.meta.WorkerInfo;
import org.apache.celeborn.rest.v1.model.HandleResponse;
import org.apache.celeborn.rest.v1.model.UnAvailablePeersResponse;
import org.apache.celeborn.rest.v1.model.WorkerExitRequest;
import org.apache.celeborn.rest.v1.model.WorkerInfoResponse;
import org.apache.celeborn.rest.v1.model.WorkerTimestampData;
import org.apache.celeborn.server.common.HttpService;
import org.apache.celeborn.server.common.http.api.ApiRequestContext;
import org.apache.celeborn.server.common.http.api.v1.ApiUtils$;
import org.apache.celeborn.service.deploy.worker.Worker;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Iterable$;
import scala.reflect.ScalaSignature;

@Tag(name="Worker")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@ScalaSignature(bytes="\u0006\u0001\u0005Ud\u0001\u0002\u0004\b\u0001iAQa\u000b\u0001\u0005\u00021BQA\u0004\u0001\u0005\n=BQ\u0001\u000e\u0001\u0005\u0002UBQ!\u001f\u0001\u0005\u0002iDq!!\b\u0001\t\u0003\tyB\u0001\bX_J\\WM\u001d*fg>,(oY3\u000b\u0005!I\u0011A\u0001<2\u0015\tQ1\"A\u0002ba&T!\u0001D\u0007\u0002\t!$H\u000f\u001d\u0006\u0003\u001d=\taa^8sW\u0016\u0014(B\u0001\t\u0012\u0003\u0019!W\r\u001d7ps*\u0011!cE\u0001\bg\u0016\u0014h/[2f\u0015\t!R#\u0001\u0005dK2,'m\u001c:o\u0015\t1r#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00021\u0005\u0019qN]4\u0004\u0001M\u0019\u0001aG\u0011\u0011\u0005qyR\"A\u000f\u000b\u0003y\tQa]2bY\u0006L!\u0001I\u000f\u0003\r\u0005s\u0017PU3g!\t\u0011\u0013&D\u0001$\u0015\tQAE\u0003\u0002\rK)\u0011aeJ\u0001\u0007G>lWn\u001c8\u000b\u0005!\u001a\u0012AB:feZ,'/\u0003\u0002+G\t\t\u0012\t]5SKF,Xm\u001d;D_:$X\r\u001f;\u0002\rqJg.\u001b;?)\u0005i\u0003C\u0001\u0018\u0001\u001b\u00059Q#\u0001\u0019\u0011\u0005E\u0012T\"A\u0007\n\u0005Mj!AB,pe.,'/A\u0004x_J\\WM]:\u0015\u0003Y\u0002\"aN\u001f\u000e\u0003aR!!\u000f\u001e\u0002\u000b5|G-\u001a7\u000b\u0005!Y$B\u0001\u001f\u0014\u0003\u0011\u0011Xm\u001d;\n\u0005yB$AE,pe.,'/\u00138g_J+7\u000f]8og\u0016D#a\u0001!\u0011\u0005\u0005CU\"\u0001\"\u000b\u0005\r#\u0015A\u0001:t\u0015\t)e)\u0001\u0002xg*\tq)A\u0003kCZ\f\u00070\u0003\u0002J\u0005\n\u0019q)\u0012+)\r\rY5\f\u00180`!\ta\u0015,D\u0001N\u0015\tqu*A\u0005sKN\u0004xN\\:fg*\u0011\u0001+U\u0001\fC:tw\u000e^1uS>t7O\u0003\u0002S'\u0006\u0019q.Y:\u000b\u0005Q+\u0016A\u0001<4\u0015\t1v+A\u0004to\u0006<w-\u001a:\u000b\u0003a\u000b!![8\n\u0005ik%aC!qSJ+7\u000f]8og\u0016\fAB]3ta>t7/Z\"pI\u0016\f\u0013!X\u0001\u0004eA\u0002\u0014aB2p]R,g\u000e\u001e\u0017\u0002A.*\u0011m\u001a5kWB\u0011!-Z\u0007\u0002G*\u0011AmT\u0001\u0006[\u0016$\u0017.Y\u0005\u0003M\u000e\u0014qaQ8oi\u0016tG/A\u0005nK\u0012L\u0017\rV=qK\u0006\n\u0011.\u0001\tbaBd\u0017nY1uS>twF[:p]\u000611o\u00195f[\u0006\\3\u0001\\8q!\t\u0011W.\u0003\u0002oG\n11k\u00195f[\u0006\fa\"[7qY\u0016lWM\u001c;bi&|gnI\u00017Q\u0011\u0019!O^<\u0011\u0005M$X\"A(\n\u0005U|%!C(qKJ\fG/[8o\u0003-!Wm]2sSB$\u0018n\u001c8\"\u0003a\fA\u0004T5ti\u0002\"\b.\u001a\u0011x_J\\WM\u001d\u0011j]\u001a|'/\\1uS>tg&\u0001\fv]\u00064\u0018-\u001b7bE2,\u0007+Z3s/>\u00148.\u001a:t)\u0005Y\bCA\u001c}\u0013\ti\bH\u0001\rV]\u00063\u0018-\u001b7bE2,\u0007+Z3sgJ+7\u000f]8og\u0016Dc\u0001B@\u0002\u0006\u0005\u001d\u0001cA!\u0002\u0002%\u0019\u00111\u0001\"\u0003\tA\u000bG\u000f[\u0001\u0006m\u0006dW/Z\u0011\u0003\u0003\u0013\t!cL;oCZ\f\u0017\u000e\\1cY\u0016|\u0006/Z3sg\"\u0012A\u0001\u0011\u0015\b\t-[FLXA\bY\t\t\tb\u000b\u0004bO\"T\u00171C\u0016\u0005Y>\f)bI\u0001|Q\u0015!!O^A\rC\t\tY\"\u00012MSN$\b\u0005\u001e5fAUt\u0017M^1jY\u0006\u0014G.\u001a\u0011qK\u0016\u00148\u000fI8gAQDW\rI<pe.,'\u000f\f\u0011uQ&\u001c\b%\u00197xCf\u001c\b%\\3b]N\u0004C\u000f[3!o>\u00148.\u001a:!G>tg.Z2uAQ|\u0007\u0005\u001e5fAA,WM\u001d\u0011gC&dW\r\u001a\u0018\u0002\t\u0015D\u0018\u000e\u001e\u000b\u0005\u0003C\t9\u0003E\u00028\u0003GI1!!\n9\u00059A\u0015M\u001c3mKJ+7\u000f]8og\u0016Dq!!\u000b\u0006\u0001\u0004\tY#A\u0004sKF,Xm\u001d;\u0011\u0007]\ni#C\u0002\u00020a\u0012\u0011cV8sW\u0016\u0014X\t_5u%\u0016\fX/Z:uQ\u0019)q0!\u0002\u00024\u0005\u0012\u0011Q\u0004\u0015\u0004\u000b\u0005]\u0002cA!\u0002:%\u0019\u00111\b\"\u0003\tA{5\u000b\u0016\u0015\b\u000b-[FLXA Y\t\t\te\u000b\u0004bO\"T\u00171I\u0016\u0005Y>\f)e\t\u0002\u0002\"!*QA\u001d<\u0002J\u0005\u0012\u00111J\u0001`)JLwmZ3sAQD\u0017n\u001d\u0011x_J\\WM\u001d\u0011u_\u0002*\u00070\u001b;/A1+w-\u00197!KbLG\u000f\t;za\u0016\u001c\b%\u0019:fA\u001d\"UiQ(N\u001b&\u001b6+S(OO1\u0002se\u0012*B\u0007\u00163U\u000bT\u0014!C:$\u0007eJ%N\u001b\u0016#\u0015*\u0011+F\u0019f;c\u0006K\u0004\u0001\u0003\u001f\n)!!\u0016\u0011\u0007\u0005\u000b\t&C\u0002\u0002T\t\u0013\u0001bQ8ogVlWm\u001d\u0017\u0002Q\":\u0001!!\u0017\u0002\u0006\u0005}\u0003cA!\u0002\\%\u0019\u0011Q\f\"\u0003\u0011A\u0013x\u000eZ;dKNd\u0013\u0001\u001b\u0015\b\u0001\u0005\r\u0014qNA9!\u0011\t)'a\u001b\u000e\u0005\u0005\u001d$bAA5\u001f\u0006!A/Y4t\u0013\u0011\ti'a\u001a\u0003\u0007Q\u000bw-\u0001\u0003oC6,\u0017EAA:\u0003\u00199vN]6fe\u0002")
public class WorkerResource
implements ApiRequestContext {
    @Context
    private ServletContext servletContext;
    @Context
    private HttpServletRequest httpRequest;

    public final HttpService httpService() {
        return ApiRequestContext.httpService$((ApiRequestContext)this);
    }

    public String normalizeParam(String param) {
        return ApiRequestContext.normalizeParam$((ApiRequestContext)this, (String)param);
    }

    public ServletContext servletContext() {
        return this.servletContext;
    }

    public void servletContext_$eq(ServletContext x$1) {
        this.servletContext = x$1;
    }

    public HttpServletRequest httpRequest() {
        return this.httpRequest;
    }

    public void httpRequest_$eq(HttpServletRequest x$1) {
        this.httpRequest = x$1;
    }

    private Worker worker() {
        return (Worker)this.httpService();
    }

    @Operation(description="List the worker information.")
    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=WorkerInfoResponse.class))})
    @GET
    public WorkerInfoResponse workers() {
        return ApiUtils$.MODULE$.workerInfoResponse(this.worker().workerInfo(), this.worker().workerStatusManager().currentWorkerStatus(), this.worker().shutdown().get(), this.worker().registered().get());
    }

    @Operation(description="List the unavailable peers of the worker, this always means the worker connect to the peer failed.")
    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=UnAvailablePeersResponse.class))})
    @GET
    @Path(value="/unavailable_peers")
    public UnAvailablePeersResponse unavailablePeerWorkers() {
        return new UnAvailablePeersResponse().peers((List)JavaConverters$.MODULE$.seqAsJavaListConverter(((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.worker().unavailablePeers()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                WorkerInfo worker = (WorkerInfo)tuple2._1();
                long lastTimeout = tuple2._2$mcJ$sp();
                return new WorkerTimestampData().worker(ApiUtils$.MODULE$.workerData(worker)).timestamp(Predef$.MODULE$.long2Long(lastTimeout));
            }
            throw new MatchError((Object)tuple2);
        }, Iterable$.MODULE$.canBuildFrom())).toSeq()).asJava());
    }

    @Operation(description="Trigger this worker to exit. Legal exit types are 'DECOMMISSION', 'GRACEFUL' and 'IMMEDIATELY'.")
    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=HandleResponse.class))})
    @POST
    @Path(value="exit")
    public HandleResponse exit(WorkerExitRequest request) {
        return new HandleResponse().success(Predef$.MODULE$.boolean2Boolean(true)).message(this.httpService().exit(request.getType().toString()));
    }

    public WorkerResource() {
        ApiRequestContext.$init$((ApiRequestContext)this);
    }
}

