/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.meta;

import java.util.Objects;
import org.apache.celeborn.common.protocol.PbWorkerStatus;

public class WorkerStatus {
    private int stateValue;
    private long stateStartTime;

    public WorkerStatus(int stateValue, long stateStartTime) {
        this.stateValue = stateValue;
        this.stateStartTime = stateStartTime;
    }

    public int getStateValue() {
        return this.stateValue;
    }

    public PbWorkerStatus.State getState() {
        return PbWorkerStatus.State.forNumber(this.stateValue);
    }

    public long getStateStartTime() {
        return this.stateStartTime;
    }

    public static WorkerStatus normalWorkerStatus() {
        return new WorkerStatus(PbWorkerStatus.State.Normal.getNumber(), System.currentTimeMillis());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WorkerStatus)) {
            return false;
        }
        WorkerStatus that = (WorkerStatus)o;
        return this.getStateValue() == that.getStateValue() && this.getStateStartTime() == that.getStateStartTime();
    }

    public int hashCode() {
        return Objects.hash(this.getStateValue(), this.getStateStartTime());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WorkerStatus{");
        sb.append("state=").append((Object)this.getState());
        sb.append(", stateStartTime=").append(this.stateStartTime);
        sb.append('}');
        return sb.toString();
    }
}

