/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.worker.storage;

import java.io.File;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.exception.CelebornIOException;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.meta.DiskFileInfo;
import org.apache.celeborn.common.meta.FileInfo;
import org.apache.celeborn.common.meta.MemoryFileInfo;
import org.apache.celeborn.common.metrics.source.AbstractSource;
import org.apache.celeborn.common.protocol.PartitionLocation;
import org.apache.celeborn.common.protocol.PartitionType;
import org.apache.celeborn.common.protocol.StorageInfo;
import org.apache.celeborn.service.deploy.worker.memory.MemoryManager;
import org.apache.celeborn.service.deploy.worker.storage.DfsTierWriter;
import org.apache.celeborn.service.deploy.worker.storage.FlushNotifier;
import org.apache.celeborn.service.deploy.worker.storage.Flusher;
import org.apache.celeborn.service.deploy.worker.storage.LocalTierWriter;
import org.apache.celeborn.service.deploy.worker.storage.MapPartitionMetaHandler;
import org.apache.celeborn.service.deploy.worker.storage.MemoryTierWriter;
import org.apache.celeborn.service.deploy.worker.storage.PartitionDataWriterContext;
import org.apache.celeborn.service.deploy.worker.storage.PartitionMetaHandler;
import org.apache.celeborn.service.deploy.worker.storage.ReducePartitionMetaHandler;
import org.apache.celeborn.service.deploy.worker.storage.SegmentMapPartitionMetaHandler;
import org.apache.celeborn.service.deploy.worker.storage.StorageManager;
import org.apache.celeborn.service.deploy.worker.storage.TierWriterBase;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.GenSeqLike;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005%c\u0001\u0002\b\u0010\u0001yA\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\te\u0001\u0011\t\u0011)A\u0005g!Aq\u0007\u0001B\u0001B\u0003%\u0001\bC\u0003@\u0001\u0011\u0005\u0001\tC\u0004F\u0001\t\u0007I\u0011\u0002$\t\ry\u0003\u0001\u0015!\u0003H\u0011\u001dy\u0006A1A\u0005\n\u0001Da!\u001a\u0001!\u0002\u0013\t\u0007\"\u00024\u0001\t\u00039\u0007bBA\u0006\u0001\u0011\u0005\u0011Q\u0002\u0005\b\u0003\u0017\u0001A\u0011AA\u000b\u0011%\tY\u0003AI\u0001\n\u0003\ti\u0003C\u0005\u0002D\u0001\t\n\u0011\"\u0001\u0002F\ti1\u000b^8sC\u001e,\u0007k\u001c7jGfT!\u0001E\t\u0002\u000fM$xN]1hK*\u0011!cE\u0001\u0007o>\u00148.\u001a:\u000b\u0005Q)\u0012A\u00023fa2|\u0017P\u0003\u0002\u0017/\u000591/\u001a:wS\u000e,'B\u0001\r\u001a\u0003!\u0019W\r\\3c_Jt'B\u0001\u000e\u001c\u0003\u0019\t\u0007/Y2iK*\tA$A\u0002pe\u001e\u001c\u0001aE\u0002\u0001?\u0015\u0002\"\u0001I\u0012\u000e\u0003\u0005R\u0011AI\u0001\u0006g\u000e\fG.Y\u0005\u0003I\u0005\u0012a!\u00118z%\u00164\u0007C\u0001\u0014,\u001b\u00059#B\u0001\u0015*\u0003!Ig\u000e^3s]\u0006d'B\u0001\u0016\u0018\u0003\u0019\u0019w.\\7p]&\u0011Af\n\u0002\b\u0019><w-\u001b8h\u0003\u0011\u0019wN\u001c4\u0011\u0005=\u0002T\"A\u0015\n\u0005EJ#\u0001D\"fY\u0016\u0014wN\u001d8D_:4\u0017AD:u_J\fw-Z'b]\u0006<WM\u001d\t\u0003iUj\u0011aD\u0005\u0003m=\u0011ab\u0015;pe\u0006<W-T1oC\u001e,'/\u0001\u0004t_V\u00148-\u001a\t\u0003suj\u0011A\u000f\u0006\u0003omR!\u0001P\u0015\u0002\u000f5,GO]5dg&\u0011aH\u000f\u0002\u000f\u0003\n\u001cHO]1diN{WO]2f\u0003\u0019a\u0014N\\5u}Q!\u0011IQ\"E!\t!\u0004\u0001C\u0003.\t\u0001\u0007a\u0006C\u00033\t\u0001\u00071\u0007C\u00038\t\u0001\u0007\u0001(A\bde\u0016\fG/\u001a$jY\u0016|%\u000fZ3s+\u00059\u0005c\u0001\u0011I\u0015&\u0011\u0011*\t\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007-\u001bfK\u0004\u0002M#:\u0011Q\nU\u0007\u0002\u001d*\u0011q*H\u0001\u0007yI|w\u000e\u001e \n\u0003\tJ!AU\u0011\u0002\u000fA\f7m[1hK&\u0011A+\u0016\u0002\u0005\u0019&\u001cHO\u0003\u0002SCA\u0011qk\u0017\b\u00031f\u0003\"!T\u0011\n\u0005i\u000b\u0013A\u0002)sK\u0012,g-\u0003\u0002];\n11\u000b\u001e:j]\u001eT!AW\u0011\u0002!\r\u0014X-\u0019;f\r&dWm\u0014:eKJ\u0004\u0013AD3wS\u000e$h)\u001b7f\u001fJ$WM]\u000b\u0002CB\u0019\u0001\u0005\u00132\u0011\t]\u001bgKS\u0005\u0003Iv\u00131!T1q\u0003=)g/[2u\r&dWm\u0014:eKJ\u0004\u0013\u0001F4fi\u00163\u0018n\u0019;fI\u001aKG.Z,sSR,'\u000f\u0006\u0004iW6\u0014\u0018\u0011\u0001\t\u0003i%L!A[\b\u0003\u001dQKWM],sSR,'OQ1tK\")A.\u0003a\u0001Q\u0006a1-\u001a7fE>\u0014hNR5mK\")a.\u0003a\u0001_\u0006Q\u0002/\u0019:uSRLwN\u001c#bi\u0006<&/\u001b;fe\u000e{g\u000e^3yiB\u0011A\u0007]\u0005\u0003c>\u0011!\u0004U1si&$\u0018n\u001c8ECR\fwK]5uKJ\u001cuN\u001c;fqRDQa]\u0005A\u0002Q\f\u0001C\\;n!\u0016tG-\u001b8h/JLG/Z:\u0011\u0005UtX\"\u0001<\u000b\u0005]D\u0018AB1u_6L7M\u0003\u0002zu\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005md\u0018\u0001B;uS2T\u0011!`\u0001\u0005U\u00064\u0018-\u0003\u0002\u0000m\ni\u0011\t^8nS\u000eLe\u000e^3hKJDq!a\u0001\n\u0001\u0004\t)!\u0001\u0005o_RLg-[3s!\r!\u0014qA\u0005\u0004\u0003\u0013y!!\u0004$mkNDgj\u001c;jM&,'/\u0001\tde\u0016\fG/\u001a$jY\u0016<&/\u001b;feR9\u0001.a\u0004\u0002\u0012\u0005M\u0001\"\u00028\u000b\u0001\u0004y\u0007\"B:\u000b\u0001\u0004!\bbBA\u0002\u0015\u0001\u0007\u0011Q\u0001\u000b\fQ\u0006]\u0011\u0011DA\u000e\u0003;\t\t\u0003C\u0003o\u0017\u0001\u0007q\u000eC\u0003t\u0017\u0001\u0007A\u000fC\u0004\u0002\u0004-\u0001\r!!\u0002\t\u0011\u0005}1\u0002%AA\u0002\u001d\u000bQa\u001c:eKJD\u0011\"a\t\f!\u0003\u0005\r!!\n\u0002\u000b\u00154\u0018n\u0019;\u0011\u0007\u0001\n9#C\u0002\u0002*\u0005\u0012qAQ8pY\u0016\fg.\u0001\u000ede\u0016\fG/\u001a$jY\u0016<&/\u001b;fe\u0012\"WMZ1vYR$C'\u0006\u0002\u00020)\u001aq)!\r,\u0005\u0005M\u0002\u0003BA\u001b\u0003\u007fi!!a\u000e\u000b\t\u0005e\u00121H\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u0010\"\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u0003\n9DA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f!d\u0019:fCR,g)\u001b7f/JLG/\u001a:%I\u00164\u0017-\u001e7uIU*\"!a\u0012+\t\u0005\u0015\u0012\u0011\u0007")
public class StoragePolicy
implements Logging {
    private final CelebornConf conf;
    private final StorageManager storageManager;
    private final AbstractSource source;
    private final Option<List<String>> createFileOrder;
    private final Option<Map<String, List<String>>> evictFileOrder;
    private transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    private Logger log$lzycompute() {
        StoragePolicy storagePolicy = this;
        synchronized (storagePolicy) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    public Logger log() {
        if (!this.bitmap$trans$0) {
            return this.log$lzycompute();
        }
        return this.log;
    }

    private Option<List<String>> createFileOrder() {
        return this.createFileOrder;
    }

    private Option<Map<String, List<String>>> evictFileOrder() {
        return this.evictFileOrder;
    }

    public TierWriterBase getEvictedFileWriter(TierWriterBase celebornFile, PartitionDataWriterContext partitionDataWriterContext, AtomicInteger numPendingWrites, FlushNotifier notifier) {
        TierWriterBase tierWriterBase;
        Object object = new Object();
        try {
            this.evictFileOrder().foreach((Function1 & Serializable & scala.Serializable)order -> {
                StoragePolicy.$anonfun$getEvictedFileWriter$1(this, celebornFile, object, partitionDataWriterContext, numPendingWrites, notifier, order);
                return BoxedUnit.UNIT;
            });
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Create evict file failed for ").append(partitionDataWriterContext.getPartitionLocation()).toString());
            tierWriterBase = null;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                tierWriterBase = (TierWriterBase)ex.value();
            }
            throw ex;
        }
        return tierWriterBase;
    }

    public TierWriterBase createFileWriter(PartitionDataWriterContext partitionDataWriterContext, AtomicInteger numPendingWrites, FlushNotifier notifier) {
        return this.createFileWriter(partitionDataWriterContext, numPendingWrites, notifier, this.createFileOrder(), this.createFileWriter$default$5());
    }

    public TierWriterBase createFileWriter(PartitionDataWriterContext partitionDataWriterContext, AtomicInteger numPendingWrites, FlushNotifier notifier, Option<List<String>> order, boolean evict) {
        Object object = new Object();
        try {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("create file for ").append(partitionDataWriterContext.getShuffleKey()).append(" ").append(partitionDataWriterContext.getPartitionLocation().getFileName()).toString());
            PartitionLocation location = partitionDataWriterContext.getPartitionLocation();
            if (location == null) {
                throw new IllegalStateException("Partition data writer context can not have null partition location");
            }
            if (order.isEmpty()) {
                throw new CelebornIOException("Create file order can not be empty, check your configs");
            }
            int tryCreateFileTypeIndex = evict ? 0 : (order.exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.contains((Object)StorageInfo.Type.MEMORY.name()))) ? ((GenSeqLike)order.get()).indexOf((Object)StorageInfo.Type.MEMORY.name()) : ((GenSeqLike)order.get()).indexOf((Object)partitionDataWriterContext.getPartitionLocation().getStorageInfo().getType().name()));
            int maxSize = ((LinearSeqOptimized)order.get()).length();
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(tryCreateFileTypeIndex), maxSize).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                String storageStr = (String)((LinearSeqOptimized)order.get()).apply(i);
                StorageInfo.Type storageInfoType = StorageInfo.fromStrToType((String)storageStr);
                TierWriterBase file = this.tryCreateFileByType$1(storageInfoType, location, partitionDataWriterContext, numPendingWrites, notifier);
                if (file != null) {
                    throw new NonLocalReturnControl(object, (Object)file);
                }
            });
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Could not create file for storage type ").append(location.getStorageInfo().getType()).toString());
            throw new CelebornIOException(new StringBuilder(31).append("Create file failed for context ").append(partitionDataWriterContext.toString()).toString());
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() != object) {
                throw ex;
            }
            return (TierWriterBase)ex.value();
        }
    }

    public Option<List<String>> createFileWriter$default$4() {
        return this.createFileOrder();
    }

    public boolean createFileWriter$default$5() {
        return false;
    }

    public static final /* synthetic */ void $anonfun$getEvictedFileWriter$1(StoragePolicy $this, TierWriterBase celebornFile$1, Object nonLocalReturnKey1$1, PartitionDataWriterContext partitionDataWriterContext$1, AtomicInteger numPendingWrites$1, FlushNotifier notifier$1, Map order) {
        Option orderList = order.get((Object)celebornFile$1.storageType().name());
        if (orderList != null) {
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)$this.createFileWriter(partitionDataWriterContext$1, numPendingWrites$1, notifier$1, (Option<List<String>>)orderList, true));
        }
    }

    private static final PartitionMetaHandler getPartitionMetaHandler$1(FileInfo fileInfo, PartitionDataWriterContext partitionDataWriterContext$2, FlushNotifier notifier$2) {
        PartitionType partitionType = partitionDataWriterContext$2.getPartitionType();
        if (PartitionType.REDUCE.equals(partitionType)) {
            return new ReducePartitionMetaHandler(partitionDataWriterContext$2.isRangeReadFilter(), fileInfo);
        }
        if (PartitionType.MAP.equals(partitionType)) {
            if (partitionDataWriterContext$2.isSegmentGranularityVisible()) {
                return new SegmentMapPartitionMetaHandler((DiskFileInfo)fileInfo, notifier$2);
            }
            return new MapPartitionMetaHandler((DiskFileInfo)fileInfo, notifier$2);
        }
        if (PartitionType.MAPGROUP.equals(partitionType)) {
            return null;
        }
        throw new MatchError((Object)partitionType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final TierWriterBase tryCreateFileByType$1(StorageInfo.Type storageInfoType, PartitionLocation location$1, PartitionDataWriterContext partitionDataWriterContext$2, AtomicInteger numPendingWrites$2, FlushNotifier notifier$2) {
        try {
            PartitionMetaHandler metaHandler;
            DiskFileInfo diskFileInfo;
            Flusher flusher;
            TierWriterBase tierWriterBase;
            block8: {
                block7: {
                    StorageInfo.Type type = storageInfoType;
                    if (StorageInfo.Type.MEMORY.equals(type)) {
                        if (!location$1.getStorageInfo().memoryAvailable()) return null;
                        if (!MemoryManager.instance().memoryFileStorageAvailable()) return null;
                        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Create memory file for ").append(partitionDataWriterContext$2.getShuffleKey()).append(" ").append(partitionDataWriterContext$2.getPartitionLocation().getFileName()).toString());
                        MemoryFileInfo memoryFileInfo = this.storageManager.createMemoryFileInfo(partitionDataWriterContext$2.getAppId(), partitionDataWriterContext$2.getShuffleId(), location$1.getFileName(), partitionDataWriterContext$2.getUserIdentifier(), partitionDataWriterContext$2.getPartitionType(), partitionDataWriterContext$2.isPartitionSplitEnabled());
                        PartitionMetaHandler metaHandler2 = StoragePolicy.getPartitionMetaHandler$1((FileInfo)memoryFileInfo, partitionDataWriterContext$2, notifier$2);
                        tierWriterBase = new MemoryTierWriter(this.conf, metaHandler2, numPendingWrites$2, notifier$2, this.source, memoryFileInfo, storageInfoType, partitionDataWriterContext$2, this.storageManager);
                        return tierWriterBase;
                    }
                    if (!(StorageInfo.Type.HDD.equals(type) ? true : (StorageInfo.Type.SSD.equals(type) ? true : (StorageInfo.Type.HDFS.equals(type) ? true : (StorageInfo.Type.OSS.equals(type) ? true : StorageInfo.Type.S3.equals(type)))))) throw new MatchError((Object)type);
                    if (!this.storageManager.localOrDfsStorageAvailable()) return null;
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("create non-memory file for ").append(partitionDataWriterContext$2.getShuffleKey()).append(" ").append(partitionDataWriterContext$2.getPartitionLocation().getFileName()).toString());
                    Tuple3<Flusher, DiskFileInfo, File> tuple3 = this.storageManager.createDiskFile(location$1, partitionDataWriterContext$2.getAppId(), partitionDataWriterContext$2.getShuffleId(), location$1.getFileName(), partitionDataWriterContext$2.getUserIdentifier(), partitionDataWriterContext$2.getPartitionType(), partitionDataWriterContext$2.isPartitionSplitEnabled());
                    if (tuple3 == null) throw new MatchError(tuple3);
                    Flusher flusher2 = (Flusher)tuple3._1();
                    DiskFileInfo diskFileInfo2 = (DiskFileInfo)tuple3._2();
                    File workingDir = (File)tuple3._3();
                    Tuple3 tuple32 = new Tuple3((Object)flusher2, (Object)diskFileInfo2, (Object)workingDir);
                    flusher = (Flusher)tuple32._1();
                    diskFileInfo = (DiskFileInfo)tuple32._2();
                    File workingDir2 = (File)tuple32._3();
                    partitionDataWriterContext$2.setWorkingDir(workingDir2);
                    metaHandler = StoragePolicy.getPartitionMetaHandler$1((FileInfo)diskFileInfo, partitionDataWriterContext$2, notifier$2);
                    StorageInfo.Type type2 = storageInfoType;
                    StorageInfo.Type type3 = StorageInfo.Type.HDD;
                    if (!(type2 == null ? type3 != null : !type2.equals(type3))) break block7;
                    StorageInfo.Type type4 = storageInfoType;
                    StorageInfo.Type type5 = StorageInfo.Type.SSD;
                    if (type4 != null ? !type4.equals(type5) : type5 != null) break block8;
                }
                if (location$1.getStorageInfo().localDiskAvailable()) {
                    tierWriterBase = new LocalTierWriter(this.conf, metaHandler, numPendingWrites$2, notifier$2, flusher, this.source, diskFileInfo, storageInfoType, partitionDataWriterContext$2, this.storageManager);
                    return tierWriterBase;
                }
            }
            tierWriterBase = new DfsTierWriter(this.conf, metaHandler, numPendingWrites$2, notifier$2, flusher, this.source, diskFileInfo, storageInfoType, partitionDataWriterContext$2, this.storageManager);
            return tierWriterBase;
        }
        catch (Exception e) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("create celeborn file for storage ").append(storageInfoType).append(" failed").toString(), e);
            return null;
        }
    }

    public StoragePolicy(CelebornConf conf, StorageManager storageManager, AbstractSource source) {
        this.conf = conf;
        this.storageManager = storageManager;
        this.source = source;
        Logging.$init$((Logging)this);
        this.createFileOrder = conf.workerStoragePolicyCreateFilePolicy();
        this.evictFileOrder = conf.workerStoragePolicyEvictFilePolicy();
    }
}

