/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.xml;

import org.apache.cayenne.configuration.xml.NamespaceAwareNestedTagHandler;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.EmbeddableAttribute;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class EmbeddableHandler
extends NamespaceAwareNestedTagHandler {
    private static final String EMBEDDABLE_TAG = "embeddable";
    private static final String EMBEDDABLE_ATTRIBUTE_TAG = "embeddable-attribute";
    private DataMap map;
    private Embeddable embeddable;

    public EmbeddableHandler(NamespaceAwareNestedTagHandler parentHandler, DataMap map) {
        super(parentHandler);
        this.map = map;
    }

    @Override
    protected boolean processElement(String namespaceURI, String localName, Attributes attributes) throws SAXException {
        switch (localName) {
            case "embeddable": {
                this.createEmbeddable(attributes);
                return true;
            }
            case "embeddable-attribute": {
                this.createEmbeddableAttribute(attributes);
                return true;
            }
        }
        return false;
    }

    private void createEmbeddable(Attributes attributes) {
        this.embeddable = new Embeddable(attributes.getValue("className"));
        this.map.addEmbeddable(this.embeddable);
    }

    private void createEmbeddableAttribute(Attributes attributes) {
        EmbeddableAttribute ea = new EmbeddableAttribute(attributes.getValue("name"));
        ea.setType(attributes.getValue("type"));
        ea.setDbAttributeName(attributes.getValue("db-attribute-name"));
        this.embeddable.addAttribute(ea);
    }

    public Embeddable getEmbeddable() {
        return this.embeddable;
    }
}

