/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.handlers.sstableuploads;

import com.google.inject.Inject;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.net.SocketAddress;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.web.RoutingContext;
import java.nio.file.NoSuchFileException;
import java.util.Collections;
import java.util.Set;
import org.apache.cassandra.sidecar.acl.authorization.BasicPermissions;
import org.apache.cassandra.sidecar.concurrent.ExecutorPools;
import org.apache.cassandra.sidecar.handlers.AbstractHandler;
import org.apache.cassandra.sidecar.handlers.AccessProtected;
import org.apache.cassandra.sidecar.utils.InstanceMetadataFetcher;
import org.apache.cassandra.sidecar.utils.SSTableUploadsPathBuilder;
import org.jetbrains.annotations.NotNull;

public class SSTableCleanupHandler
extends AbstractHandler<String>
implements AccessProtected {
    private static final String UPLOAD_ID_PARAM = "uploadId";
    private final SSTableUploadsPathBuilder uploadPathBuilder;

    @Inject
    protected SSTableCleanupHandler(InstanceMetadataFetcher metadataFetcher, SSTableUploadsPathBuilder uploadPathBuilder, ExecutorPools executorPools) {
        super(metadataFetcher, executorPools, null);
        this.uploadPathBuilder = uploadPathBuilder;
    }

    @Override
    public Set<Authorization> requiredAuthorizations() {
        return Collections.singleton(BasicPermissions.DELETE_STAGED_SSTABLE.toAuthorization());
    }

    @Override
    public void handleInternal(RoutingContext context, HttpServerRequest httpRequest, @NotNull String host, SocketAddress remoteAddress, String uploadId) {
        this.uploadPathBuilder.resolveUploadIdDirectory(host, uploadId).compose(this.uploadPathBuilder::isValidDirectory).compose(stagingDirectory -> context.vertx().fileSystem().deleteRecursive(stagingDirectory, true)).onSuccess(x -> context.response().end()).onFailure(cause -> {
            if (cause instanceof NoSuchFileException) {
                this.logger.warn("Upload directory not found. uploadId={}, remoteAddress={}, instance={}", new Object[]{uploadId, remoteAddress, host, cause});
                context.fail(HttpResponseStatus.NOT_FOUND.code());
            } else if (cause instanceof IllegalArgumentException) {
                context.fail(HttpResponseStatus.BAD_REQUEST.code(), cause);
            } else {
                this.logger.error("Unable to cleanup upload. uploadId={}, remoteAddress={}, instance={}", new Object[]{uploadId, remoteAddress, host, cause});
                context.fail(HttpResponseStatus.INTERNAL_SERVER_ERROR.code());
            }
        });
    }

    @Override
    protected String extractParamsOrThrow(RoutingContext context) {
        return context.pathParam(UPLOAD_ID_PARAM);
    }
}

