/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.coordination;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.Token;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Range;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.cassandra.sidecar.client.SidecarInstance;
import org.apache.cassandra.sidecar.cluster.InstancesMetadata;
import org.apache.cassandra.sidecar.cluster.instance.InstanceMetadata;
import org.apache.cassandra.sidecar.cluster.locator.LocalTokenRangesProvider;
import org.apache.cassandra.sidecar.common.server.cluster.locator.Partitioner;
import org.apache.cassandra.sidecar.common.server.cluster.locator.Partitioners;
import org.apache.cassandra.sidecar.common.server.cluster.locator.TokenRange;
import org.apache.cassandra.sidecar.common.server.dns.DnsResolver;
import org.apache.cassandra.sidecar.coordination.TokenRingProvider;
import org.apache.cassandra.sidecar.utils.InstanceMetadataFetcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class CassandraClientTokenRingProvider
extends TokenRingProvider
implements LocalTokenRangesProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraClientTokenRingProvider.class);
    @GuardedBy(value="this")
    private volatile Map<String, Map<String, List<Range<BigInteger>>>> assignedRangesOfAllInstancesByDcCache = null;
    @GuardedBy(value="this")
    private volatile Map<Host, Integer> localHostsCache = null;
    @GuardedBy(value="this")
    private volatile Set<Host> allInstancesCache = null;

    @Inject
    public CassandraClientTokenRingProvider(InstancesMetadata instancesMetadata, InstanceMetadataFetcher instanceMetadataFetcher, DnsResolver dnsResolver) {
        super(instancesMetadata, instanceMetadataFetcher, dnsResolver);
    }

    @Override
    @Nullable
    public Map<Integer, Set<TokenRange>> localTokenRanges(String keyspace, boolean forceRefresh) {
        this.checkAndReloadReloadCaches();
        Metadata metadata = this.instancesMetadata.instances().get(0).delegate().metadata();
        if (keyspace == null || metadata.getKeyspace(keyspace) == null) {
            throw new NoSuchElementException("Keyspace does not exist. keyspace: " + keyspace);
        }
        return CassandraClientTokenRingProvider.perKeySpaceTokenRangesOfAllInstances(metadata).get(keyspace).entrySet().stream().filter(entry -> this.localHostsCache.containsKey(entry.getKey())).collect(Collectors.toMap(entry -> this.localHostsCache.get(entry.getKey()), Map.Entry::getValue));
    }

    public Set<Host> localInstances() {
        this.checkAndReloadReloadCaches();
        return this.localHostsCache.keySet();
    }

    public Set<Host> allInstances() {
        this.checkAndReloadReloadCaches();
        return this.allInstancesCache;
    }

    @Override
    protected Map<String, List<Range<BigInteger>>> getAllTokenRanges(Partitioner partitioner, String dc) {
        this.checkAndReloadReloadCaches();
        return this.assignedRangesOfAllInstancesByDcCache.entrySet().stream().filter(entry -> dc == null || dc.equalsIgnoreCase((String)entry.getKey())).flatMap(entry -> ((Map)entry.getValue()).entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public Map<String, List<Range<BigInteger>>> getPrimaryRanges(SidecarInstance instance, String dc) {
        this.checkAndReloadReloadCaches();
        return this.assignedRangesOfAllInstancesByDcCache.entrySet().stream().filter(entry -> dc == null || dc.equalsIgnoreCase((String)entry.getKey())).flatMap(entry -> ((Map)entry.getValue()).entrySet().stream()).filter(entry -> this.matchesSidecar((String)entry.getKey(), instance)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public Set<String> dcs() {
        List<InstanceMetadata> localInstances = this.instancesMetadata.instances();
        Metadata metadata = this.validatedMetadata(localInstances);
        return metadata.getAllHosts().stream().map(Host::getDatacenter).collect(Collectors.toSet());
    }

    @Override
    public Partitioner partitioner() {
        return CassandraClientTokenRingProvider.extractPartitioner(this.instancesMetadata.instances().get(0).delegate().metadata());
    }

    public static Partitioner extractPartitioner(Metadata metadata) {
        String[] tokens = metadata.getPartitioner().split("\\.");
        return Partitioners.from((String)tokens[tokens.length - 1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndReloadReloadCaches() {
        List<InstanceMetadata> localInstances = this.instancesMetadata.instances();
        Metadata metadata = this.validatedMetadata(localInstances);
        Set localInstanceIds = localInstances.stream().map(InstanceMetadata::id).collect(Collectors.toSet());
        if (this.localHostsCache == null || !new HashSet<Integer>(this.localHostsCache.values()).equals(localInstanceIds) || this.allInstancesCache == null || !this.allInstancesCache.equals(metadata.getAllHosts())) {
            CassandraClientTokenRingProvider cassandraClientTokenRingProvider = this;
            synchronized (cassandraClientTokenRingProvider) {
                this.localHostsCache = this.localInstanceIds();
                this.allInstancesCache = metadata.getAllHosts();
                this.assignedRangesOfAllInstancesByDcCache = this.assignedRangesOfAllInstancesByDc(metadata);
            }
        }
    }

    private boolean matchesSidecar(String hostIp, SidecarInstance sidecarInstance) {
        return this.getIp(sidecarInstance.hostname()).equals(hostIp);
    }

    public Map<String, Map<String, List<Range<BigInteger>>>> assignedRangesOfAllInstancesByDc(Metadata metadata) {
        return CassandraClientTokenRingProvider.assignedRangesOfAllInstancesByDc(this.dnsResolver, metadata);
    }

    @VisibleForTesting
    public static Map<String, Map<String, List<Range<BigInteger>>>> assignedRangesOfAllInstancesByDc(DnsResolver dnsResolver, Metadata metadata) {
        Partitioner partitioner = CassandraClientTokenRingProvider.extractPartitioner(metadata);
        HashMap<String, List> perDcHosts = new HashMap<String, List>(4);
        for (Host host : metadata.getAllHosts()) {
            Token minToken = (Token)host.getTokens().stream().min(Comparable::compareTo).orElseThrow(() -> new RuntimeException("No token found for host: " + host));
            perDcHosts.computeIfAbsent(host.getDatacenter(), dc -> new ArrayList()).add(new CassandraInstance(CassandraClientTokenRingProvider.tokenToString(minToken), CassandraClientTokenRingProvider.getIpFromHost(dnsResolver, host)));
        }
        perDcHosts.forEach((dc, hosts) -> hosts.sort(Comparator.comparing(o -> new BigInteger(o.token))));
        return perDcHosts.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> CassandraClientTokenRingProvider.calculateTokenRanges(partitioner, (List)e.getValue())));
    }

    protected static String tokenToString(Token token) {
        if (token.getType() == DataType.bigint()) {
            return Long.toString((Long)token.getValue());
        }
        if (token.getType() == DataType.varint()) {
            return token.getValue().toString();
        }
        throw new UnsupportedOperationException("Unsupported token type: " + token.getType());
    }

    protected static Map<String, List<Range<BigInteger>>> calculateTokenRanges(Partitioner partitioner, List<CassandraInstance> sortedPerDcHosts) {
        return CassandraClientTokenRingProvider.calculateTokenRanges(sortedPerDcHosts, 1, partitioner).entries().stream().collect(Collectors.groupingBy(e -> ((CassandraInstance)e.getKey()).node, Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
    }

    private Map<Host, Integer> localInstanceIds() {
        List<InstanceMetadata> localInstances = this.instancesMetadata.instances();
        Set hosts = localInstances.get(0).delegate().metadata().getAllHosts();
        Map<String, Integer> localIps = localInstances.stream().collect(Collectors.toMap(instanceMetadata -> this.getIp(instanceMetadata.host()), InstanceMetadata::id));
        Map ipToHost = hosts.stream().collect(Collectors.toMap(this::getIpFromHost, Function.identity()));
        return localIps.entrySet().stream().collect(Collectors.toMap(entry -> (Host)ipToHost.get(entry.getKey()), entry -> (Integer)localIps.get(entry.getKey())));
    }

    private Metadata validatedMetadata(List<InstanceMetadata> localInstances) {
        if (localInstances.isEmpty()) {
            LOGGER.warn("No local instances found");
            throw new RuntimeException("No local instances found");
        }
        return this.fetcher.callOnFirstAvailableInstance(instanceMetadata -> instanceMetadata.delegate().metadata());
    }

    private static Map<String, Map<Host, Set<TokenRange>>> perKeySpaceTokenRangesOfAllInstances(Metadata metadata) {
        HashMap<String, Map<Host, Set<TokenRange>>> perKeyspaceTokenRanges = new HashMap<String, Map<Host, Set<TokenRange>>>();
        for (KeyspaceMetadata ks : metadata.getKeyspaces()) {
            HashMap perHostTokenRanges = new HashMap();
            for (Host host : metadata.getAllHosts()) {
                Set tokenRanges = metadata.getTokenRanges(ks.getName(), host).stream().flatMap(range -> TokenRange.from((com.datastax.driver.core.TokenRange)range).stream()).collect(Collectors.toSet());
                perHostTokenRanges.put(host, tokenRanges);
            }
            perKeyspaceTokenRanges.put(ks.getName(), perHostTokenRanges);
        }
        return perKeyspaceTokenRanges;
    }

    static Multimap<CassandraInstance, Range<BigInteger>> calculateTokenRanges(List<CassandraInstance> instances, int replicationFactor, Partitioner partitioner) {
        Preconditions.checkArgument((replicationFactor != 0 ? 1 : 0) != 0, (Object)"Calculation token ranges wouldn't work with RF 0");
        Preconditions.checkArgument((instances.isEmpty() || replicationFactor <= instances.size() ? 1 : 0) != 0, (Object)("Calculation token ranges wouldn't work when RF (" + replicationFactor + ") is greater than number of Cassandra instances " + instances.size()));
        ArrayListMultimap tokenRanges = ArrayListMultimap.create();
        for (int index = 0; index < instances.size(); ++index) {
            CassandraInstance instance = instances.get(index);
            int disjointReplica = (instances.size() + index - replicationFactor) % instances.size();
            BigInteger rangeStart = new BigInteger(instances.get((int)disjointReplica).token);
            BigInteger rangeEnd = new BigInteger(instance.token);
            if (rangeStart.compareTo(rangeEnd) >= 0) {
                tokenRanges.put((Object)instance, (Object)Range.openClosed((Comparable)rangeStart, (Comparable)partitioner.maximumToken().toBigInteger()));
                if (rangeEnd.equals(partitioner.minimumToken().toBigInteger())) continue;
                tokenRanges.put((Object)instance, (Object)Range.openClosed((Comparable)partitioner.minimumToken().toBigInteger(), (Comparable)rangeEnd));
                continue;
            }
            tokenRanges.put((Object)instance, (Object)Range.openClosed((Comparable)rangeStart, (Comparable)rangeEnd));
        }
        return tokenRanges;
    }

    protected static class CassandraInstance {
        private final String token;
        private final String node;

        public CassandraInstance(String token, String node) {
            this.token = token;
            this.node = node;
        }
    }
}

