/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.utils;

import java.io.IOException;
import java.nio.file.Path;
import org.apache.cassandra.spark.common.Digest;
import org.apache.cassandra.spark.common.MD5Digest;
import org.apache.cassandra.spark.utils.MD5DigestAlgorithm;
import org.apache.cassandra.spark.utils.ResourceUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;

class MD5DigestAlgorithmTest {
    @TempDir
    private Path tempPath;

    MD5DigestAlgorithmTest() {
    }

    @ParameterizedTest(name="{index} fileName={0} expectedMd5={1}")
    @CsvSource(value={"file1.txt,VqSURYiCXjZIgP+CO9IkLQ==", "file2.txt,vFoVTqVngw7JRj8yJfk3UA==", "file3.txt,RXASCHthSSrMt7YOKJ6ODQ=="})
    void testMD5Provider(String fileName, String expectedMd5) throws IOException {
        ClassLoader classLoader = MD5DigestAlgorithmTest.class.getClassLoader();
        Path path = ResourceUtils.writeResourceToPath(classLoader, this.tempPath, "digest/" + fileName);
        Assertions.assertThat((Path)path).exists();
        Digest digest = new MD5DigestAlgorithm().calculateFileDigest(path);
        Assertions.assertThat((Object)digest).isInstanceOf(MD5Digest.class);
        Assertions.assertThat((String)digest.value()).isEqualTo(expectedMd5);
    }
}

