/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.reader;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import org.apache.cassandra.bridge.CassandraBridge;
import org.apache.cassandra.spark.TestUtils;
import org.apache.cassandra.spark.data.FileType;
import org.apache.cassandra.spark.utils.test.TestSchema;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.quicktheories.QuickTheory;

public class TombstoneWriterTests {
    private static final int NUM_ROWS = 50;
    private static final ObjectMapper MAPPER = new ObjectMapper();

    @Test
    public void testPartitionTombstone() {
        QuickTheory.qt().forAll(TestUtils.tombstoneVersions()).checkAssert(version -> TestUtils.runTest(version, (partitioner, directory, bridge) -> {
            JsonNode node;
            TestSchema schema = TestSchema.basicBuilder((CassandraBridge)bridge).withDeleteFields(new String[]{"a ="}).build();
            schema.writeTombstoneSSTable(directory, bridge, partitioner, writer -> {
                for (int index = 0; index < 50; ++index) {
                    writer.write(new Object[]{index});
                }
            });
            Path dataDbFile = TestUtils.getFirstFileType(directory, FileType.DATA);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            bridge.sstableToJson(dataDbFile, (OutputStream)out);
            try {
                node = MAPPER.readTree(out.toByteArray());
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
            Assertions.assertThat((Iterable)node).hasSize(50);
            for (int index = 0; index < 50; ++index) {
                JsonNode partition = node.get(index).get("partition");
                int key = partition.get("key").get(0).asInt();
                Assertions.assertThat((int)key).isBetween(Integer.valueOf(0), Integer.valueOf(49));
                Assertions.assertThat((boolean)node.get(index).has("rows")).isTrue();
                Assertions.assertThat((boolean)partition.has("deletion_info")).isTrue();
                Assertions.assertThat((boolean)partition.get("deletion_info").has("marked_deleted")).isTrue();
                Assertions.assertThat((boolean)partition.get("deletion_info").has("local_delete_time")).isTrue();
            }
        }));
    }

    @Test
    public void testRowTombstone() {
        QuickTheory.qt().forAll(TestUtils.tombstoneVersions()).checkAssert(version -> TestUtils.runTest(version, (partitioner, directory, bridge) -> {
            JsonNode node;
            TestSchema schema = TestSchema.basicBuilder((CassandraBridge)bridge).withDeleteFields(new String[]{"a =", "b ="}).build();
            schema.writeTombstoneSSTable(directory, bridge, partitioner, writer -> {
                for (int index = 0; index < 50; ++index) {
                    writer.write(new Object[]{index, index});
                }
            });
            Path dataDbFile = TestUtils.getFirstFileType(directory, FileType.DATA);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            bridge.sstableToJson(dataDbFile, (OutputStream)out);
            try {
                node = MAPPER.readTree(out.toByteArray());
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
            Assertions.assertThat((Iterable)node).hasSize(50);
            for (int index = 0; index < 50; ++index) {
                JsonNode partition = node.get(index).get("partition");
                int key = partition.get("key").get(0).asInt();
                Assertions.assertThat((int)key).isBetween(Integer.valueOf(0), Integer.valueOf(49));
                Assertions.assertThat((boolean)partition.has("deletion_info")).isFalse();
                Assertions.assertThat((boolean)node.get(index).has("rows")).isTrue();
                JsonNode row = node.get(index).get("rows").get(0);
                Assertions.assertThat((String)row.get("type").asText()).isEqualTo("row");
                Assertions.assertThat((int)row.get("clustering").get(0).asInt()).isEqualTo(key);
                Assertions.assertThat((boolean)row.has("deletion_info")).isTrue();
                Assertions.assertThat((boolean)row.get("deletion_info").has("marked_deleted")).isTrue();
                Assertions.assertThat((boolean)row.get("deletion_info").has("local_delete_time")).isTrue();
            }
        }));
    }

    @Test
    public void testRangeTombstone() {
        QuickTheory.qt().forAll(TestUtils.tombstoneVersions()).checkAssert(version -> TestUtils.runTest(version, (partitioner, directory, bridge) -> {
            JsonNode node;
            TestSchema schema = TestSchema.basicBuilder((CassandraBridge)bridge).withDeleteFields(new String[]{"a =", "b >=", "b <"}).build();
            schema.writeTombstoneSSTable(directory, bridge, partitioner, writer -> {
                for (int index = 0; index < 50; ++index) {
                    writer.write(new Object[]{index, 50, 999});
                }
            });
            Path dataDbFile = TestUtils.getFirstFileType(directory, FileType.DATA);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            bridge.sstableToJson(dataDbFile, (OutputStream)out);
            try {
                node = MAPPER.readTree(out.toByteArray());
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
            Assertions.assertThat((Iterable)node).hasSize(50);
            for (int index = 0; index < 50; ++index) {
                JsonNode partition = node.get(index).get("partition");
                int key = partition.get("key").get(0).asInt();
                Assertions.assertThat((int)key).isBetween(Integer.valueOf(0), Integer.valueOf(49));
                Assertions.assertThat((boolean)partition.has("deletion_info")).isFalse();
                Assertions.assertThat((boolean)node.get(index).has("rows")).isTrue();
                Assertions.assertThat((Iterable)node.get(index).get("rows")).hasSize(2);
                JsonNode row1 = node.get(index).get("rows").get(0);
                Assertions.assertThat((String)row1.get("type").asText()).isEqualTo("range_tombstone_bound");
                JsonNode start = row1.get("start");
                Assertions.assertThat((String)start.get("type").asText()).isEqualTo("inclusive");
                Assertions.assertThat((int)start.get("clustering").get(0).asInt()).isEqualTo(50);
                Assertions.assertThat((boolean)start.has("deletion_info")).isTrue();
                Assertions.assertThat((boolean)start.get("deletion_info").has("marked_deleted")).isTrue();
                Assertions.assertThat((boolean)start.get("deletion_info").has("local_delete_time")).isTrue();
                JsonNode row2 = node.get(index).get("rows").get(1);
                Assertions.assertThat((String)row2.get("type").asText()).isEqualTo("range_tombstone_bound");
                JsonNode end = row2.get("end");
                Assertions.assertThat((String)end.get("type").asText()).isEqualTo("exclusive");
                Assertions.assertThat((int)end.get("clustering").get(0).asInt()).isEqualTo(999);
                Assertions.assertThat((boolean)end.has("deletion_info")).isTrue();
                Assertions.assertThat((boolean)end.get("deletion_info").has("marked_deleted")).isTrue();
                Assertions.assertThat((boolean)end.get("deletion_info").has("local_delete_time")).isTrue();
            }
        }));
    }
}

