/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.endtoend;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.cassandra.bridge.CassandraBridge;
import org.apache.cassandra.spark.TestUtils;
import org.apache.cassandra.spark.Tester;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.cassandra.spark.utils.RandomUtils;
import org.apache.cassandra.spark.utils.ScalaConversionUtils;
import org.apache.cassandra.spark.utils.test.TestSchema;
import org.apache.spark.sql.Row;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.quicktheories.QuickTheory;
import scala.collection.mutable.AbstractSeq;
import scala.collection.mutable.Seq;

@Tag(value="Sequential")
public class DataTypeTests {
    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testAllDataTypesPartitionKey(CassandraBridge bridge) {
        QuickTheory.qt().forAll(TestUtils.cql3Type((CassandraBridge)bridge)).assuming(CqlField.CqlType::supportedAsPrimaryKeyColumn).checkAssert(partitionKeyType -> {
            int numRows = partitionKeyType.cardinality(10);
            Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("a", (CqlField.CqlType)partitionKeyType).withColumn("b", (CqlField.CqlType)bridge.bigint())).withNumRandomSSTables(1).withNumRandomRows(numRows).withExpectedRowCountPerSSTable(numRows).run(bridge.getVersion());
        });
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testAllDataTypesValueColumn(CassandraBridge bridge) {
        QuickTheory.qt().forAll(TestUtils.cql3Type((CassandraBridge)bridge)).checkAssert(valueType -> Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("a", (CqlField.CqlType)bridge.bigint()).withColumn("b", (CqlField.CqlType)valueType)).withNumRandomSSTables(1).withExpectedRowCountPerSSTable(200).run(bridge.getVersion()));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testSet(CassandraBridge bridge) {
        QuickTheory.qt().forAll(TestUtils.cql3Type((CassandraBridge)bridge)).assuming(CqlField.CqlType::supportedAsSetElement).checkAssert(type -> Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("pk", (CqlField.CqlType)bridge.uuid()).withColumn("a", (CqlField.CqlType)bridge.set((CqlField.CqlType)type))).withExpectedRowCountPerSSTable(200).run(bridge.getVersion()));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testList(CassandraBridge bridge) {
        QuickTheory.qt().forAll(TestUtils.cql3Type((CassandraBridge)bridge)).checkAssert(type -> Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("pk", (CqlField.CqlType)bridge.uuid()).withColumn("a", (CqlField.CqlType)bridge.list((CqlField.CqlType)type))).withExpectedRowCountPerSSTable(200).run(bridge.getVersion()));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testMap(CassandraBridge bridge) {
        QuickTheory.qt().withExamples(50).forAll(TestUtils.cql3Type((CassandraBridge)bridge), TestUtils.cql3Type((CassandraBridge)bridge)).assuming((keyType, valueType) -> keyType.supportedAsMapKey()).checkAssert((keyType, valueType) -> Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("pk", (CqlField.CqlType)bridge.uuid()).withColumn("a", (CqlField.CqlType)bridge.map((CqlField.CqlType)keyType, (CqlField.CqlType)valueType))).withExpectedRowCountPerSSTable(200).run(bridge.getVersion()));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testClusteringKeySet(CassandraBridge bridge) {
        Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("pk", (CqlField.CqlType)bridge.uuid()).withClusteringKey("id", (CqlField.CqlType)bridge.aInt()).withColumn("a", (CqlField.CqlType)bridge.set((CqlField.CqlType)bridge.text()))).withExpectedRowCountPerSSTable(200).run(bridge.getVersion());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testFrozenSet(CassandraBridge bridge) {
        QuickTheory.qt().forAll(TestUtils.cql3Type((CassandraBridge)bridge)).assuming(CqlField.CqlType::supportedAsSetElement).checkAssert(type -> Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("pk", (CqlField.CqlType)bridge.uuid()).withColumn("a", (CqlField.CqlType)bridge.set((CqlField.CqlType)type).frozen())).withExpectedRowCountPerSSTable(200).run(bridge.getVersion()));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testFrozenList(CassandraBridge bridge) {
        QuickTheory.qt().forAll(TestUtils.cql3Type((CassandraBridge)bridge)).checkAssert(type -> Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("pk", (CqlField.CqlType)bridge.uuid()).withColumn("a", (CqlField.CqlType)bridge.list((CqlField.CqlType)type).frozen())).withExpectedRowCountPerSSTable(200).run(bridge.getVersion()));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testFrozenMap(CassandraBridge bridge) {
        QuickTheory.qt().withExamples(50).forAll(TestUtils.cql3Type((CassandraBridge)bridge), TestUtils.cql3Type((CassandraBridge)bridge)).assuming((keyType, valueType) -> keyType.supportedAsMapKey()).checkAssert((keyType, valueType) -> Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("pk", (CqlField.CqlType)bridge.uuid()).withColumn("a", (CqlField.CqlType)bridge.map((CqlField.CqlType)keyType, (CqlField.CqlType)valueType).frozen())).withExpectedRowCountPerSSTable(200).run(bridge.getVersion()));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testNestedMapSet(CassandraBridge bridge) {
        Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("pk", (CqlField.CqlType)bridge.uuid()).withColumn("a", (CqlField.CqlType)bridge.map((CqlField.CqlType)bridge.text(), (CqlField.CqlType)bridge.set((CqlField.CqlType)bridge.text()).frozen()))).withNumRandomRows(32).withExpectedRowCountPerSSTable(32).run(bridge.getVersion());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testNestedMapList(CassandraBridge bridge) {
        Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("pk", (CqlField.CqlType)bridge.uuid()).withColumn("a", (CqlField.CqlType)bridge.map((CqlField.CqlType)bridge.text(), (CqlField.CqlType)bridge.list((CqlField.CqlType)bridge.text()).frozen()))).withNumRandomRows(32).withExpectedRowCountPerSSTable(32).run(bridge.getVersion());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testNestedMapMap(CassandraBridge bridge) {
        Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("pk", (CqlField.CqlType)bridge.uuid()).withColumn("a", (CqlField.CqlType)bridge.map((CqlField.CqlType)bridge.text(), (CqlField.CqlType)bridge.map((CqlField.CqlType)bridge.bigint(), (CqlField.CqlType)bridge.varchar()).frozen()))).withNumRandomRows(32).withExpectedRowCountPerSSTable(32).dontCheckNumSSTables().run(bridge.getVersion());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testFrozenNestedMapMap(CassandraBridge bridge) {
        Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("pk", (CqlField.CqlType)bridge.uuid()).withColumn("a", (CqlField.CqlType)bridge.map((CqlField.CqlType)bridge.text(), (CqlField.CqlType)bridge.map((CqlField.CqlType)bridge.aInt(), (CqlField.CqlType)bridge.timestamp())).frozen())).withNumRandomRows(32).withExpectedRowCountPerSSTable(32).dontCheckNumSSTables().run(bridge.getVersion());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testBasicTuple(CassandraBridge bridge) {
        QuickTheory.qt().withExamples(10).forAll(TestUtils.cql3Type((CassandraBridge)bridge), TestUtils.cql3Type((CassandraBridge)bridge)).checkAssert((type1, type2) -> Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("pk", (CqlField.CqlType)bridge.uuid()).withColumn("a", (CqlField.CqlType)bridge.tuple(new CqlField.CqlType[]{bridge.aInt(), type1, bridge.bigint(), type2}))).run(bridge.getVersion()));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testTupleWithClusteringKey(CassandraBridge bridge) {
        QuickTheory.qt().withExamples(10).forAll(TestUtils.cql3Type((CassandraBridge)bridge), TestUtils.cql3Type((CassandraBridge)bridge)).assuming((type1, type2) -> type1.supportedAsPrimaryKeyColumn()).checkAssert((type1, type2) -> Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("pk", (CqlField.CqlType)bridge.uuid()).withClusteringKey("col1", (CqlField.CqlType)type1).withColumn("a", (CqlField.CqlType)bridge.tuple(new CqlField.CqlType[]{bridge.aInt(), type2, bridge.bigint()}))).run(bridge.getVersion()));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testNestedTuples(CassandraBridge bridge) {
        QuickTheory.qt().withExamples(10).forAll(TestUtils.cql3Type((CassandraBridge)bridge), TestUtils.cql3Type((CassandraBridge)bridge)).checkAssert((type1, type2) -> Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("pk", (CqlField.CqlType)bridge.uuid()).withColumn("a", (CqlField.CqlType)bridge.tuple(new CqlField.CqlType[]{bridge.varchar(), bridge.tuple(new CqlField.CqlType[]{bridge.aInt(), type1, bridge.aFloat(), bridge.varchar(), bridge.tuple(new CqlField.CqlType[]{bridge.bigint(), bridge.bool(), type2})}), bridge.timeuuid()}))).run(bridge.getVersion()));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testTupleSet(CassandraBridge bridge) {
        QuickTheory.qt().withExamples(10).forAll(TestUtils.cql3Type((CassandraBridge)bridge)).assuming(CqlField.CqlType::supportedAsSetElement).checkAssert(type -> Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("pk", (CqlField.CqlType)bridge.uuid()).withColumn("a", (CqlField.CqlType)bridge.tuple(new CqlField.CqlType[]{bridge.varchar(), bridge.tuple(new CqlField.CqlType[]{bridge.aInt(), bridge.varchar(), bridge.aFloat(), bridge.varchar(), bridge.set((CqlField.CqlType)type)}), bridge.timeuuid()}))).run(bridge.getVersion()));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testTupleList(CassandraBridge bridge) {
        QuickTheory.qt().withExamples(10).forAll(TestUtils.cql3Type((CassandraBridge)bridge)).checkAssert(type -> Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("pk", (CqlField.CqlType)bridge.uuid()).withColumn("a", (CqlField.CqlType)bridge.tuple(new CqlField.CqlType[]{bridge.varchar(), bridge.tuple(new CqlField.CqlType[]{bridge.aInt(), bridge.varchar(), bridge.aFloat(), bridge.varchar(), bridge.list((CqlField.CqlType)type)}), bridge.timeuuid()}))).run(bridge.getVersion()));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testTupleMap(CassandraBridge bridge) {
        QuickTheory.qt().withExamples(10).forAll(TestUtils.cql3Type((CassandraBridge)bridge), TestUtils.cql3Type((CassandraBridge)bridge)).assuming((type1, type2) -> type1.supportedAsMapKey()).checkAssert((type1, type2) -> Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("pk", (CqlField.CqlType)bridge.uuid()).withColumn("a", (CqlField.CqlType)bridge.tuple(new CqlField.CqlType[]{bridge.varchar(), bridge.tuple(new CqlField.CqlType[]{bridge.aInt(), bridge.varchar(), bridge.aFloat(), bridge.varchar(), bridge.map((CqlField.CqlType)type1, (CqlField.CqlType)type2)}), bridge.timeuuid()}))).run(bridge.getVersion()));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testMapTuple(CassandraBridge bridge) {
        QuickTheory.qt().withExamples(10).forAll(TestUtils.cql3Type((CassandraBridge)bridge)).checkAssert(type -> Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("pk", (CqlField.CqlType)bridge.uuid()).withColumn("a", (CqlField.CqlType)bridge.map((CqlField.CqlType)bridge.timeuuid(), (CqlField.CqlType)bridge.tuple(new CqlField.CqlType[]{bridge.bool(), type, bridge.timestamp()}).frozen()))).run(bridge.getVersion()));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testSetTuple(CassandraBridge bridge) {
        QuickTheory.qt().withExamples(10).forAll(TestUtils.cql3Type((CassandraBridge)bridge)).assuming(CqlField.CqlType::supportedAsSetElement).checkAssert(type -> Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("pk", (CqlField.CqlType)bridge.uuid()).withColumn("a", (CqlField.CqlType)bridge.set((CqlField.CqlType)bridge.tuple(new CqlField.CqlType[]{type, bridge.aFloat(), bridge.text()}).frozen()))).run(bridge.getVersion()));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testListTuple(CassandraBridge bridge) {
        QuickTheory.qt().withExamples(10).forAll(TestUtils.cql3Type((CassandraBridge)bridge)).checkAssert(type -> Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("pk", (CqlField.CqlType)bridge.uuid()).withColumn("a", (CqlField.CqlType)bridge.list((CqlField.CqlType)bridge.tuple(new CqlField.CqlType[]{bridge.aInt(), bridge.inet(), bridge.decimal(), type}).frozen()))).run(bridge.getVersion()));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testTupleUDT(CassandraBridge bridge) {
        QuickTheory.qt().withExamples(10).forAll(TestUtils.cql3Type((CassandraBridge)bridge)).checkAssert(type -> Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("pk", (CqlField.CqlType)bridge.uuid()).withColumn("a", (CqlField.CqlType)bridge.tuple(new CqlField.CqlType[]{bridge.varchar(), bridge.udt("keyspace", "nested_udt").withField("x", (CqlField.CqlType)bridge.aInt()).withField("y", (CqlField.CqlType)type).withField("z", (CqlField.CqlType)bridge.aInt()).build().frozen(), bridge.timeuuid()}))).run(bridge.getVersion()));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testUDTTuple(CassandraBridge bridge) {
        QuickTheory.qt().withExamples(10).forAll(TestUtils.cql3Type((CassandraBridge)bridge)).checkAssert(type -> Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("pk", (CqlField.CqlType)bridge.uuid()).withColumn("a", (CqlField.CqlType)bridge.udt("keyspace", "nested_udt").withField("x", (CqlField.CqlType)bridge.text()).withField("y", (CqlField.CqlType)bridge.tuple(new CqlField.CqlType[]{bridge.aInt(), bridge.aFloat(), type, bridge.timestamp()})).withField("z", (CqlField.CqlType)bridge.ascii()).build())).run(bridge.getVersion()));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testTupleClusteringKey(CassandraBridge bridge) {
        QuickTheory.qt().forAll(TestUtils.cql3Type((CassandraBridge)bridge)).assuming(CqlField.CqlType::supportedAsPrimaryKeyColumn).checkAssert(type -> Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("pk", (CqlField.CqlType)bridge.uuid()).withClusteringKey("ck", (CqlField.CqlType)bridge.tuple(new CqlField.CqlType[]{bridge.aInt(), bridge.text(), type, bridge.aFloat()})).withColumn("a", (CqlField.CqlType)bridge.text()).withColumn("b", (CqlField.CqlType)bridge.aInt()).withColumn("c", (CqlField.CqlType)bridge.ascii())).run(bridge.getVersion()));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testUdtClusteringKey(CassandraBridge bridge) {
        QuickTheory.qt().forAll(TestUtils.cql3Type((CassandraBridge)bridge)).assuming(CqlField.CqlType::supportedAsPrimaryKeyColumn).checkAssert(type -> Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("pk", (CqlField.CqlType)bridge.uuid()).withClusteringKey("ck", (CqlField.CqlType)bridge.udt("keyspace", "udt1").withField("a", (CqlField.CqlType)bridge.text()).withField("b", (CqlField.CqlType)type).withField("c", (CqlField.CqlType)bridge.aInt()).build().frozen()).withColumn("a", (CqlField.CqlType)bridge.text()).withColumn("b", (CqlField.CqlType)bridge.aInt()).withColumn("c", (CqlField.CqlType)bridge.ascii())).run(bridge.getVersion()));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testComplexSchema(CassandraBridge bridge) {
        String keyspace = "complex_schema2";
        CqlField.CqlUdt udt1 = bridge.udt(keyspace, "udt1").withField("time", (CqlField.CqlType)bridge.bigint()).withField("time_offset_minutes", (CqlField.CqlType)bridge.aInt()).build();
        CqlField.CqlUdt udt2 = bridge.udt(keyspace, "udt2").withField("version", (CqlField.CqlType)bridge.text()).withField("id", (CqlField.CqlType)bridge.text()).withField("platform", (CqlField.CqlType)bridge.text()).withField("time_range", (CqlField.CqlType)bridge.text()).build();
        CqlField.CqlUdt udt3 = bridge.udt(keyspace, "udt3").withField("field", (CqlField.CqlType)bridge.text()).withField("time_with_zone", (CqlField.CqlType)udt1).build();
        CqlField.CqlUdt udt4 = bridge.udt(keyspace, "udt4").withField("first_seen", (CqlField.CqlType)udt3.frozen()).withField("last_seen", (CqlField.CqlType)udt3.frozen()).withField("first_transaction", (CqlField.CqlType)udt3.frozen()).withField("last_transaction", (CqlField.CqlType)udt3.frozen()).withField("first_listening", (CqlField.CqlType)udt3.frozen()).withField("last_listening", (CqlField.CqlType)udt3.frozen()).withField("first_reading", (CqlField.CqlType)udt3.frozen()).withField("last_reading", (CqlField.CqlType)udt3.frozen()).withField("output_event", (CqlField.CqlType)bridge.text()).withField("event_history", (CqlField.CqlType)bridge.map((CqlField.CqlType)bridge.bigint(), (CqlField.CqlType)bridge.map((CqlField.CqlType)bridge.text(), (CqlField.CqlType)bridge.bool()).frozen()).frozen()).build();
        Tester.builder(keyspace1 -> TestSchema.builder((CassandraBridge)bridge).withKeyspace(keyspace1).withPartitionKey("\"consumerId\"", (CqlField.CqlType)bridge.text()).withClusteringKey("dimensions", (CqlField.CqlType)udt2.frozen()).withColumn("fields", (CqlField.CqlType)udt4.frozen()).withColumn("first_transition_time", (CqlField.CqlType)udt1.frozen()).withColumn("last_transition_time", (CqlField.CqlType)udt1.frozen()).withColumn("prev_state_id", (CqlField.CqlType)bridge.text()).withColumn("state_id", (CqlField.CqlType)bridge.text())).run(bridge.getVersion());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testNestedFrozenUDT(CassandraBridge bridge) {
        CqlField.CqlUdt testudt = bridge.udt("nested_frozen_udt", "testudt").withField("a", (CqlField.CqlType)bridge.text()).withField("b", (CqlField.CqlType)bridge.bigint()).withField("c", (CqlField.CqlType)bridge.aInt()).build();
        Tester.builder(keyspace -> TestSchema.builder((CassandraBridge)bridge).withKeyspace(keyspace).withPartitionKey("a", (CqlField.CqlType)bridge.bigint()).withColumn("b", (CqlField.CqlType)bridge.map((CqlField.CqlType)bridge.aInt(), (CqlField.CqlType)testudt.frozen()))).run(bridge.getVersion());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testDeepNestedUDT(CassandraBridge bridge) {
        String keyspace = "deep_nested_frozen_udt";
        CqlField.CqlUdt udt1 = bridge.udt(keyspace, "udt1").withField("a", (CqlField.CqlType)bridge.text()).withField("b", (CqlField.CqlType)bridge.aInt()).withField("c", (CqlField.CqlType)bridge.bigint()).build();
        CqlField.CqlUdt udt2 = bridge.udt(keyspace, "udt2").withField("a", (CqlField.CqlType)bridge.aInt()).withField("b", (CqlField.CqlType)bridge.set((CqlField.CqlType)bridge.uuid())).build();
        CqlField.CqlUdt udt3 = bridge.udt(keyspace, "udt3").withField("a", (CqlField.CqlType)bridge.aInt()).withField("b", (CqlField.CqlType)bridge.set((CqlField.CqlType)bridge.uuid())).build();
        CqlField.CqlUdt udt4 = bridge.udt(keyspace, "udt4").withField("a", (CqlField.CqlType)bridge.text()).withField("b", (CqlField.CqlType)bridge.text()).withField("c", (CqlField.CqlType)bridge.uuid()).withField("d", (CqlField.CqlType)bridge.list((CqlField.CqlType)bridge.tuple(new CqlField.CqlType[]{bridge.text(), bridge.bigint()}).frozen()).frozen()).build();
        CqlField.CqlUdt udt5 = bridge.udt(keyspace, "udt5").withField("a", (CqlField.CqlType)bridge.text()).withField("b", (CqlField.CqlType)bridge.text()).withField("c", (CqlField.CqlType)bridge.bigint()).withField("d", (CqlField.CqlType)bridge.set((CqlField.CqlType)udt4.frozen())).build();
        CqlField.CqlUdt udt6 = bridge.udt(keyspace, "udt6").withField("a", (CqlField.CqlType)bridge.text()).withField("b", (CqlField.CqlType)bridge.text()).withField("c", (CqlField.CqlType)bridge.aInt()).withField("d", (CqlField.CqlType)bridge.aInt()).build();
        CqlField.CqlUdt udt7 = bridge.udt(keyspace, "udt7").withField("a", (CqlField.CqlType)bridge.text()).withField("b", (CqlField.CqlType)bridge.uuid()).withField("c", (CqlField.CqlType)bridge.bool()).withField("d", (CqlField.CqlType)bridge.bool()).withField("e", (CqlField.CqlType)bridge.bool()).withField("f", (CqlField.CqlType)bridge.bigint()).withField("g", (CqlField.CqlType)bridge.bigint()).build();
        CqlField.CqlUdt udt8 = bridge.udt(keyspace, "udt8").withField("a", (CqlField.CqlType)bridge.text()).withField("b", (CqlField.CqlType)bridge.bool()).withField("c", (CqlField.CqlType)bridge.bool()).withField("d", (CqlField.CqlType)bridge.bool()).withField("e", (CqlField.CqlType)bridge.bigint()).withField("f", (CqlField.CqlType)bridge.bigint()).withField("g", (CqlField.CqlType)bridge.uuid()).withField("h", (CqlField.CqlType)bridge.bigint()).withField("i", (CqlField.CqlType)bridge.uuid()).withField("j", (CqlField.CqlType)bridge.uuid()).withField("k", (CqlField.CqlType)bridge.uuid()).withField("l", (CqlField.CqlType)bridge.uuid()).withField("m", (CqlField.CqlType)bridge.aInt()).withField("n", (CqlField.CqlType)bridge.timestamp()).withField("o", (CqlField.CqlType)bridge.text()).build();
        Tester.builder(keyspace1 -> TestSchema.builder((CassandraBridge)bridge).withKeyspace(keyspace1).withPartitionKey("pk", (CqlField.CqlType)bridge.uuid()).withClusteringKey("ck", (CqlField.CqlType)bridge.uuid()).withColumn("a", (CqlField.CqlType)udt3.frozen()).withColumn("b", (CqlField.CqlType)udt2.frozen()).withColumn("c", (CqlField.CqlType)bridge.set((CqlField.CqlType)bridge.tuple(new CqlField.CqlType[]{udt1, bridge.text()}).frozen())).withColumn("d", (CqlField.CqlType)bridge.set((CqlField.CqlType)bridge.tuple(new CqlField.CqlType[]{bridge.bigint(), bridge.text()}).frozen())).withColumn("e", (CqlField.CqlType)bridge.set((CqlField.CqlType)bridge.tuple(new CqlField.CqlType[]{udt2, bridge.text()}).frozen())).withColumn("f", (CqlField.CqlType)bridge.set((CqlField.CqlType)udt7.frozen())).withColumn("g", (CqlField.CqlType)bridge.map((CqlField.CqlType)bridge.aInt(), (CqlField.CqlType)bridge.set((CqlField.CqlType)bridge.text()).frozen())).withColumn("h", (CqlField.CqlType)bridge.set((CqlField.CqlType)bridge.tinyint())).withColumn("i", (CqlField.CqlType)bridge.map((CqlField.CqlType)bridge.text(), (CqlField.CqlType)udt6.frozen())).withColumn("j", (CqlField.CqlType)bridge.map((CqlField.CqlType)bridge.text(), (CqlField.CqlType)bridge.map((CqlField.CqlType)bridge.text(), (CqlField.CqlType)bridge.text()).frozen())).withColumn("k", (CqlField.CqlType)bridge.list((CqlField.CqlType)bridge.tuple(new CqlField.CqlType[]{bridge.text(), bridge.text(), bridge.text()}).frozen())).withColumn("l", (CqlField.CqlType)bridge.list((CqlField.CqlType)udt5.frozen())).withColumn("m", (CqlField.CqlType)udt8.frozen()).withMinCollectionSize(4)).withNumRandomRows(50).withNumRandomSSTables(2).run(bridge.getVersion());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testBigDecimal(CassandraBridge bridge) {
        Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("pk", (CqlField.CqlType)bridge.uuid()).withColumn("c1", (CqlField.CqlType)bridge.decimal()).withColumn("c2", (CqlField.CqlType)bridge.text())).run(bridge.getVersion());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testBigInteger(CassandraBridge bridge) {
        Tester.builder(TestSchema.builder((CassandraBridge)bridge).withPartitionKey("pk", (CqlField.CqlType)bridge.uuid()).withColumn("c1", (CqlField.CqlType)bridge.varint()).withColumn("c2", (CqlField.CqlType)bridge.text())).run(bridge.getVersion());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testUdtFieldOrdering(CassandraBridge bridge) {
        String keyspace = "udt_field_ordering";
        CqlField.CqlUdt udt1 = bridge.udt(keyspace, "udt1").withField("c", (CqlField.CqlType)bridge.text()).withField("b", (CqlField.CqlType)bridge.uuid()).withField("a", (CqlField.CqlType)bridge.bool()).build();
        Tester.builder(keyspace1 -> TestSchema.builder((CassandraBridge)bridge).withKeyspace(keyspace1).withPartitionKey("pk", (CqlField.CqlType)bridge.uuid()).withColumn("a", (CqlField.CqlType)bridge.set((CqlField.CqlType)udt1.frozen()))).run(bridge.getVersion());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.bridge.VersionRunner#bridges"})
    public void testUdtTupleInnerNulls(CassandraBridge bridge) {
        CqlField.CqlUdt udtType = bridge.udt("udt_inner_nulls", "udt").withField("a", (CqlField.CqlType)bridge.uuid()).withField("b", (CqlField.CqlType)bridge.text()).build();
        CqlField.CqlTuple tupleType = bridge.tuple(new CqlField.CqlType[]{bridge.bigint(), bridge.text(), bridge.aInt()});
        int numRows = 50;
        int midPoint = numRows / 2;
        LinkedHashMap udtSetValues = new LinkedHashMap(numRows);
        LinkedHashMap<UUID, Object[]> tupleValues = new LinkedHashMap<UUID, Object[]>(numRows);
        for (int tupleIndex = 0; tupleIndex < numRows; ++tupleIndex) {
            UUID pk = UUID.randomUUID();
            HashSet<HashMap> udtSet = new HashSet<HashMap>(numRows);
            for (int udtIndex = 0; udtIndex < numRows; ++udtIndex) {
                HashMap udt = Maps.newHashMapWithExpectedSize((int)2);
                udt.put("a", UUID.randomUUID());
                udt.put("b", udtIndex < midPoint ? UUID.randomUUID().toString() : null);
                udtSet.add(udt);
            }
            Object[] tuple = new Object[]{RandomUtils.RANDOM.nextLong(), tupleIndex < midPoint ? UUID.randomUUID().toString() : null, RandomUtils.RANDOM.nextInt()};
            udtSetValues.put(pk, udtSet);
            tupleValues.put(pk, tuple);
        }
        Tester.builder(keyspace -> TestSchema.builder((CassandraBridge)bridge).withKeyspace(keyspace).withPartitionKey("pk", (CqlField.CqlType)bridge.uuid()).withColumn("a", (CqlField.CqlType)bridge.set((CqlField.CqlType)udtType.frozen())).withColumn("b", (CqlField.CqlType)tupleType)).dontWriteRandomData().withSSTableWriter(writer -> {
            for (UUID pk : udtSetValues.keySet()) {
                Set udtSet = ((Set)udtSetValues.get(pk)).stream().map(map -> bridge.toUserTypeValue(udtType, map)).collect(Collectors.toSet());
                Object tuple = bridge.toTupleValue(tupleType, (Object[])tupleValues.get(pk));
                writer.write(new Object[]{pk, udtSet, tuple});
            }
        }).withCheck(dataset -> {
            for (Row row : dataset.collectAsList()) {
                UUID pk = UUID.fromString(row.getString(0));
                Set expectedUdtSet = (Set)udtSetValues.get(pk);
                List udtSet = ScalaConversionUtils.mutableSeqAsJavaList((Seq)((AbstractSeq)row.get(1)));
                Assertions.assertThat((int)udtSet.size()).isEqualTo(expectedUdtSet.size());
                for (Row udt : udtSet) {
                    HashMap expectedUdt = Maps.newHashMapWithExpectedSize((int)2);
                    expectedUdt.put("a", UUID.fromString(udt.getString(0)));
                    expectedUdt.put("b", udt.getString(1));
                    Assertions.assertThat((boolean)expectedUdtSet.contains(expectedUdt)).isTrue();
                }
                Object[] expectedTuple = (Object[])tupleValues.get(pk);
                Row tuple = (Row)row.get(2);
                Assertions.assertThat((int)tuple.length()).isEqualTo(expectedTuple.length);
                Assertions.assertThat((long)tuple.getLong(0)).isEqualTo(expectedTuple[0]);
                Assertions.assertThat((String)tuple.getString(1)).isEqualTo(expectedTuple[1]);
                Assertions.assertThat((int)tuple.getInt(2)).isEqualTo(expectedTuple[2]);
            }
        }).run(bridge.getVersion());
    }
}

