/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data;

import java.util.ArrayList;
import org.apache.cassandra.bridge.CassandraBridge;
import org.apache.cassandra.spark.data.CassandraTypes;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.cassandra.spark.data.VersionRunner;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class CqlFieldTests
extends VersionRunner {
    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.spark.data.VersionRunner#bridges"})
    public void testEquality(CassandraBridge bridge) {
        CqlField field1 = new CqlField(true, false, false, "a", (CqlField.CqlType)bridge.bigint(), 0);
        CqlField field2 = new CqlField(true, false, false, "a", (CqlField.CqlType)bridge.bigint(), 0);
        Assertions.assertThat((Comparable)field1).isNotSameAs((Object)field2);
        Assertions.assertThat((Comparable)field1).isEqualTo((Object)field2);
        Assertions.assertThat((int)field1.hashCode()).isEqualTo(field2.hashCode());
        Assertions.assertThat((Comparable)field1).isNotEqualTo(null);
        Assertions.assertThat((Comparable)field2).isNotEqualTo(null);
        Assertions.assertThat((Comparable)field1).isNotEqualTo(new ArrayList());
        Assertions.assertThat((Comparable)field1).isEqualTo((Object)field1);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.spark.data.VersionRunner#bridges"})
    public void testNotEqualsName(CassandraBridge bridge) {
        CqlField field1 = new CqlField(true, false, false, "a", (CqlField.CqlType)bridge.bigint(), 0);
        CqlField field2 = new CqlField(true, false, false, "b", (CqlField.CqlType)bridge.bigint(), 0);
        Assertions.assertThat((Comparable)field1).isNotSameAs((Object)field2);
        Assertions.assertThat((Comparable)field1).isNotEqualTo((Object)field2);
        Assertions.assertThat((int)field1.hashCode()).isNotEqualTo(field2.hashCode());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.spark.data.VersionRunner#bridges"})
    public void testNotEqualsType(CassandraBridge bridge) {
        CqlField field1 = new CqlField(true, false, false, "a", (CqlField.CqlType)bridge.bigint(), 0);
        CqlField field2 = new CqlField(true, false, false, "a", (CqlField.CqlType)bridge.timestamp(), 0);
        Assertions.assertThat((Comparable)field1).isNotSameAs((Object)field2);
        Assertions.assertThat((Comparable)field1).isNotEqualTo((Object)field2);
        Assertions.assertThat((int)field1.hashCode()).isNotEqualTo(field2.hashCode());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.spark.data.VersionRunner#bridges"})
    public void testNotEqualsKey(CassandraBridge bridge) {
        CqlField field1 = new CqlField(true, false, false, "a", (CqlField.CqlType)bridge.bigint(), 0);
        CqlField field2 = new CqlField(false, true, false, "a", (CqlField.CqlType)bridge.bigint(), 0);
        Assertions.assertThat((Comparable)field1).isNotSameAs((Object)field2);
        Assertions.assertThat((Comparable)field1).isNotEqualTo((Object)field2);
        Assertions.assertThat((int)field1.hashCode()).isNotEqualTo(field2.hashCode());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.spark.data.VersionRunner#bridges"})
    public void testNotEqualsPos(CassandraBridge bridge) {
        CqlField field1 = new CqlField(true, false, false, "a", (CqlField.CqlType)bridge.bigint(), 0);
        CqlField field2 = new CqlField(true, false, false, "a", (CqlField.CqlType)bridge.bigint(), 1);
        Assertions.assertThat((Comparable)field1).isNotSameAs((Object)field2);
        Assertions.assertThat((Comparable)field1).isNotEqualTo((Object)field2);
        Assertions.assertThat((int)field1.hashCode()).isNotEqualTo(field2.hashCode());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.spark.data.VersionRunner#bridges"})
    public void testCqlTypeParser(CassandraBridge bridge) {
        this.testCqlTypeParser("set<text>", (CqlField.CqlType)bridge.text(), bridge);
        this.testCqlTypeParser("set<float>", (CqlField.CqlType)bridge.aFloat(), bridge);
        this.testCqlTypeParser("set<time>", (CqlField.CqlType)bridge.time(), bridge);
        this.testCqlTypeParser("SET<BLOB>", (CqlField.CqlType)bridge.blob(), bridge);
        this.testCqlTypeParser("list<ascii>", (CqlField.CqlType)bridge.ascii(), bridge);
        this.testCqlTypeParser("list<int>", (CqlField.CqlType)bridge.aInt(), bridge);
        this.testCqlTypeParser("LIST<BIGINT>", (CqlField.CqlType)bridge.bigint(), bridge);
        this.testCqlTypeParser("map<int,text>", (CqlField.CqlType)bridge.aInt(), (CqlField.CqlType)bridge.text(), bridge);
        this.testCqlTypeParser("map<boolean , decimal>", (CqlField.CqlType)bridge.bool(), (CqlField.CqlType)bridge.decimal(), bridge);
        this.testCqlTypeParser("MAP<TIMEUUID,TIMESTAMP>", (CqlField.CqlType)bridge.timeuuid(), (CqlField.CqlType)bridge.timestamp(), bridge);
        this.testCqlTypeParser("MAP<VARCHAR , double>", (CqlField.CqlType)bridge.varchar(), (CqlField.CqlType)bridge.aDouble(), bridge);
        this.testCqlTypeParser("tuple<int, text>", (CqlField.CqlType)bridge.aInt(), (CqlField.CqlType)bridge.text(), bridge);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.spark.data.VersionRunner#bridges"})
    public void testSplitMapTypes(CassandraBridge bridge) {
        CqlFieldTests.splitMap("", "", null);
        CqlFieldTests.splitMap("text", "text", null);
        CqlFieldTests.splitMap("bigint", "bigint", null);
        CqlFieldTests.splitMap("set<text>", "set<text>", null);
        CqlFieldTests.splitMap("text,bigint", "text", "bigint");
        CqlFieldTests.splitMap("varchar , float", "varchar", "float");
        CqlFieldTests.splitMap("varchar , float", "varchar", "float");
        CqlFieldTests.splitMap("date, frozen<set<text>>", "date", "frozen<set<text>>");
        CqlFieldTests.splitMap("timestamp, frozen<map<int, blob>>", "timestamp", "frozen<map<int, blob>>");
        CqlFieldTests.splitMap("frozen<list<timeuuid>>, frozen<map<uuid, double>>", "frozen<list<timeuuid>>", "frozen<map<uuid, double>>");
        CqlFieldTests.splitMap("frozen<map<int, float>>, frozen<map<blob, decimal>>", "frozen<map<int, float>>", "frozen<map<blob, decimal>>");
        CqlFieldTests.splitMap("frozen<map<int,float>>,frozen<map<blob,decimal>>", "frozen<map<int,float>>", "frozen<map<blob,decimal>>");
        CqlFieldTests.splitMap("text, frozen<map<text, set<text>>>", "text", "frozen<map<text, set<text>>>");
        CqlFieldTests.splitMap("frozen<map<set<int>,blob>>,   frozen<map<text, frozen<map<bigint, double>>>>", "frozen<map<set<int>,blob>>", "frozen<map<text, frozen<map<bigint, double>>>>");
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.spark.data.VersionRunner#bridges"})
    public void testCqlNames(CassandraBridge bridge) {
        Assertions.assertThat((String)bridge.collection("set", new CqlField.CqlType[]{bridge.bigint()}).cqlName()).isEqualTo("set<bigint>");
        Assertions.assertThat((String)bridge.collection("LIST", new CqlField.CqlType[]{bridge.timestamp()}).cqlName()).isEqualTo("list<timestamp>");
        Assertions.assertThat((String)bridge.collection("Map", new CqlField.CqlType[]{bridge.text(), bridge.aInt()}).cqlName()).isEqualTo("map<text, int>");
        Assertions.assertThat((String)bridge.collection("tuple", new CqlField.CqlType[]{bridge.aInt(), bridge.blob(), bridge.varchar()}).cqlName()).isEqualTo("tuple<int, blob, varchar>");
        Assertions.assertThat((String)bridge.collection("tuPLe", new CqlField.CqlType[]{bridge.aInt(), bridge.blob(), bridge.map((CqlField.CqlType)bridge.aInt(), (CqlField.CqlType)bridge.aFloat())}).cqlName()).isEqualTo("tuple<int, blob, map<int, float>>");
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.spark.data.VersionRunner#bridges"})
    public void testTuple(CassandraBridge bridge) {
        String[] result = CassandraTypes.splitInnerTypes((String)"a, b, c, d,e, f, g");
        Assertions.assertThat((String)result[0]).isEqualTo("a");
        Assertions.assertThat((String)result[1]).isEqualTo("b");
        Assertions.assertThat((String)result[2]).isEqualTo("c");
        Assertions.assertThat((String)result[3]).isEqualTo("d");
        Assertions.assertThat((String)result[4]).isEqualTo("e");
        Assertions.assertThat((String)result[5]).isEqualTo("f");
        Assertions.assertThat((String)result[6]).isEqualTo("g");
    }

    private static void splitMap(String str, String left, String right) {
        String[] result = CassandraTypes.splitInnerTypes((String)str);
        if (left != null) {
            Assertions.assertThat((String)result[0]).isEqualTo(left);
        }
        if (right != null) {
            Assertions.assertThat((String)result[1]).isEqualTo(right);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.spark.data.VersionRunner#bridges"})
    public void testNestedSet(CassandraBridge bridge) {
        CqlField.CqlType type = bridge.parseType("set<frozen<map<text, list<double>>>>");
        Assertions.assertThat((Object)type).isNotNull();
        Assertions.assertThat((Comparable)type.internalType()).isEqualTo((Object)CqlField.CqlType.InternalType.Set);
        CqlField.CqlType frozen = ((CqlField.CqlSet)type).type();
        Assertions.assertThat((Comparable)frozen.internalType()).isEqualTo((Object)CqlField.CqlType.InternalType.Frozen);
        CqlField.CqlMap map = (CqlField.CqlMap)((CqlField.CqlFrozen)frozen).inner();
        Assertions.assertThat((Object)map.keyType()).isEqualTo((Object)bridge.text());
        Assertions.assertThat((Comparable)map.valueType().internalType()).isEqualTo((Object)CqlField.CqlType.InternalType.List);
        CqlField.CqlList list = (CqlField.CqlList)map.valueType();
        Assertions.assertThat((Object)list.type()).isEqualTo((Object)bridge.aDouble());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.spark.data.VersionRunner#bridges"})
    public void testFrozenCqlTypeParser(CassandraBridge bridge) {
        CqlField.CqlType type = bridge.parseType("frozen<map<text, float>>");
        Assertions.assertThat((Object)type).isNotNull();
        Assertions.assertThat((Comparable)type.internalType()).isEqualTo((Object)CqlField.CqlType.InternalType.Frozen);
        CqlField.CqlType inner = ((CqlField.CqlFrozen)type).inner();
        Assertions.assertThat((Comparable)inner.internalType()).isEqualTo((Object)CqlField.CqlType.InternalType.Map);
        CqlField.CqlMap map = (CqlField.CqlMap)inner;
        Assertions.assertThat((Object)map.keyType()).isEqualTo((Object)bridge.text());
        Assertions.assertThat((Object)map.valueType()).isEqualTo((Object)bridge.aFloat());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.cassandra.spark.data.VersionRunner#bridges"})
    public void testFrozenCqlTypeNested(CassandraBridge bridge) {
        CqlField.CqlType type = bridge.parseType("map<frozen<set<text>>, frozen<map<int, list<blob>>>>");
        Assertions.assertThat((Object)type).isNotNull();
        Assertions.assertThat((Comparable)type.internalType()).isEqualTo((Object)CqlField.CqlType.InternalType.Map);
        CqlField.CqlType key = ((CqlField.CqlMap)type).keyType();
        Assertions.assertThat((Comparable)key.internalType()).isEqualTo((Object)CqlField.CqlType.InternalType.Frozen);
        CqlField.CqlCollection keyInner = (CqlField.CqlCollection)((CqlField.CqlFrozen)key).inner();
        Assertions.assertThat((Comparable)keyInner.internalType()).isEqualTo((Object)CqlField.CqlType.InternalType.Set);
        Assertions.assertThat((Object)keyInner.type()).isEqualTo((Object)bridge.text());
        CqlField.CqlType value = ((CqlField.CqlMap)type).valueType();
        Assertions.assertThat((Comparable)value.internalType()).isEqualTo((Object)CqlField.CqlType.InternalType.Frozen);
        CqlField.CqlCollection valueInner = (CqlField.CqlCollection)((CqlField.CqlFrozen)value).inner();
        Assertions.assertThat((Comparable)valueInner.internalType()).isEqualTo((Object)CqlField.CqlType.InternalType.Map);
        CqlField.CqlMap valueMap = (CqlField.CqlMap)valueInner;
        Assertions.assertThat((Object)valueMap.keyType()).isEqualTo((Object)bridge.aInt());
        Assertions.assertThat((Comparable)valueMap.valueType().internalType()).isEqualTo((Object)CqlField.CqlType.InternalType.List);
        Assertions.assertThat((Object)((CqlField.CqlList)valueMap.valueType()).type()).isEqualTo((Object)bridge.blob());
    }

    private void testCqlTypeParser(String str, CqlField.CqlType expectedType, CassandraBridge bridge) {
        this.testCqlTypeParser(str, expectedType, null, bridge);
    }

    private void testCqlTypeParser(String str, CqlField.CqlType expectedType, CqlField.CqlType otherType, CassandraBridge bridge) {
        CqlField.CqlType type = bridge.parseType(str);
        if (type instanceof CqlField.CqlTuple) {
            Assertions.assertThat((Object)((CqlField.CqlTuple)type).type(0)).isEqualTo((Object)expectedType);
            if (otherType != null) {
                Assertions.assertThat((Object)((CqlField.CqlTuple)type).type(1)).isEqualTo((Object)otherType);
            }
        } else if (type instanceof CqlField.CqlCollection) {
            Assertions.assertThat((Object)((CqlField.CqlCollection)type).type()).isEqualTo((Object)expectedType);
            if (otherType != null) {
                Assertions.assertThat((Object)type).isInstanceOf(CqlField.CqlMap.class);
                Assertions.assertThat((Object)((CqlField.CqlMap)type).valueType()).isEqualTo((Object)otherType);
            }
        } else {
            Assertions.assertThat((Object)type).isInstanceOf(CqlField.NativeType.class);
            Assertions.assertThat((Object)type).isEqualTo((Object)expectedType);
        }
    }
}

