/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.bridge;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.cassandra.bridge.CassandraBridge;
import org.apache.cassandra.bridge.CassandraBridgeFactory;
import org.apache.cassandra.bridge.CassandraVersion;
import org.junit.jupiter.api.Named;

public final class VersionRunner {
    private VersionRunner() {
        throw new IllegalStateException(String.valueOf(this.getClass()) + " is static utility class and shall not be instantiated");
    }

    public static Collection<CassandraVersion> versions() {
        return Arrays.stream(CassandraVersion.implementedVersions()).collect(Collectors.toList());
    }

    public static Collection<String> supportedVersions() {
        return Arrays.stream(CassandraVersion.supportedVersions()).collect(Collectors.toList());
    }

    public static List<Named<CassandraBridge>> bridges() {
        return VersionRunner.versions().stream().map(version -> Named.of((String)version.toString(), (Object)CassandraBridgeFactory.get((CassandraVersion)version))).collect(Collectors.toList());
    }
}

