/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data;

import java.io.InputStream;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import o.a.c.sidecar.client.shaded.client.SidecarClient;
import o.a.c.sidecar.client.shaded.client.SidecarInstance;
import o.a.c.sidecar.client.shaded.common.response.ListSnapshotFilesResponse;
import o.a.c.sidecar.client.shaded.common.utils.HttpRange;
import org.apache.cassandra.analytics.stats.Stats;
import org.apache.cassandra.clients.Sidecar;
import org.apache.cassandra.clients.SidecarStreamConsumerAdapter;
import org.apache.cassandra.spark.data.FileType;
import org.apache.cassandra.spark.data.IncompleteSSTableException;
import org.apache.cassandra.spark.data.SSTable;
import org.apache.cassandra.spark.utils.streaming.BufferingInputStream;
import org.apache.cassandra.spark.utils.streaming.CassandraFileSource;
import org.apache.cassandra.spark.utils.streaming.StreamConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SidecarProvisionedSSTable
extends SSTable {
    private static final long serialVersionUID = 6452703925812602832L;
    private final SidecarClient sidecar;
    private final SidecarInstance instance;
    private final Sidecar.ClientConfig sidecarClientConfig;
    private final String keyspace;
    private final String table;
    private final String snapshotName;
    @NotNull
    private final String dataFileName;
    @NotNull
    private final Map<FileType, ListSnapshotFilesResponse.FileInfo> components;
    private final int partitionId;
    private final Stats stats;

    protected SidecarProvisionedSSTable(SidecarClient sidecar, Sidecar.ClientConfig sidecarClientConfig, SidecarInstance instance, String keyspace, String table, String snapshotName, @NotNull Map<FileType, ListSnapshotFilesResponse.FileInfo> components, int partitionId, Stats stats) {
        this.sidecar = sidecar;
        this.sidecarClientConfig = sidecarClientConfig;
        this.instance = instance;
        this.keyspace = keyspace;
        this.table = table;
        this.snapshotName = snapshotName;
        this.components = components;
        this.partitionId = partitionId;
        this.stats = stats;
        String fileName = Objects.requireNonNull(components.get((Object)FileType.DATA), (String)"Data.db SSTable file component must exist").fileName;
        String[] ssTableNameParts = fileName.split("-");
        this.dataFileName = this.parseDataFileName(ssTableNameParts);
    }

    protected String parseDataFileName(String[] ssTableNameParts) {
        return String.join((CharSequence)"-", ssTableNameParts[0], ssTableNameParts[1], ssTableNameParts[2], ssTableNameParts[3]);
    }

    public SidecarInstance instance() {
        return this.instance;
    }

    public int partitionId() {
        return this.partitionId;
    }

    @NotNull
    public String getDataFileName() {
        return this.dataFileName;
    }

    @Nullable
    protected InputStream openInputStream(FileType fileType) {
        ListSnapshotFilesResponse.FileInfo snapshotFile = this.components.get(fileType);
        if (snapshotFile == null) {
            return null;
        }
        return this.openStream(snapshotFile, fileType);
    }

    public long length(FileType fileType) {
        ListSnapshotFilesResponse.FileInfo snapshotFile = this.components.get(fileType);
        if (snapshotFile == null) {
            throw new IncompleteSSTableException(new FileType[]{fileType});
        }
        return snapshotFile.size;
    }

    public boolean isMissing(FileType fileType) {
        return !this.components.containsKey(fileType);
    }

    @Nullable
    private InputStream openStream(ListSnapshotFilesResponse.FileInfo snapshotFile, FileType fileType) {
        if (snapshotFile == null) {
            return null;
        }
        return this.open(snapshotFile, fileType);
    }

    public InputStream open(ListSnapshotFilesResponse.FileInfo fileInfo, FileType fileType) {
        CassandraFileSource<SidecarProvisionedSSTable> ssTableSource = this.source(fileInfo, fileType);
        return new BufferingInputStream(ssTableSource, this.stats.bufferingInputStreamStats());
    }

    private CassandraFileSource<SidecarProvisionedSSTable> source(final ListSnapshotFilesResponse.FileInfo fileInfo, final FileType fileType) {
        final SidecarProvisionedSSTable thisSSTable = this;
        return new CassandraFileSource<SidecarProvisionedSSTable>(){

            public void request(long start, long end, StreamConsumer consumer) {
                SidecarProvisionedSSTable.this.sidecar.streamSSTableComponent(SidecarProvisionedSSTable.this.instance, fileInfo, HttpRange.of((long)start, (long)end), (o.a.c.sidecar.client.shaded.client.StreamConsumer)new SidecarStreamConsumerAdapter(consumer));
            }

            public long maxBufferSize() {
                return SidecarProvisionedSSTable.this.sidecarClientConfig.maxBufferSize(fileType);
            }

            public long chunkBufferSize() {
                return SidecarProvisionedSSTable.this.sidecarClientConfig.chunkBufferSize(fileType);
            }

            @Nullable
            public Duration timeout() {
                int timeout = SidecarProvisionedSSTable.this.sidecarClientConfig.timeoutSeconds();
                return timeout > 0 ? Duration.ofSeconds(timeout) : null;
            }

            public SidecarProvisionedSSTable cassandraFile() {
                return thisSSTable;
            }

            public FileType fileType() {
                return fileType;
            }

            public long size() {
                return fileInfo.size;
            }
        };
    }

    public String toString() {
        return "SidecarProvisionedSSTable{hostname='" + this.instance.hostname() + "', port=" + this.instance.port() + ", keyspace='" + this.keyspace + "', table='" + this.table + "', snapshotName='" + this.snapshotName + "', dataFileName='" + this.dataFileName + "', partitionId=" + this.partitionId + "}";
    }

    public int hashCode() {
        return Objects.hash(this.instance, this.keyspace, this.table, this.snapshotName, this.dataFileName);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        SidecarProvisionedSSTable that = (SidecarProvisionedSSTable)((Object)object);
        return Objects.equals(this.instance, that.instance) && Objects.equals(this.keyspace, that.keyspace) && Objects.equals(this.table, that.table) && Objects.equals(this.snapshotName, that.snapshotName) && Objects.equals(this.dataFileName, that.dataFileName);
    }
}

