/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cdc.scanner;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.cassandra.cdc.api.CassandraSource;
import org.apache.cassandra.cdc.msg.CdcEvent;
import org.apache.cassandra.cdc.msg.FourZeroCdcEventBuilder;
import org.apache.cassandra.cdc.scanner.CdcStreamScanner;
import org.apache.cassandra.cdc.scanner.HybridUnfilteredPartitionIterator;
import org.apache.cassandra.cdc.state.CdcState;
import org.apache.cassandra.db.commitlog.FourZeroPartitionUpdateWrapper;
import org.apache.cassandra.db.commitlog.PartitionUpdateWrapper;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.rows.RangeTombstoneMarker;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.jetbrains.annotations.NotNull;

@NotThreadSafe
public class CdcSortedStreamScanner
implements AutoCloseable,
CdcStreamScanner {
    final Queue<FourZeroPartitionUpdateWrapper> updates = new PriorityQueue<FourZeroPartitionUpdateWrapper>(PartitionUpdateWrapper::compareTo);
    private final UnfilteredPartitionIterator partitionIterator;
    private UnfilteredRowIterator currentPartition = null;
    private CdcEvent event;
    protected FourZeroCdcEventBuilder rangeDeletionBuilder;
    private final Random random;
    private final CdcState endState;
    private final CassandraSource cassandraSource;
    private final Double samplingRate;

    protected CdcSortedStreamScanner(@NotNull Collection<FourZeroPartitionUpdateWrapper> updates, @NotNull CdcState endState) {
        this(updates, endState, ThreadLocalRandom.current(), CassandraSource.DEFAULT, 0.0);
    }

    public CdcSortedStreamScanner(@NotNull Collection<FourZeroPartitionUpdateWrapper> updates, @NotNull CdcState endState, @NotNull Random random, CassandraSource cassandraSource, Double samplingRate) {
        this.updates.addAll(updates);
        this.partitionIterator = new HybridUnfilteredPartitionIterator(this);
        this.endState = endState;
        this.random = random;
        this.cassandraSource = cassandraSource;
        this.samplingRate = samplingRate;
    }

    public CdcState endState() {
        return this.endState;
    }

    public CdcEvent data() {
        Preconditions.checkState((this.event != null ? 1 : 0) != 0, (Object)"No data available. Make sure hasNext is called before this method!");
        CdcEvent data = this.event;
        this.event = null;
        return data;
    }

    public boolean next() {
        while (true) {
            if (this.allExhausted()) {
                return false;
            }
            String trackingId = null;
            if (this.random.nextDouble() < this.samplingRate()) {
                trackingId = UUID.randomUUID().toString();
            }
            if (this.currentPartition == null) {
                this.currentPartition = (UnfilteredRowIterator)this.partitionIterator.next();
                if (!this.currentPartition.partitionLevelDeletion().isLive()) {
                    this.event = this.makePartitionTombstone(this.currentPartition, trackingId);
                    this.currentPartition = null;
                    return true;
                }
                Row staticRow = this.currentPartition.staticRow();
                if (!this.currentPartition.hasNext() && staticRow != null && staticRow != Rows.EMPTY_STATIC_ROW) {
                    this.event = this.makeStaticRow(staticRow, this.currentPartition, trackingId);
                    this.currentPartition = null;
                    return true;
                }
            }
            if (!this.currentPartition.hasNext()) {
                this.currentPartition = null;
                if (this.rangeDeletionBuilder == null) continue;
                this.event = this.rangeDeletionBuilder.build();
                this.rangeDeletionBuilder = null;
                return true;
            }
            Unfiltered unfiltered = (Unfiltered)this.currentPartition.next();
            if (unfiltered.isRow()) {
                Row row = (Row)unfiltered;
                this.event = this.makeRow(row, this.currentPartition, trackingId);
                return true;
            }
            if (!unfiltered.isRangeTombstoneMarker()) break;
            RangeTombstoneMarker rangeTombstoneMarker = (RangeTombstoneMarker)unfiltered;
            this.handleRangeTombstone(rangeTombstoneMarker, this.currentPartition, trackingId);
        }
        throw new IllegalStateException("Encountered unknown Unfiltered kind.");
    }

    public void advanceToNextColumn() {
        throw new UnsupportedOperationException("not implemented!");
    }

    private boolean allExhausted() {
        return !this.partitionIterator.hasNext() && this.currentPartition == null && this.rangeDeletionBuilder == null;
    }

    @Override
    public void close() {
        this.updates.clear();
    }

    public CdcEvent makeRow(Row row, UnfilteredRowIterator partition, String trackingId) {
        return this.makeRow(row, partition, false, trackingId);
    }

    private CdcEvent makeStaticRow(Row row, UnfilteredRowIterator partition, String trackingId) {
        return this.makeRow(row, partition, true, trackingId);
    }

    private CdcEvent makeRow(Row row, UnfilteredRowIterator partition, boolean isStaticOnly, String trackingId) {
        if (!row.deletion().isLive()) {
            return this.buildRowDelete(row, partition, trackingId);
        }
        if (row.primaryKeyLivenessInfo().isEmpty()) {
            return this.buildUpdate(row, partition, isStaticOnly, trackingId);
        }
        return this.buildInsert(row, partition, isStaticOnly, trackingId);
    }

    public Double samplingRate() {
        return this.samplingRate;
    }

    public CdcEvent buildRowDelete(Row row, UnfilteredRowIterator partition, String trackingId) {
        return FourZeroCdcEventBuilder.build(CdcEvent.Kind.ROW_DELETE, partition, row, trackingId, this.cassandraSource);
    }

    public CdcEvent buildUpdate(Row row, UnfilteredRowIterator partition, boolean isStaticOnly, String trackingId) {
        FourZeroCdcEventBuilder builder = FourZeroCdcEventBuilder.of(CdcEvent.Kind.UPDATE, partition, trackingId, this.cassandraSource);
        if (!isStaticOnly) {
            builder.withRow(row);
        }
        return builder.build();
    }

    public CdcEvent buildInsert(Row row, UnfilteredRowIterator partition, boolean isStaticOnly, String trackingId) {
        FourZeroCdcEventBuilder builder = FourZeroCdcEventBuilder.of(CdcEvent.Kind.INSERT, partition, trackingId, this.cassandraSource);
        if (!isStaticOnly) {
            builder.withRow(row);
        }
        return builder.build();
    }

    public CdcEvent makePartitionTombstone(UnfilteredRowIterator partition, String trackingId) {
        return FourZeroCdcEventBuilder.of(CdcEvent.Kind.PARTITION_DELETE, partition, trackingId, this.cassandraSource).build();
    }

    public void handleRangeTombstone(RangeTombstoneMarker marker, UnfilteredRowIterator partition, String trackingId) {
        if (this.rangeDeletionBuilder == null) {
            this.rangeDeletionBuilder = FourZeroCdcEventBuilder.of(CdcEvent.Kind.RANGE_DELETE, partition, trackingId, this.cassandraSource);
        }
        this.rangeDeletionBuilder.addRangeTombstoneMarker(marker);
    }
}

