/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.analytics.testcontainer;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.cassandra.analytics.testcontainer.LocalStorageTransportExtension;
import org.apache.cassandra.spark.transports.storage.StorageAccessConfiguration;
import org.apache.cassandra.spark.transports.storage.StorageCredentialPair;
import org.apache.cassandra.spark.transports.storage.extensions.CoordinationSignalListener;
import org.apache.cassandra.spark.transports.storage.extensions.StorageTransportConfiguration;
import org.apache.spark.SparkConf;

public class LocalCoordinatedStorageTransportExtension
extends LocalStorageTransportExtension {
    private String jobId;
    private CoordinationSignalListener coordinationSignalListener;

    @Override
    public void initialize(String jobId, SparkConf conf, boolean isOnDriver) {
        this.jobId = jobId;
    }

    @Override
    public StorageTransportConfiguration getStorageConfiguration() {
        StorageCredentialPair tokens = LocalCoordinatedStorageTransportExtension.generateTokens();
        return new StorageTransportConfiguration("key-prefix", (Map)ImmutableMap.of(), new StorageAccessConfiguration("writeRegion", "sbw-bucket", tokens.writeCredentials), (Map)ImmutableMap.of((Object)"cluster1", (Object)new StorageAccessConfiguration("readRegion1", "sbw-bucket", tokens.readCredentials), (Object)"cluster2", (Object)new StorageAccessConfiguration("readRegion2", "sbw-bucket", tokens.readCredentials)));
    }

    @Override
    public void setCoordinationSignalListener(CoordinationSignalListener listener) {
        this.coordinationSignalListener = listener;
    }

    @Override
    public void onAllObjectsPersisted(long objectsCount, long rowCount, long elapsedMillis) {
        this.coordinationSignalListener.onStageReady(this.jobId);
    }

    @Override
    public void onStageSucceeded(String clusterId, long elapsedMillis) {
        this.coordinationSignalListener.onImportReady(this.jobId);
    }
}

