/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.analytics.expansion;

import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.TypeResolutionStrategy;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.implementation.bind.annotation.SuperCall;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.pool.TypePool;
import org.apache.cassandra.analytics.TestConsistencyLevel;
import org.apache.cassandra.analytics.TestUninterruptibles;
import org.apache.cassandra.analytics.expansion.JoiningTestBase;
import org.apache.cassandra.distributed.api.ConsistencyLevel;
import org.apache.cassandra.distributed.api.Feature;
import org.apache.cassandra.sidecar.testing.QualifiedName;
import org.apache.cassandra.testing.ClusterBuilderConfiguration;
import org.apache.cassandra.testing.TestUtils;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class JoiningMultiDCTest
extends JoiningTestBase {
    JoiningMultiDCTest() {
    }

    @ParameterizedTest(name="{index} => {0}")
    @MethodSource(value={"multiDCTestInputs"})
    void testJoiningNodeInMultiDCTest(TestConsistencyLevel cl) {
        this.runJoiningTestScenario(cl);
    }

    protected void initializeSchemaForTest() {
        this.createTestKeyspace("spark_test", TestUtils.DC1_RF3_DC2_RF3);
        JoiningMultiDCTest.multiDCTestInputs().forEach(arguments -> {
            QualifiedName tableName = JoiningMultiDCTest.uniqueTestTableFullName("spark_test", arguments.get());
            this.createTestTable(tableName, "CREATE TABLE IF NOT EXISTS %s (id int, course text, marks int, PRIMARY KEY (id)) WITH read_repair='NONE';");
        });
    }

    protected void beforeClusterShutdown() {
        this.completeTransitionsAndValidateWrites(BBHelperMultiDC.transitioningStateEnd, JoiningMultiDCTest.multiDCTestInputs(), false);
    }

    protected ClusterBuilderConfiguration testClusterConfiguration() {
        return JoiningMultiDCTest.clusterConfig().nodesPerDc(3).newNodesPerDc(3).dcCount(2).requestFeature(Feature.NETWORK).instanceInitializer(BBHelperMultiDC::install);
    }

    @Override
    protected CountDownLatch transitioningStateStart() {
        return BBHelperMultiDC.transitioningStateStart;
    }

    static Stream<Arguments> multiDCTestInputs() {
        return Stream.of(Arguments.of((Object[])new Object[]{TestConsistencyLevel.of(ConsistencyLevel.ALL, ConsistencyLevel.ONE)}), Arguments.of((Object[])new Object[]{TestConsistencyLevel.of(ConsistencyLevel.LOCAL_QUORUM, ConsistencyLevel.LOCAL_QUORUM)}), Arguments.of((Object[])new Object[]{TestConsistencyLevel.of(ConsistencyLevel.EACH_QUORUM, ConsistencyLevel.LOCAL_QUORUM)}), Arguments.of((Object[])new Object[]{TestConsistencyLevel.of(ConsistencyLevel.QUORUM, ConsistencyLevel.QUORUM)}), Arguments.of((Object[])new Object[]{TestConsistencyLevel.of(ConsistencyLevel.LOCAL_QUORUM, ConsistencyLevel.EACH_QUORUM)}), Arguments.of((Object[])new Object[]{TestConsistencyLevel.of(ConsistencyLevel.ONE, ConsistencyLevel.ALL)}));
    }

    public static class BBHelperMultiDC {
        static final CountDownLatch transitioningStateStart = new CountDownLatch(6);
        static final CountDownLatch transitioningStateEnd = new CountDownLatch(6);

        public static void install(ClassLoader cl, Integer nodeNumber) {
            if (nodeNumber > 6) {
                TypePool typePool = TypePool.Default.of((ClassLoader)cl);
                TypeDescription description = typePool.describe("org.apache.cassandra.service.StorageService").resolve();
                new ByteBuddy().rebase(description, ClassFileLocator.ForClassLoader.of((ClassLoader)cl)).method((ElementMatcher)ElementMatchers.named((String)"bootstrap").and((ElementMatcher)ElementMatchers.takesArguments((int)2))).intercept((Implementation)MethodDelegation.to(BBHelperMultiDC.class)).make((TypeResolutionStrategy)TypeResolutionStrategy.Lazy.INSTANCE, typePool).load(cl, (ClassLoadingStrategy)ClassLoadingStrategy.Default.INJECTION);
            }
        }

        public static boolean bootstrap(Collection<?> tokens, long bootstrapTimeoutMillis, @SuperCall Callable<Boolean> orig) throws Exception {
            boolean result = orig.call();
            transitioningStateStart.countDown();
            TestUninterruptibles.awaitUninterruptiblyOrThrow(transitioningStateEnd, 2L, TimeUnit.MINUTES);
            return result;
        }
    }
}

