/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.analytics.data;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.cassandra.analytics.SharedClusterSparkIntegrationTestBase;
import org.apache.cassandra.distributed.api.ConsistencyLevel;
import org.apache.cassandra.distributed.shared.Uninterruptibles;
import org.apache.cassandra.sidecar.testing.QualifiedName;
import org.apache.cassandra.testing.TestUtils;
import org.apache.spark.sql.DataFrameReader;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ClearSnapshotTest
extends SharedClusterSparkIntegrationTestBase {
    static final QualifiedName TABLE_NAME_FOR_TTL_CLEAR_SNAPSHOT_STRATEGY = new QualifiedName("spark_test", "test_ttl_clear_snapshot_strategy");
    static final QualifiedName TABLE_NAME_FOR_NO_OP_CLEAR_SNAPSHOT_STRATEGY = new QualifiedName("spark_test", "test_no_op_clear_snapshot_strategy");
    static final List<String> DATASET = Arrays.asList("a", "b", "c", "d", "e", "f", "g", "h");

    ClearSnapshotTest() {
    }

    @Test
    void testTTLClearSnapshotStrategy() {
        DataFrameReader readDf = this.bulkReaderDataFrame(TABLE_NAME_FOR_TTL_CLEAR_SNAPSHOT_STRATEGY).option("snapshotName", "ttlClearSnapshotStrategyTest").option("clearSnapshotStrategy", "TTL 10s");
        List rows = readDf.load().collectAsList();
        Assertions.assertThat((int)rows.size()).isEqualTo(8);
        String[] dataDirs = (String[])this.cluster.get(1).config().getParams().get("data_file_directories");
        String dataDir = dataDirs[0];
        List<Path> snapshotPaths = this.findChildFile(Paths.get(dataDir, new String[0]), "ttlClearSnapshotStrategyTest");
        Assertions.assertThat(snapshotPaths).isNotEmpty();
        Path snapshot = snapshotPaths.get(0);
        Assertions.assertThat((Path)snapshot).exists();
        int wait = 0;
        while (Files.exists(snapshot, new LinkOption[0]) && wait++ < 30) {
            Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
        Assertions.assertThat((Path)snapshot).doesNotExist();
    }

    @Test
    void testNoOpClearSnapshotStrategy() {
        DataFrameReader readDf = this.bulkReaderDataFrame(TABLE_NAME_FOR_NO_OP_CLEAR_SNAPSHOT_STRATEGY).option("snapshotName", "noOpClearSnapshotStrategyTest").option("clearSnapshotStrategy", "noOp");
        List rows = readDf.load().collectAsList();
        Assertions.assertThat((int)rows.size()).isEqualTo(8);
        String[] dataDirs = (String[])this.cluster.get(1).config().getParams().get("data_file_directories");
        String dataDir = dataDirs[0];
        List<Path> snapshotPaths = this.findChildFile(Paths.get(dataDir, new String[0]), "noOpClearSnapshotStrategyTest");
        Assertions.assertThat(snapshotPaths).isNotEmpty();
        Path snapshot = snapshotPaths.get(0);
        Assertions.assertThat((Path)snapshot).exists();
        Uninterruptibles.sleepUninterruptibly((long)30L, (TimeUnit)TimeUnit.SECONDS);
        Assertions.assertThat((Path)snapshot).exists();
    }

    private List<Path> findChildFile(Path path, String target) {
        List<Path> list;
        block8: {
            Stream<Path> walkStream = Files.walk(path, new FileVisitOption[0]);
            try {
                list = walkStream.filter(p -> p.getFileName().endsWith(target) || p.toString().contains("/" + target + "/")).collect(Collectors.toList());
                if (walkStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (walkStream != null) {
                        try {
                            walkStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return Collections.emptyList();
                }
            }
            walkStream.close();
        }
        return list;
    }

    protected void beforeClusterProvisioning() {
        System.setProperty("cassandra.snapshot.ttl_cleanup_initial_delay_seconds", "0");
        System.setProperty("cassandra.snapshot.ttl_cleanup_period_seconds", "1");
        System.setProperty("cassandra.snapshot.min_allowed_ttl_seconds", "5");
    }

    @Override
    protected void afterClusterShutdown() {
        System.clearProperty("cassandra.snapshot.ttl_cleanup_initial_delay_seconds");
        System.clearProperty("cassandra.snapshot.ttl_cleanup_period_seconds");
        System.clearProperty("cassandra.snapshot.min_allowed_ttl_seconds");
    }

    protected void initializeSchemaForTest() {
        this.createTestKeyspace("spark_test", TestUtils.DC1_RF1);
        String createTableStatement = "CREATE TABLE IF NOT EXISTS %s (c1 int, c2 text, PRIMARY KEY(c1));";
        this.createTestTable(TABLE_NAME_FOR_TTL_CLEAR_SNAPSHOT_STRATEGY, createTableStatement);
        this.populateTable(TABLE_NAME_FOR_TTL_CLEAR_SNAPSHOT_STRATEGY);
        this.createTestTable(TABLE_NAME_FOR_NO_OP_CLEAR_SNAPSHOT_STRATEGY, createTableStatement);
        this.populateTable(TABLE_NAME_FOR_NO_OP_CLEAR_SNAPSHOT_STRATEGY);
    }

    void populateTable(QualifiedName tableName) {
        for (int i = 0; i < DATASET.size(); ++i) {
            String value = DATASET.get(i);
            String query = String.format("INSERT INTO %s (c1, c2) VALUES (%d, '%s');", tableName, i, value);
            this.cluster.get(1).coordinator().execute(query, ConsistencyLevel.ALL, new Object[0]);
        }
    }
}

