/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.analytics;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.cassandra.analytics.SharedClusterSparkIntegrationTestBase;
import org.apache.cassandra.sidecar.testing.QualifiedName;
import org.apache.cassandra.testing.TestUtils;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class QuoteIdentifiersReadTest
extends SharedClusterSparkIntegrationTestBase {
    static final List<String> DATASET = Arrays.asList("a", "b", "c", "d", "e", "f", "g");
    static final QualifiedName TABLE_NAME_FOR_UDT_TEST = TestUtils.uniqueTestQuotedKeyspaceQuotedTableFullName((String)"QuOtEd_KeYsPaCe", (String)"QuOtEd_TaBlE");
    static final List<QualifiedName> TABLE_NAMES = Arrays.asList(TestUtils.uniqueTestQuotedKeyspaceTableFullName((String)"QuOtEd_KeYsPaCe"), TestUtils.uniqueTestQuotedKeyspaceTableFullName((String)"keyspace"), TestUtils.uniqueTestKeyspaceQuotedTableFullName((String)"spark_test", (String)"QuOtEd_TaBlE"), new QualifiedName("spark_test", "table", false, true), TABLE_NAME_FOR_UDT_TEST);
    static final AtomicInteger uniqueNumber = new AtomicInteger();
    static final Map<QualifiedName, Integer> nameToUniqueNumber = new HashMap<QualifiedName, Integer>();

    QuoteIdentifiersReadTest() {
    }

    @ParameterizedTest(name="{index} => table={0}")
    @MethodSource(value={"testInputs"})
    void testQuoteIdentifiersBulkRead(QualifiedName tableName) {
        Dataset data = this.bulkReaderDataFrame(tableName).option("quote_identifiers", "true").load();
        Assertions.assertThat((long)data.count()).isEqualTo((long)DATASET.size());
        List rowList = data.collectAsList().stream().sorted(Comparator.comparing(row -> row.getString(0))).collect(Collectors.toList());
        int uniqueNumberForTest = nameToUniqueNumber.get(tableName);
        for (int i = 0; i < DATASET.size(); ++i) {
            Assertions.assertThat((String)((Row)rowList.get(i)).getString(0)).isEqualTo(DATASET.get(i) + "_" + uniqueNumberForTest);
            Assertions.assertThat((int)((Row)rowList.get(i)).getInt(1)).isEqualTo(uniqueNumberForTest * 100 + i);
        }
    }

    @Test
    void testReadComplexSchema() {
        Dataset data = this.bulkReaderDataFrame(TABLE_NAME_FOR_UDT_TEST).option("quote_identifiers", "true").load();
        Assertions.assertThat((long)data.count()).isEqualTo((long)DATASET.size());
        List rowList = data.collectAsList().stream().sorted(Comparator.comparing(row -> row.getString(0))).collect(Collectors.toList());
        int uniqueNumberForTest = nameToUniqueNumber.get(TABLE_NAME_FOR_UDT_TEST);
        for (int i = 0; i < DATASET.size(); ++i) {
            Row row2 = (Row)rowList.get(i);
            Assertions.assertThat((String)((Row)rowList.get(i)).getString(0)).isEqualTo(DATASET.get(i) + "_" + uniqueNumberForTest);
            Assertions.assertThat((int)((Row)rowList.get(i)).getInt(1)).isEqualTo(uniqueNumberForTest * 100 + i);
            Assertions.assertThat((long)row2.getStruct(2).getLong(0)).isEqualTo((long)i);
            Assertions.assertThat((int)row2.getStruct(2).getInt(1)).isEqualTo(i);
        }
    }

    static Stream<Arguments> testInputs() {
        return TABLE_NAMES.stream().map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    protected void initializeSchemaForTest() {
        String createTableStatement = "CREATE TABLE IF NOT EXISTS %s (\"IdEnTiFiEr\" text, IdEnTiFiEr int, PRIMARY KEY(\"IdEnTiFiEr\"));";
        TABLE_NAMES.forEach(name -> {
            this.createTestKeyspace((QualifiedName)name, TestUtils.DC1_RF1);
            if (!name.equals((Object)TABLE_NAME_FOR_UDT_TEST)) {
                this.createTestTable((QualifiedName)name, createTableStatement);
                this.populateTable((QualifiedName)name, DATASET);
            }
        });
        String createUdtQuery = "CREATE TYPE " + TABLE_NAME_FOR_UDT_TEST.maybeQuotedKeyspace() + ".\"UdT1\" (\"TimE\" bigint, \"limit\" int);";
        this.cluster.schemaChange(createUdtQuery);
        this.createTestTable(TABLE_NAME_FOR_UDT_TEST, "CREATE TABLE IF NOT EXISTS %s (\"IdEnTiFiEr\" text, IdEnTiFiEr int, \"User_Defined_Type\" frozen<\"UdT1\">, PRIMARY KEY(\"IdEnTiFiEr\", IdEnTiFiEr));");
        this.populateTableWithUdt(TABLE_NAME_FOR_UDT_TEST, DATASET);
    }

    void populateTable(QualifiedName tableName, List<String> values) {
        int uniqueNumberForTest = uniqueNumber.incrementAndGet();
        nameToUniqueNumber.put(tableName, uniqueNumberForTest);
        for (int i = 0; i < values.size(); ++i) {
            String value = values.get(i);
            String query = String.format("INSERT INTO %s (\"IdEnTiFiEr\", IdEnTiFiEr) VALUES ('%s', %d);", tableName, value + "_" + uniqueNumberForTest, uniqueNumberForTest * 100 + i);
            this.cluster.schemaChange(query);
        }
    }

    void populateTableWithUdt(QualifiedName tableName, List<String> dataset) {
        int uniqueNumberForTest = uniqueNumber.incrementAndGet();
        nameToUniqueNumber.put(tableName, uniqueNumberForTest);
        for (int i = 0; i < dataset.size(); ++i) {
            String value = dataset.get(i);
            String query = String.format("INSERT INTO %s (\"IdEnTiFiEr\", IdEnTiFiEr, \"User_Defined_Type\") VALUES ('%s', %d, { \"TimE\" : %d, \"limit\" : %d });", tableName, value + "_" + uniqueNumberForTest, uniqueNumberForTest * 100 + i, i, i);
            this.cluster.schemaChange(query);
        }
    }
}

