/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cdc.msg.jdk;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.cassandra.cdc.msg.RangeTombstone;
import org.apache.cassandra.cdc.msg.jdk.Column;
import org.apache.cassandra.cdc.msg.jdk.JdkMessageConverter;

public class RangeTombstoneMsg {
    private final List<Column> startBound;
    private final List<Column> endBound;
    public final boolean startInclusive;
    public final boolean endInclusive;

    public RangeTombstoneMsg(JdkMessageConverter valueConverter, RangeTombstone tombstone) {
        this.startBound = tombstone.getStartBound().stream().map(valueConverter::toCdcMessage).collect(Collectors.toList());
        this.endBound = tombstone.getEndBound().stream().map(valueConverter::toCdcMessage).collect(Collectors.toList());
        this.startInclusive = tombstone.startInclusive;
        this.endInclusive = tombstone.endInclusive;
    }

    public List<Column> startBound() {
        return this.startBound;
    }

    public List<Column> endBound() {
        return this.endBound;
    }

    public boolean isStartInclusive() {
        return this.startInclusive;
    }

    public boolean isEndInclusive() {
        return this.endInclusive;
    }
}

