/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.client.request;

import org.apache.cassandra.sidecar.client.RequestContext;
import org.apache.cassandra.sidecar.client.request.RequestTestParameters;
import org.apache.cassandra.sidecar.common.response.TimeSkewResponse;
import org.assertj.core.api.Assertions;

public class TimeSkewRequestTestParameters
implements RequestTestParameters<TimeSkewResponse> {
    @Override
    public RequestContext.Builder specificRequest(RequestContext.Builder requestContextBuilder) {
        return requestContextBuilder.timeSkewRequest();
    }

    @Override
    public String okResponseBody() {
        return "{\"currentTime\":123456789, \"allowableSkewInMinutes\": 32}";
    }

    @Override
    public String expectedEndpointPath() {
        return "/api/v1/time-skew";
    }

    @Override
    public void validateResponse(TimeSkewResponse responseObject) {
        Assertions.assertThat((long)responseObject.currentTime).isEqualTo(123456789L);
        Assertions.assertThat((int)responseObject.allowableSkewInMinutes).isEqualTo(32);
    }
}

