/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.sparksql;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.cassandra.analytics.stats.Stats;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.cassandra.spark.data.CqlTable;
import org.apache.cassandra.spark.sparksql.Cell;
import org.apache.cassandra.spark.sparksql.CellIterator;
import org.apache.cassandra.spark.sparksql.FullRowBuilder;
import org.apache.cassandra.spark.sparksql.PartialRowBuilder;
import org.apache.cassandra.spark.sparksql.RowBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RowIterator<T> {
    private final Stats stats;
    protected final CellIterator it;
    private final long openTimeNanos;
    private final RowBuilder<T> builder;
    @Nullable
    protected final String[] requiredColumns;
    protected T row;
    private Cell cell = null;

    protected RowIterator(CellIterator it, Stats stats, @Nullable String[] requiredColumns, Function<RowBuilder<T>, RowBuilder<T>> decorator) {
        this.stats = stats;
        this.it = it;
        this.openTimeNanos = System.nanoTime();
        this.requiredColumns = requiredColumns;
        this.builder = this.newBuilder(decorator);
    }

    public static RowIterator<Map<String, Object>> rowMapIterator(CellIterator it, Stats stats, @Nullable String[] requiredColumns) {
        final CqlTable cqlTable = it.cqlTable();
        final boolean hasProjectedValueColumns = it.hasProjectedValueColumns();
        return new RowIterator<Map<String, Object>>(it, stats, requiredColumns, Function.identity()){

            @Override
            public PartialRowBuilder<Map<String, Object>> newPartialBuilder() {
                return new PartialRowBuilder<Map<String, Object>>(this.requiredColumns, this.it.cqlTable(), hasProjectedValueColumns, valueArray -> {
                    HashMap<String, Object> row = new HashMap<String, Object>(this.requiredColumns.length);
                    for (int i = 0; i < this.requiredColumns.length; ++i) {
                        row.put(this.requiredColumns[i], valueArray[i]);
                    }
                    return row;
                });
            }

            @Override
            public FullRowBuilder<Map<String, Object>> newFullRowBuilder() {
                return new FullRowBuilder<Map<String, Object>>(cqlTable, hasProjectedValueColumns, valueArray -> {
                    HashMap<String, Object> row = new HashMap<String, Object>(cqlTable.numFields());
                    for (CqlField field : cqlTable.fields()) {
                        row.put(field.name(), valueArray[field.position()]);
                    }
                    return row;
                });
            }
        };
    }

    @NotNull
    protected RowBuilder<T> newBuilder(Function<RowBuilder<T>, RowBuilder<T>> decorator) {
        RowBuilder<T> builder = this.requiredColumns != null ? this.newPartialBuilder() : this.newFullRowBuilder();
        builder = decorator.apply(builder);
        builder.reset();
        return builder;
    }

    public abstract PartialRowBuilder<T> newPartialBuilder();

    public abstract FullRowBuilder<T> newFullRowBuilder();

    public boolean next() throws IOException {
        if (this.cell == null && !this.it.hasNextThrows()) {
            return false;
        }
        do {
            if (this.cell == null) {
                this.cell = this.it.next();
            }
            if (this.builder.isFirstCell()) {
                assert (this.cell.isNewRow);
                this.builder.copyKeys(this.cell);
            } else if (this.cell.isNewRow) break;
            this.builder.onCell(this.cell);
            if (this.it.hasProjectedValueColumns()) {
                this.builder.copyValue(this.cell);
            }
            this.cell = null;
        } while (this.builder.hasMoreCells() && this.it.hasNextThrows());
        this.row = this.builder.build();
        this.builder.reset();
        this.stats.nextRow();
        return true;
    }

    public void close() throws IOException {
        this.stats.closedSparkRowIterator(System.nanoTime() - this.openTimeNanos);
        this.it.close();
    }

    public T get() {
        return this.row;
    }
}

