/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.v1.bbtree;

import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.index.sai.disk.ResettableByteBuffersIndexOutput;
import org.apache.cassandra.index.sai.disk.v1.SAICodecUtils;
import org.apache.cassandra.index.sai.disk.v1.bbtree.LeafOrderMap;
import org.apache.cassandra.index.sai.utils.IndexEntry;
import org.apache.cassandra.utils.ByteArrayUtil;
import org.apache.cassandra.utils.bytecomparable.ByteComparable;
import org.apache.cassandra.utils.bytecomparable.ByteSourceInverse;
import org.apache.lucene.store.ByteBuffersDataOutput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IntroSorter;

@NotThreadSafe
public class BlockBalancedTreeWriter {
    public static final boolean DEBUG = CassandraRelevantProperties.SAI_TEST_BALANCED_TREE_DEBUG_ENABLED.getBoolean();
    public static final int DEFAULT_MAX_POINTS_IN_LEAF_NODE = 1024;
    private final int bytesPerValue;
    private final int maxPointsInLeafNode;
    private final byte[] minPackedValue;
    private final byte[] maxPackedValue;
    private long valueCount;

    public BlockBalancedTreeWriter(int bytesPerValue, int maxPointsInLeafNode) {
        if (maxPointsInLeafNode <= 0) {
            throw new IllegalArgumentException("maxPointsInLeafNode must be > 0; got " + maxPointsInLeafNode);
        }
        if (maxPointsInLeafNode > ArrayUtil.MAX_ARRAY_LENGTH) {
            throw new IllegalArgumentException("maxPointsInLeafNode must be <= ArrayUtil.MAX_ARRAY_LENGTH (= " + ArrayUtil.MAX_ARRAY_LENGTH + "); got " + maxPointsInLeafNode);
        }
        this.maxPointsInLeafNode = maxPointsInLeafNode;
        this.bytesPerValue = bytesPerValue;
        this.minPackedValue = new byte[bytesPerValue];
        this.maxPackedValue = new byte[bytesPerValue];
    }

    public long getValueCount() {
        return this.valueCount;
    }

    public int getBytesPerValue() {
        return this.bytesPerValue;
    }

    public int getMaxPointsInLeafNode() {
        return this.maxPointsInLeafNode;
    }

    public long write(IndexOutput treeOutput, Iterator<IndexEntry> iterator, Callback callback) throws IOException {
        long treeFilePointer;
        SAICodecUtils.writeHeader(treeOutput);
        LeafWriter leafWriter = new LeafWriter(treeOutput, callback);
        while (iterator.hasNext()) {
            long segmentRowId;
            IndexEntry indexEntry = iterator.next();
            while ((segmentRowId = indexEntry.postingList.nextPosting()) != Long.MAX_VALUE) {
                leafWriter.add(indexEntry.term, segmentRowId);
            }
        }
        this.valueCount = leafWriter.finish();
        long l = treeFilePointer = this.valueCount == 0L ? -1L : treeOutput.getFilePointer();
        if (treeFilePointer >= 0L) {
            this.writeBalancedTree(treeOutput, this.maxPointsInLeafNode, leafWriter.leafBlockStartValues, leafWriter.leafBlockFilePointers);
        }
        SAICodecUtils.writeFooter(treeOutput);
        return treeFilePointer;
    }

    private void writeBalancedTree(IndexOutput out, int countPerLeaf, List<byte[]> leafBlockStartValues, List<Long> leafBlockFilePointer) throws IOException {
        int numInnerNodes = leafBlockStartValues.size();
        byte[] splitValues = new byte[(1 + numInnerNodes) * this.bytesPerValue];
        int treeDepth = this.recurseBalanceTree(1, 0, numInnerNodes, 1, splitValues, leafBlockStartValues);
        long[] leafBlockFPs = leafBlockFilePointer.stream().mapToLong(l -> l).toArray();
        byte[] packedIndex = this.packIndex(leafBlockFPs, splitValues);
        out.writeVInt(countPerLeaf);
        out.writeVInt(this.bytesPerValue);
        out.writeVInt(leafBlockFPs.length);
        out.writeVInt(Math.min(treeDepth, leafBlockFPs.length));
        out.writeBytes(this.minPackedValue, 0, this.bytesPerValue);
        out.writeBytes(this.maxPackedValue, 0, this.bytesPerValue);
        out.writeVLong(this.valueCount);
        out.writeVInt(packedIndex.length);
        out.writeBytes(packedIndex, 0, packedIndex.length);
    }

    private int recurseBalanceTree(int nodeID, int offset, int count, int treeDepth, byte[] splitValues, List<byte[]> leafBlockStartValues) {
        if (count == 1) {
            ++treeDepth;
            System.arraycopy(leafBlockStartValues.get(offset), 0, splitValues, nodeID * this.bytesPerValue, this.bytesPerValue);
        } else {
            if (count > 1) {
                ++treeDepth;
                int countAtLevel = 1;
                int totalCount = 0;
                while (true) {
                    int countLeft;
                    if ((countLeft = count - totalCount) <= countAtLevel) {
                        int lastLeftCount = Math.min(countAtLevel / 2, countLeft);
                        assert (lastLeftCount >= 0);
                        int leftHalf = (totalCount - 1) / 2 + lastLeftCount;
                        int rootOffset = offset + leftHalf;
                        System.arraycopy(leafBlockStartValues.get(rootOffset), 0, splitValues, nodeID * this.bytesPerValue, this.bytesPerValue);
                        int leftTreeDepth = this.recurseBalanceTree(2 * nodeID, offset, leftHalf, treeDepth, splitValues, leafBlockStartValues);
                        int rightTreeDepth = this.recurseBalanceTree(2 * nodeID + 1, rootOffset + 1, count - leftHalf - 1, treeDepth, splitValues, leafBlockStartValues);
                        return Math.max(leftTreeDepth, rightTreeDepth);
                    }
                    totalCount += countAtLevel;
                    countAtLevel *= 2;
                }
            }
            assert (count == 0);
        }
        return treeDepth;
    }

    private byte[] packIndex(long[] leafBlockFPs, byte[] splitValues) throws IOException {
        int numLeaves = leafBlockFPs.length;
        if (numLeaves > 1) {
            int levelCount = 2;
            while (true) {
                if (numLeaves >= levelCount && numLeaves <= 2 * levelCount) {
                    int lastLevel = 2 * (numLeaves - levelCount);
                    assert (lastLevel >= 0);
                    if (lastLevel == 0) break;
                    long[] newLeafBlockFPs = new long[numLeaves];
                    System.arraycopy(leafBlockFPs, lastLevel, newLeafBlockFPs, 0, leafBlockFPs.length - lastLevel);
                    System.arraycopy(leafBlockFPs, 0, newLeafBlockFPs, leafBlockFPs.length - lastLevel, lastLevel);
                    leafBlockFPs = newLeafBlockFPs;
                    break;
                }
                levelCount *= 2;
            }
        }
        try (ResettableByteBuffersIndexOutput writeBuffer = new ResettableByteBuffersIndexOutput("PackedIndex");){
            ArrayList<byte[]> blocks = new ArrayList<byte[]>();
            byte[] lastSplitValue = new byte[this.bytesPerValue];
            int totalSize = this.recursePackIndex(writeBuffer, leafBlockFPs, splitValues, 0L, blocks, 1, lastSplitValue, false);
            byte[] index = new byte[totalSize];
            int upto = 0;
            for (byte[] block : blocks) {
                System.arraycopy(block, 0, index, upto, block.length);
                upto += block.length;
            }
            assert (upto == totalSize);
            Object object = index;
            return object;
        }
    }

    private int recursePackIndex(ResettableByteBuffersIndexOutput writeBuffer, long[] leafBlockFPs, byte[] splitValues, long minBlockFP, List<byte[]> blocks, int nodeID, byte[] lastSplitValue, boolean isLeft) throws IOException {
        int firstDiffByteDelta;
        int prefix;
        long leftBlockFP;
        if (nodeID >= leafBlockFPs.length) {
            int leafID = nodeID - leafBlockFPs.length;
            if (leafID < leafBlockFPs.length) {
                long delta = leafBlockFPs[leafID] - minBlockFP;
                if (isLeft) {
                    assert (delta == 0L);
                    return 0;
                }
                assert (nodeID == 1 || delta > 0L) : "nodeID=" + nodeID;
                writeBuffer.writeVLong(delta);
                return this.appendBlock(writeBuffer, blocks);
            }
            throw new IllegalStateException("Unbalanced tree");
        }
        if (!isLeft) {
            leftBlockFP = this.getLeftMostLeafBlockFP(leafBlockFPs, nodeID);
            long delta = leftBlockFP - minBlockFP;
            assert (nodeID == 1 || delta > 0L);
            writeBuffer.writeVLong(delta);
        } else {
            leftBlockFP = minBlockFP;
        }
        int address = nodeID * this.bytesPerValue;
        for (prefix = 0; prefix < this.bytesPerValue && splitValues[address + prefix] == lastSplitValue[prefix]; ++prefix) {
        }
        if (prefix < this.bytesPerValue) {
            firstDiffByteDelta = (splitValues[address + prefix] & 0xFF) - (lastSplitValue[prefix] & 0xFF);
            if (isLeft) {
                firstDiffByteDelta = -firstDiffByteDelta;
            }
            assert (firstDiffByteDelta > 0);
        } else {
            firstDiffByteDelta = 0;
        }
        int code = firstDiffByteDelta * (1 + this.bytesPerValue) + prefix;
        writeBuffer.writeVInt(code);
        int suffix = this.bytesPerValue - prefix;
        byte[] savSplitValue = new byte[suffix];
        if (suffix > 1) {
            writeBuffer.writeBytes(splitValues, address + prefix + 1, suffix - 1);
        }
        byte[] cmp = (byte[])lastSplitValue.clone();
        System.arraycopy(lastSplitValue, prefix, savSplitValue, 0, suffix);
        System.arraycopy(splitValues, address + prefix, lastSplitValue, prefix, suffix);
        int numBytes = this.appendBlock(writeBuffer, blocks);
        int idxSav = blocks.size();
        blocks.add(null);
        int leftNumBytes = this.recursePackIndex(writeBuffer, leafBlockFPs, splitValues, leftBlockFP, blocks, 2 * nodeID, lastSplitValue, true);
        if (nodeID * 2 < leafBlockFPs.length) {
            writeBuffer.writeVInt(leftNumBytes);
        } else assert (leftNumBytes == 0) : "leftNumBytes=" + leftNumBytes;
        int numBytes2 = Math.toIntExact(writeBuffer.getFilePointer());
        byte[] bytes2 = writeBuffer.toArrayCopy();
        writeBuffer.reset();
        blocks.set(idxSav, bytes2);
        int rightNumBytes = this.recursePackIndex(writeBuffer, leafBlockFPs, splitValues, leftBlockFP, blocks, 2 * nodeID + 1, lastSplitValue, false);
        System.arraycopy(savSplitValue, 0, lastSplitValue, prefix, suffix);
        assert (Arrays.equals(lastSplitValue, cmp));
        return numBytes + numBytes2 + leftNumBytes + rightNumBytes;
    }

    private int appendBlock(ResettableByteBuffersIndexOutput writeBuffer, List<byte[]> blocks) {
        int pos = Math.toIntExact(writeBuffer.getFilePointer());
        byte[] bytes = writeBuffer.toArrayCopy();
        writeBuffer.reset();
        blocks.add(bytes);
        return pos;
    }

    private long getLeftMostLeafBlockFP(long[] leafBlockFPs, int nodeID) {
        while (nodeID < leafBlockFPs.length) {
            nodeID *= 2;
        }
        int leafID = nodeID - leafBlockFPs.length;
        long result = leafBlockFPs[leafID];
        if (result < 0L) {
            throw new AssertionError((Object)(result + " for leaf " + leafID));
        }
        return result;
    }

    private class LeafWriter {
        private final IndexOutput treeOutput;
        private final List<Long> leafBlockFilePointers = new ArrayList<Long>();
        private final List<byte[]> leafBlockStartValues = new ArrayList<byte[]>();
        private final byte[] leafValues;
        private final long[] leafRowIDs;
        private final RowIDAndIndex[] rowIDAndIndexes;
        private final int[] orderIndex;
        private final Callback callback;
        private final ByteBuffersDataOutput leafOrderIndexOutput;
        private final ByteBuffersDataOutput leafBlockOutput;
        private final byte[] packedValue;
        private final byte[] lastPackedValue;
        private long valueCount;
        private int leafValueCount;
        private long lastRowID;

        LeafWriter(IndexOutput treeOutput, Callback callback) {
            this.leafValues = new byte[BlockBalancedTreeWriter.this.maxPointsInLeafNode * BlockBalancedTreeWriter.this.bytesPerValue];
            this.leafRowIDs = new long[BlockBalancedTreeWriter.this.maxPointsInLeafNode];
            this.rowIDAndIndexes = new RowIDAndIndex[BlockBalancedTreeWriter.this.maxPointsInLeafNode];
            this.orderIndex = new int[BlockBalancedTreeWriter.this.maxPointsInLeafNode];
            this.leafOrderIndexOutput = new ByteBuffersDataOutput(2048L);
            this.leafBlockOutput = new ByteBuffersDataOutput(32768L);
            this.packedValue = new byte[BlockBalancedTreeWriter.this.bytesPerValue];
            this.lastPackedValue = new byte[BlockBalancedTreeWriter.this.bytesPerValue];
            assert (callback != null) : "Callback cannot be null in TreeWriter";
            this.treeOutput = treeOutput;
            this.callback = callback;
            for (int x = 0; x < this.rowIDAndIndexes.length; ++x) {
                this.rowIDAndIndexes[x] = new RowIDAndIndex();
            }
        }

        void add(ByteComparable value, long rowID) throws IOException {
            ByteSourceInverse.copyBytes(value.asComparableBytes(ByteComparable.Version.OSS50), this.packedValue);
            if (DEBUG) {
                this.valueInOrder(this.valueCount + (long)this.leafValueCount, this.lastPackedValue, this.packedValue, 0, rowID, this.lastRowID);
            }
            System.arraycopy(this.packedValue, 0, this.leafValues, this.leafValueCount * BlockBalancedTreeWriter.this.bytesPerValue, BlockBalancedTreeWriter.this.bytesPerValue);
            this.leafRowIDs[this.leafValueCount] = rowID;
            ++this.leafValueCount;
            if (this.leafValueCount == BlockBalancedTreeWriter.this.maxPointsInLeafNode) {
                this.writeLeafBlock();
                this.leafValueCount = 0;
            }
            if (DEBUG && (this.lastRowID = rowID) < 0L) {
                throw new AssertionError((Object)("row id must be >= 0; got " + rowID));
            }
        }

        public long finish() throws IOException {
            if (this.leafValueCount > 0) {
                this.writeLeafBlock();
            }
            return this.valueCount;
        }

        private void writeLeafBlock() throws IOException {
            assert (this.leafValueCount != 0);
            if (this.valueCount == 0L) {
                System.arraycopy(this.leafValues, 0, BlockBalancedTreeWriter.this.minPackedValue, 0, BlockBalancedTreeWriter.this.bytesPerValue);
            }
            System.arraycopy(this.leafValues, (this.leafValueCount - 1) * BlockBalancedTreeWriter.this.bytesPerValue, BlockBalancedTreeWriter.this.maxPackedValue, 0, BlockBalancedTreeWriter.this.bytesPerValue);
            this.valueCount += (long)this.leafValueCount;
            if (this.leafBlockFilePointers.size() > 0) {
                this.leafBlockStartValues.add(ArrayUtil.copyOfSubArray((byte[])this.leafValues, (int)0, (int)BlockBalancedTreeWriter.this.bytesPerValue));
            }
            this.leafBlockFilePointers.add(this.treeOutput.getFilePointer());
            this.checkMaxLeafNodeCount(this.leafBlockFilePointers.size());
            int commonPrefixLength = BlockBalancedTreeWriter.this.bytesPerValue;
            int offset = (this.leafValueCount - 1) * BlockBalancedTreeWriter.this.bytesPerValue;
            for (int j = 0; j < BlockBalancedTreeWriter.this.bytesPerValue; ++j) {
                if (this.leafValues[j] == this.leafValues[offset + j]) continue;
                commonPrefixLength = j;
                break;
            }
            this.treeOutput.writeVInt(this.leafValueCount);
            for (int x = 0; x < this.leafValueCount; ++x) {
                this.rowIDAndIndexes[x].valueOrderIndex = x;
                this.rowIDAndIndexes[x].rowID = this.leafRowIDs[x];
            }
            IntroSorter sorter = new IntroSorter(){
                RowIDAndIndex pivot;

                protected void swap(int i, int j) {
                    RowIDAndIndex o = LeafWriter.this.rowIDAndIndexes[i];
                    LeafWriter.this.rowIDAndIndexes[i] = LeafWriter.this.rowIDAndIndexes[j];
                    LeafWriter.this.rowIDAndIndexes[j] = o;
                }

                protected void setPivot(int i) {
                    this.pivot = LeafWriter.this.rowIDAndIndexes[i];
                }

                protected int comparePivot(int j) {
                    return Long.compare(this.pivot.rowID, LeafWriter.this.rowIDAndIndexes[j].rowID);
                }
            };
            sorter.sort(0, this.leafValueCount);
            this.leafOrderIndexOutput.reset();
            for (int x = 0; x < this.leafValueCount; ++x) {
                this.orderIndex[this.rowIDAndIndexes[x].valueOrderIndex] = x;
            }
            LeafOrderMap.write(this.orderIndex, this.leafValueCount, BlockBalancedTreeWriter.this.maxPointsInLeafNode - 1, (DataOutput)this.leafOrderIndexOutput);
            this.treeOutput.writeVInt((int)this.leafOrderIndexOutput.size());
            this.leafOrderIndexOutput.copyTo((DataOutput)this.treeOutput);
            this.callback.writeLeafPostings(this.rowIDAndIndexes, 0, this.leafValueCount);
            this.writeCommonPrefix((DataOutput)this.treeOutput, commonPrefixLength);
            this.leafBlockOutput.reset();
            if (DEBUG) {
                this.valuesInOrderAndBounds(this.leafValueCount, ArrayUtil.copyOfSubArray((byte[])this.leafValues, (int)0, (int)BlockBalancedTreeWriter.this.bytesPerValue), ArrayUtil.copyOfSubArray((byte[])this.leafValues, (int)((this.leafValueCount - 1) * BlockBalancedTreeWriter.this.bytesPerValue), (int)(this.leafValueCount * BlockBalancedTreeWriter.this.bytesPerValue)), this.leafRowIDs);
            }
            this.writeLeafBlockPackedValues((DataOutput)this.leafBlockOutput, commonPrefixLength, this.leafValueCount);
            this.leafBlockOutput.copyTo((DataOutput)this.treeOutput);
        }

        private void checkMaxLeafNodeCount(int numLeaves) {
            if ((long)BlockBalancedTreeWriter.this.bytesPerValue * (long)numLeaves > (long)ArrayUtil.MAX_ARRAY_LENGTH) {
                throw new IllegalStateException("too many nodes; increase maxPointsInLeafNode (currently " + BlockBalancedTreeWriter.this.maxPointsInLeafNode + ") and reindex");
            }
        }

        private void writeCommonPrefix(DataOutput treeOutput, int commonPrefixLength) throws IOException {
            treeOutput.writeVInt(commonPrefixLength);
            if (commonPrefixLength > 0) {
                treeOutput.writeBytes(this.leafValues, 0, commonPrefixLength);
            }
        }

        private void writeLeafBlockPackedValues(DataOutput out, int commonPrefixLength, int count) throws IOException {
            if (commonPrefixLength != BlockBalancedTreeWriter.this.bytesPerValue) {
                int compressedByteOffset = commonPrefixLength++;
                int i = 0;
                while (i < count) {
                    int runLen = this.runLen(i, Math.min(i + 255, count), compressedByteOffset);
                    assert (runLen <= 255);
                    byte prefixByte = this.leafValues[i * BlockBalancedTreeWriter.this.bytesPerValue + compressedByteOffset];
                    out.writeByte(prefixByte);
                    out.writeByte((byte)runLen);
                    this.writeLeafBlockPackedValuesRange(out, commonPrefixLength, i, i + runLen);
                    assert ((i += runLen) <= count);
                }
            }
        }

        private void writeLeafBlockPackedValuesRange(DataOutput out, int commonPrefixLength, int start, int end) throws IOException {
            for (int i = start; i < end; ++i) {
                out.writeBytes(this.leafValues, i * BlockBalancedTreeWriter.this.bytesPerValue + commonPrefixLength, BlockBalancedTreeWriter.this.bytesPerValue - commonPrefixLength);
            }
        }

        private int runLen(int start, int end, int byteOffset) {
            byte b = this.leafValues[start * BlockBalancedTreeWriter.this.bytesPerValue + byteOffset];
            for (int i = start + 1; i < end; ++i) {
                byte b2 = this.leafValues[i * BlockBalancedTreeWriter.this.bytesPerValue + byteOffset];
                assert (Byte.toUnsignedInt(b2) >= Byte.toUnsignedInt(b));
                if (b == b2) continue;
                return i - start;
            }
            return end - start;
        }

        private void valueInBounds(byte[] packedValues, int packedValueOffset, byte[] minPackedValue, byte[] maxPackedValue) {
            if (ByteArrayUtil.compareUnsigned(packedValues, packedValueOffset, minPackedValue, 0, BlockBalancedTreeWriter.this.bytesPerValue) < 0) {
                throw new AssertionError((Object)("value=" + new BytesRef(packedValues, packedValueOffset, BlockBalancedTreeWriter.this.bytesPerValue) + " is < minPackedValue=" + new BytesRef(minPackedValue)));
            }
            if (ByteArrayUtil.compareUnsigned(packedValues, packedValueOffset, maxPackedValue, 0, BlockBalancedTreeWriter.this.bytesPerValue) > 0) {
                throw new AssertionError((Object)("value=" + new BytesRef(packedValues, packedValueOffset, BlockBalancedTreeWriter.this.bytesPerValue) + " is > maxPackedValue=" + new BytesRef(maxPackedValue)));
            }
        }

        private void valuesInOrderAndBounds(int count, byte[] minPackedValue, byte[] maxPackedValue, long[] rowIds) {
            byte[] lastPackedValue = new byte[BlockBalancedTreeWriter.this.bytesPerValue];
            long lastRowId = -1L;
            for (int i = 0; i < count; ++i) {
                this.valueInOrder(i, lastPackedValue, this.leafValues, i * BlockBalancedTreeWriter.this.bytesPerValue, rowIds[i], lastRowId);
                lastRowId = rowIds[i];
                this.valueInBounds(this.leafValues, i * BlockBalancedTreeWriter.this.bytesPerValue, minPackedValue, maxPackedValue);
            }
        }

        private void valueInOrder(long ord, byte[] lastPackedValue, byte[] packedValues, int packedValueOffset, long rowId, long lastRowId) {
            if (ord > 0L) {
                int cmp = ByteArrayUtil.compareUnsigned(lastPackedValue, 0, packedValues, packedValueOffset, BlockBalancedTreeWriter.this.bytesPerValue);
                if (cmp > 0) {
                    throw new AssertionError((Object)("values out of order: last value=" + new BytesRef(lastPackedValue) + " current value=" + new BytesRef(packedValues, packedValueOffset, BlockBalancedTreeWriter.this.bytesPerValue) + " ord=" + ord));
                }
                if (cmp == 0 && rowId < lastRowId) {
                    throw new AssertionError((Object)("row IDs out of order: last rowID=" + lastRowId + " current rowID=" + rowId + " ord=" + ord));
                }
            }
            System.arraycopy(packedValues, packedValueOffset, lastPackedValue, 0, BlockBalancedTreeWriter.this.bytesPerValue);
        }
    }

    static class RowIDAndIndex {
        public int valueOrderIndex;
        public long rowID;

        RowIDAndIndex() {
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("valueOrderIndex", this.valueOrderIndex).add("rowID", this.rowID).toString();
        }
    }

    static interface Callback {
        public void writeLeafPostings(RowIDAndIndex[] var1, int var2, int var3);
    }
}

