/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.gms.ApplicationState;
import org.apache.cassandra.gms.EndpointStateSerializer;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.gms.HeartBeatState;
import org.apache.cassandra.gms.VersionedValue;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.utils.CassandraVersion;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.NullableSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointState {
    protected static final Logger logger = LoggerFactory.getLogger(EndpointState.class);
    static volatile boolean LOOSE_DEF_OF_EMPTY_ENABLED = CassandraRelevantProperties.LOOSE_DEF_OF_EMPTY_ENABLED.getBoolean();
    public static final IVersionedSerializer<EndpointState> serializer = new EndpointStateSerializer();
    public static final IVersionedSerializer<EndpointState> nullableSerializer = NullableSerializer.wrap(serializer);
    private final AtomicReference<View> ref;
    private volatile long updateTimestamp;
    private volatile boolean isAlive;

    public EndpointState(HeartBeatState initialHbState) {
        this(initialHbState, new EnumMap<ApplicationState, VersionedValue>(ApplicationState.class));
    }

    public EndpointState(EndpointState other) {
        this.ref = new AtomicReference<View>(other.ref.get());
        this.updateTimestamp = Clock.Global.nanoTime();
        this.isAlive = true;
    }

    @VisibleForTesting
    public EndpointState(HeartBeatState initialHbState, Map<ApplicationState, VersionedValue> states) {
        this.ref = new AtomicReference<View>(new View(initialHbState, new EnumMap<ApplicationState, VersionedValue>(states)));
        this.updateTimestamp = Clock.Global.nanoTime();
        this.isAlive = true;
    }

    @VisibleForTesting
    public HeartBeatState getHeartBeatState() {
        return this.ref.get().hbState;
    }

    public void updateHeartBeat() {
        this.updateHeartBeat((Function<HeartBeatState, HeartBeatState>)((Function)HeartBeatState::updateHeartBeat));
    }

    public void forceNewerGenerationUnsafe() {
        this.updateHeartBeat((Function<HeartBeatState, HeartBeatState>)((Function)HeartBeatState::forceNewerGenerationUnsafe));
    }

    @VisibleForTesting
    public void forceHighestPossibleVersionUnsafe() {
        this.updateHeartBeat((Function<HeartBeatState, HeartBeatState>)((Function)HeartBeatState::forceHighestPossibleVersionUnsafe));
    }

    void unsafeSetEmptyHeartBeatState() {
        this.updateHeartBeat((Function<HeartBeatState, HeartBeatState>)((Function)ignore -> HeartBeatState.empty()));
    }

    private void updateHeartBeat(Function<HeartBeatState, HeartBeatState> fn) {
        HeartBeatState previous = null;
        HeartBeatState update = null;
        while (true) {
            View view = this.ref.get();
            if (previous == null || view.hbState != previous) {
                update = (HeartBeatState)fn.apply((Object)view.hbState);
            }
            if (this.ref.compareAndSet(view, new View(update, view.applicationState))) {
                return;
            }
            previous = view.hbState;
        }
    }

    public VersionedValue getApplicationState(ApplicationState key) {
        return this.ref.get().applicationState.get((Object)key);
    }

    public boolean containsApplicationState(ApplicationState key) {
        return this.ref.get().applicationState.containsKey((Object)key);
    }

    public Set<Map.Entry<ApplicationState, VersionedValue>> states() {
        return this.ref.get().applicationState.entrySet();
    }

    public void addApplicationState(ApplicationState key, VersionedValue value) {
        this.addApplicationStates(Collections.singletonMap(key, value));
    }

    public void addApplicationStates(Map<ApplicationState, VersionedValue> values) {
        this.addApplicationStates(values.entrySet());
    }

    public void addApplicationStates(Set<Map.Entry<ApplicationState, VersionedValue>> values) {
        this.addApplicationStates(values, null);
    }

    public void addApplicationStates(Set<Map.Entry<ApplicationState, VersionedValue>> values, @Nullable HeartBeatState hbState) {
        EnumMap<ApplicationState, VersionedValue> copy;
        View view;
        do {
            view = this.ref.get();
            Map<ApplicationState, VersionedValue> orig = view.applicationState;
            copy = new EnumMap<ApplicationState, VersionedValue>(orig);
            for (Map.Entry<ApplicationState, VersionedValue> value : values) {
                copy.put(value.getKey(), value.getValue());
            }
        } while (!this.ref.compareAndSet(view, new View(hbState == null ? view.hbState : hbState, copy)));
        if (hbState != null) {
            this.updateTimestamp();
        }
    }

    void removeMajorVersion3LegacyApplicationStates() {
        while (this.hasLegacyFields()) {
            View view = this.ref.get();
            Map<ApplicationState, VersionedValue> orig = view.applicationState;
            Map<ApplicationState, VersionedValue> updatedStates = EndpointState.filterMajorVersion3LegacyApplicationStates(orig);
            if (orig.size() != updatedStates.size() && !this.ref.compareAndSet(view, new View(view.hbState, updatedStates))) continue;
            return;
        }
    }

    private boolean hasLegacyFields() {
        Set<ApplicationState> statesPresent = this.ref.get().applicationState.keySet();
        if (statesPresent.isEmpty()) {
            return false;
        }
        return statesPresent.contains((Object)ApplicationState.STATUS) && statesPresent.contains((Object)ApplicationState.STATUS_WITH_PORT) || statesPresent.contains((Object)ApplicationState.INTERNAL_IP) && statesPresent.contains((Object)ApplicationState.INTERNAL_ADDRESS_AND_PORT) || statesPresent.contains((Object)ApplicationState.RPC_ADDRESS) && statesPresent.contains((Object)ApplicationState.NATIVE_ADDRESS_AND_PORT);
    }

    private static Map<ApplicationState, VersionedValue> filterMajorVersion3LegacyApplicationStates(Map<ApplicationState, VersionedValue> states) {
        return states.entrySet().stream().filter(entry -> {
            switch ((ApplicationState)((Object)((Object)entry.getKey()))) {
                case INTERNAL_IP: {
                    return !states.containsKey((Object)ApplicationState.INTERNAL_ADDRESS_AND_PORT);
                }
                case STATUS: {
                    return !states.containsKey((Object)ApplicationState.STATUS_WITH_PORT);
                }
                case RPC_ADDRESS: {
                    return !states.containsKey((Object)ApplicationState.NATIVE_ADDRESS_AND_PORT);
                }
            }
            return true;
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public long getUpdateTimestamp() {
        return this.updateTimestamp;
    }

    void updateTimestamp() {
        this.updateTimestamp = Clock.Global.nanoTime();
    }

    @VisibleForTesting
    public void unsafeSetUpdateTimestamp(long value) {
        this.updateTimestamp = value;
    }

    public boolean isAlive() {
        return this.isAlive;
    }

    @VisibleForTesting
    public void markAlive() {
        this.isAlive = true;
    }

    @VisibleForTesting
    public void markDead() {
        this.isAlive = false;
    }

    public boolean isStateEmpty() {
        return this.ref.get().applicationState.isEmpty();
    }

    public boolean isEmptyWithoutStatus() {
        View view = this.ref.get();
        Map<ApplicationState, VersionedValue> state = view.applicationState;
        boolean hasStatus = state.containsKey((Object)ApplicationState.STATUS_WITH_PORT) || state.containsKey((Object)ApplicationState.STATUS);
        return view.hbState.isEmpty() && !hasStatus || LOOSE_DEF_OF_EMPTY_ENABLED && !hasStatus;
    }

    public boolean isRpcReady() {
        VersionedValue rpcState = this.getApplicationState(ApplicationState.RPC_READY);
        return rpcState != null && Boolean.parseBoolean(rpcState.value);
    }

    public boolean isNormalState() {
        return this.getStatus().equals("NORMAL");
    }

    public String getStatus() {
        VersionedValue status = this.getApplicationState(ApplicationState.STATUS_WITH_PORT);
        if (status == null) {
            status = this.getApplicationState(ApplicationState.STATUS);
        }
        if (status == null) {
            return "";
        }
        String[] pieces = status.value.split(VersionedValue.DELIMITER_STR, -1);
        assert (pieces.length > 0);
        return pieces[0];
    }

    @Nullable
    public UUID getSchemaVersion() {
        VersionedValue applicationState = this.getApplicationState(ApplicationState.SCHEMA);
        return applicationState != null ? UUID.fromString(applicationState.value) : null;
    }

    @Nullable
    public CassandraVersion getReleaseVersion() {
        VersionedValue applicationState = this.getApplicationState(ApplicationState.RELEASE_VERSION);
        return applicationState != null ? new CassandraVersion(applicationState.value) : null;
    }

    public String toString() {
        View view = this.ref.get();
        return "EndpointState: HeartBeatState = " + view.hbState + ", AppStateMap = " + view.applicationState;
    }

    public boolean isSupersededBy(EndpointState that) {
        int thisGeneration = this.getHeartBeatState().getGeneration();
        int thatGeneration = that.getHeartBeatState().getGeneration();
        if (thatGeneration > thisGeneration) {
            return true;
        }
        if (thisGeneration > thatGeneration) {
            return false;
        }
        return Gossiper.getMaxEndpointStateVersion(that) > Gossiper.getMaxEndpointStateVersion(this);
    }

    private static class View {
        final HeartBeatState hbState;
        final Map<ApplicationState, VersionedValue> applicationState;

        private View(HeartBeatState hbState, Map<ApplicationState, VersionedValue> applicationState) {
            this.hbState = hbState;
            this.applicationState = applicationState;
        }
    }
}

