/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.generate.values;

import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.stress.generate.values.Generator;
import org.apache.cassandra.stress.generate.values.GeneratorConfig;

public class HexStrings
extends Generator<String> {
    private final char[] chars;

    public HexStrings(String name, GeneratorConfig config) {
        super((AbstractType<?>)UTF8Type.instance, config, name, String.class);
        this.chars = new char[(int)this.sizeDistribution.maxValue()];
    }

    @Override
    public String generate() {
        long seed = this.identityDistribution.next();
        this.sizeDistribution.setSeed(seed);
        int size = (int)this.sizeDistribution.next();
        for (int i = 0; i < size; i += 16) {
            long value = this.identityDistribution.next();
            for (int j = 0; j < 16 && i + j < size; ++j) {
                int v = (int)(value & 0xFL);
                this.chars[i + j] = (char)((v < 10 ? 48 : 65) + v);
                value >>>= 4;
            }
        }
        return new String(this.chars, 0, size);
    }
}

