/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.event;

import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ExcludeIterator<T>
implements Iterator<T> {
    private static final Comparator NATURAL = new NaturalComaprator();
    private final Iterator<T> a;
    private final Iterator<T> b;
    private final Comparator<T> comparator;
    private T peekA;
    private T peekB;

    public static <T> Iterator<T> exclude(Iterator<T> a, Iterator<T> b) {
        return ExcludeIterator.exclude(a, b, NATURAL);
    }

    public static <T> Iterator<T> exclude(Iterator<T> a, Iterator<T> b, Comparator<T> cmp) {
        return new ExcludeIterator<T>(a, b, cmp);
    }

    public static <T> Iterable<T> exclude(Iterable<T> a, Iterable<T> b) {
        return ExcludeIterator.exclude(a, b, NATURAL);
    }

    public static <T> Iterable<T> exclude(final Iterable<T> a, final Iterable<T> b, final Comparator<T> cmp) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return ExcludeIterator.exclude(a.iterator(), b.iterator(), cmp);
            }
        };
    }

    public ExcludeIterator(Iterator<T> a, Iterator<T> b, Comparator<T> cmp) {
        this.a = a;
        this.b = b;
        this.comparator = cmp == null ? NATURAL : cmp;
        this.peekA = a.hasNext() ? this.next(a) : null;
        this.peekB = b.hasNext() ? this.next(b) : null;
        this.seek();
    }

    private T next(Iterator<T> it) {
        T v = it.next();
        if (v == null) {
            throw new NullPointerException("null element is not allowed");
        }
        return v;
    }

    private void seek() {
        while (this.peekA != null && this.peekB != null) {
            int c = this.comparator.compare(this.peekA, this.peekB);
            if (c > 0) {
                this.peekB = this.b.hasNext() ? this.b.next() : null;
                continue;
            }
            if (c != 0) break;
            this.peekA = this.a.hasNext() ? this.a.next() : null;
            this.peekB = this.b.hasNext() ? this.b.next() : null;
        }
    }

    @Override
    public boolean hasNext() {
        return this.peekA != null;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        T result = this.peekA;
        this.peekA = this.a.hasNext() ? this.a.next() : null;
        this.seek();
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private static class NaturalComaprator
    implements Comparator<Comparable<Object>> {
        private NaturalComaprator() {
        }

        @Override
        public int compare(Comparable<Object> o1, Comparable<Object> o2) {
            return o1.compareTo(o2);
        }
    }
}

