/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.grpc.ConnectivityState;
import io.grpc.InternalLogId;
import io.grpc.LoadBalancer;
import io.grpc.Status;
import io.grpc.SynchronizationContext;
import io.grpc.util.GracefulSwitchLoadBalancer;
import io.grpc.util.MultiChildLoadBalancer;
import io.grpc.xds.ClusterManagerLoadBalancerProvider;
import io.grpc.xds.XdsNameResolver;
import io.grpc.xds.client.XdsLogger;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

class ClusterManagerLoadBalancer
extends MultiChildLoadBalancer {
    @VisibleForTesting
    public static final int DELAYED_CHILD_DELETION_TIME_MINUTES = 15;
    protected final SynchronizationContext syncContext;
    private final ScheduledExecutorService timeService;
    private final XdsLogger logger;
    private LoadBalancer.ResolvedAddresses lastResolvedAddresses;

    ClusterManagerLoadBalancer(LoadBalancer.Helper helper) {
        super(helper);
        this.syncContext = (SynchronizationContext)Preconditions.checkNotNull((Object)helper.getSynchronizationContext(), (Object)"syncContext");
        this.timeService = (ScheduledExecutorService)Preconditions.checkNotNull((Object)helper.getScheduledExecutorService(), (Object)"timeService");
        this.logger = XdsLogger.withLogId(InternalLogId.allocate((String)"cluster_manager-lb", (String)helper.getAuthority()));
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Created", new Object[0]);
    }

    protected MultiChildLoadBalancer.ChildLbState createChildLbState(Object key) {
        return new ClusterManagerLbState(key, GracefulSwitchLoadBalancerFactory.INSTANCE);
    }

    protected Map<Object, LoadBalancer.ResolvedAddresses> createChildAddressesMap(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        this.lastResolvedAddresses = resolvedAddresses;
        ClusterManagerLoadBalancerProvider.ClusterManagerConfig config = (ClusterManagerLoadBalancerProvider.ClusterManagerConfig)resolvedAddresses.getLoadBalancingPolicyConfig();
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Received cluster_manager lb config: child names={0}", config.childPolicies.keySet());
        HashMap<Object, LoadBalancer.ResolvedAddresses> childAddresses = new HashMap<Object, LoadBalancer.ResolvedAddresses>();
        for (MultiChildLoadBalancer.ChildLbState childLbState : this.getChildLbStates()) {
            ClusterManagerLbState state = (ClusterManagerLbState)childLbState;
            if (config.childPolicies.containsKey(state.getKey())) {
                if (state.deletionTimer == null) continue;
                state.reactivateChild();
                continue;
            }
            if (state.deletionTimer == null) {
                state.deactivateChild();
            }
            if (!state.deletionTimer.isPending()) continue;
            childAddresses.put(state.getKey(), null);
        }
        for (Map.Entry entry : config.childPolicies.entrySet()) {
            LoadBalancer.ResolvedAddresses addresses = resolvedAddresses.toBuilder().setLoadBalancingPolicyConfig(entry.getValue()).build();
            childAddresses.put(entry.getKey(), addresses);
        }
        return childAddresses;
    }

    protected void updateOverallBalancingState() {
        ConnectivityState overallState = null;
        HashMap<Object, LoadBalancer.SubchannelPicker> childPickers = new HashMap<Object, LoadBalancer.SubchannelPicker>();
        for (MultiChildLoadBalancer.ChildLbState childLbState : this.getChildLbStates()) {
            if (((ClusterManagerLbState)childLbState).deletionTimer != null) continue;
            childPickers.put(childLbState.getKey(), childLbState.getCurrentPicker());
            overallState = ClusterManagerLoadBalancer.aggregateState(overallState, (ConnectivityState)childLbState.getCurrentState());
        }
        if (overallState != null) {
            this.getHelper().updateBalancingState(overallState, this.getSubchannelPicker(childPickers));
            this.currentConnectivityState = overallState;
        }
    }

    protected LoadBalancer.SubchannelPicker getSubchannelPicker(final Map<Object, LoadBalancer.SubchannelPicker> childPickers) {
        return new LoadBalancer.SubchannelPicker(){

            public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
                String clusterName = (String)args.getCallOptions().getOption(XdsNameResolver.CLUSTER_SELECTION_KEY);
                LoadBalancer.SubchannelPicker childPicker = (LoadBalancer.SubchannelPicker)childPickers.get(clusterName);
                if (childPicker == null) {
                    return LoadBalancer.PickResult.withError((Status)Status.UNAVAILABLE.withDescription("CDS encountered error: unable to find available subchannel for cluster " + clusterName));
                }
                return childPicker.pickSubchannel(args);
            }

            public String toString() {
                return MoreObjects.toStringHelper((Object)((Object)this)).add("pickers", (Object)childPickers).toString();
            }
        };
    }

    public void handleNameResolutionError(Status error) {
        this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Received name resolution error: {0}", error);
        boolean gotoTransientFailure = true;
        for (MultiChildLoadBalancer.ChildLbState state : this.getChildLbStates()) {
            if (((ClusterManagerLbState)state).deletionTimer != null) continue;
            gotoTransientFailure = false;
            state.getLb().handleNameResolutionError(error);
        }
        if (gotoTransientFailure) {
            this.getHelper().updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, (LoadBalancer.SubchannelPicker)new LoadBalancer.FixedResultPicker(LoadBalancer.PickResult.withError((Status)error)));
        }
    }

    static final class GracefulSwitchLoadBalancerFactory
    extends LoadBalancer.Factory {
        static final LoadBalancer.Factory INSTANCE = new GracefulSwitchLoadBalancerFactory();

        GracefulSwitchLoadBalancerFactory() {
        }

        public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
            return new GracefulSwitchLoadBalancer(helper);
        }
    }

    private class ClusterManagerLbState
    extends MultiChildLoadBalancer.ChildLbState {
        @Nullable
        SynchronizationContext.ScheduledHandle deletionTimer;

        public ClusterManagerLbState(Object key, LoadBalancer.Factory policyFactory) {
            super((MultiChildLoadBalancer)ClusterManagerLoadBalancer.this, key, policyFactory);
        }

        protected MultiChildLoadBalancer.ChildLbState.ChildLbStateHelper createChildHelper() {
            return new ClusterManagerChildHelper();
        }

        protected void shutdown() {
            if (this.deletionTimer != null) {
                this.deletionTimer.cancel();
                this.deletionTimer = null;
            }
            super.shutdown();
        }

        void reactivateChild() {
            assert (this.deletionTimer != null);
            this.deletionTimer.cancel();
            this.deletionTimer = null;
            ClusterManagerLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Child balancer {0} reactivated", this.getKey());
        }

        void deactivateChild() {
            assert (this.deletionTimer == null);
            class DeletionTask
            implements Runnable {
                DeletionTask() {
                }

                @Override
                public void run() {
                    ClusterManagerLoadBalancer.this.acceptResolvedAddresses(ClusterManagerLoadBalancer.this.lastResolvedAddresses);
                }
            }
            this.deletionTimer = ClusterManagerLoadBalancer.this.syncContext.schedule((Runnable)new DeletionTask(), 15L, TimeUnit.MINUTES, ClusterManagerLoadBalancer.this.timeService);
            ClusterManagerLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Child balancer {0} deactivated", this.getKey());
        }

        private class ClusterManagerChildHelper
        extends MultiChildLoadBalancer.ChildLbState.ChildLbStateHelper {
            private ClusterManagerChildHelper() {
                super((MultiChildLoadBalancer.ChildLbState)ClusterManagerLbState.this);
            }

            public void updateBalancingState(ConnectivityState newState, LoadBalancer.SubchannelPicker newPicker) {
                if (ClusterManagerLbState.this.getCurrentState() == ConnectivityState.SHUTDOWN) {
                    return;
                }
                ClusterManagerLbState.this.setCurrentState(newState);
                ClusterManagerLbState.this.setCurrentPicker(newPicker);
                if (ClusterManagerLbState.this.deletionTimer == null && !ClusterManagerLoadBalancer.this.resolvingAddresses) {
                    ClusterManagerLoadBalancer.this.updateOverallBalancingState();
                }
            }
        }
    }
}

