/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.common.util;

import com.google.common.util.concurrent.ForwardingExecutorService;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class BoundedExecutorService
extends ForwardingExecutorService {
    private final BlockingQueue<Runnable> queue;
    private final ThreadPoolExecutor thread;
    private final int maxTasksInQueue;

    public BoundedExecutorService(ThreadPoolExecutor thread, int maxTasksInQueue) {
        this.queue = thread.getQueue();
        this.thread = thread;
        this.maxTasksInQueue = maxTasksInQueue;
    }

    protected ExecutorService delegate() {
        return this.thread;
    }

    private void checkQueue(int numberOfTasks) {
        if (this.maxTasksInQueue > 0 && this.queue.size() + numberOfTasks > this.maxTasksInQueue) {
            throw new RejectedExecutionException("Queue at limit of " + this.maxTasksInQueue + " items");
        }
    }

    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        this.checkQueue(tasks.size());
        return super.invokeAll(tasks);
    }

    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        this.checkQueue(tasks.size());
        return super.invokeAll(tasks, timeout, unit);
    }

    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        this.checkQueue(tasks.size());
        return (T)super.invokeAny(tasks);
    }

    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.checkQueue(tasks.size());
        return (T)super.invokeAny(tasks, timeout, unit);
    }

    public void execute(Runnable command) {
        this.checkQueue(1);
        super.execute(command);
    }

    public <T> Future<T> submit(Callable<T> task) {
        this.checkQueue(1);
        return super.submit(task);
    }

    public Future<?> submit(Runnable task) {
        this.checkQueue(1);
        return super.submit(task);
    }

    public <T> Future<T> submit(Runnable task, T result) {
        this.checkQueue(1);
        return super.submit(task, result);
    }
}

