/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.HashMap;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.server.quorum.FLETestUtils;
import org.apache.zookeeper.server.quorum.FastLeaderElection;
import org.apache.zookeeper.server.quorum.QuorumCnxManager;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.test.ClientBase;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FLEMalformedNotificationMessageTest
extends ZKTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(FLEMalformedNotificationMessageTest.class);
    private static final byte[] CONFIG_BYTES = "my very invalid config string".getBytes();
    private static final int CONFIG_BYTES_LENGTH = CONFIG_BYTES.length;
    int count;
    HashMap<Long, QuorumPeer.QuorumServer> peers;
    File[] tmpdir;
    int[] port;
    QuorumCnxManager mockCnxManager;
    FLETestUtils.LEThread leaderElectionThread;
    QuorumPeer peerRunningLeaderElection;

    @BeforeEach
    public void setUp() throws Exception {
        this.count = 3;
        this.peers = new HashMap(this.count);
        this.tmpdir = new File[this.count];
        this.port = new int[this.count];
        LOG.info("FLEMalformedNotificationMessageTest: {}, {}", (Object)this.getTestName(), (Object)this.count);
        for (int i = 0; i < this.count; ++i) {
            int clientport = PortAssignment.unique();
            this.peers.put(Long.valueOf(i), new QuorumPeer.QuorumServer((long)i, new InetSocketAddress(clientport), new InetSocketAddress(PortAssignment.unique())));
            this.tmpdir[i] = ClientBase.createTmpDir();
            this.port[i] = clientport;
        }
        this.peerRunningLeaderElection = new QuorumPeer(this.peers, this.tmpdir[0], this.tmpdir[0], this.port[0], 3, 0L, 1000, 2, 2, 2);
        this.peerRunningLeaderElection.startLeaderElection();
        this.leaderElectionThread = new FLETestUtils.LEThread(this.peerRunningLeaderElection, 0);
        this.leaderElectionThread.start();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.peerRunningLeaderElection.shutdown();
        this.mockCnxManager.halt();
    }

    @Test
    public void testTooShortPartialNotificationMessage() throws Exception {
        this.startMockServer(1);
        byte[] requestBytes = new byte[12];
        ByteBuffer requestBuffer = ByteBuffer.wrap(requestBytes);
        requestBuffer.clear();
        requestBuffer.putInt(QuorumPeer.ServerState.LOOKING.ordinal());
        requestBuffer.putLong(0L);
        this.mockCnxManager.toSend(Long.valueOf(0L), requestBuffer);
        this.sendValidNotifications(1, 0);
        this.leaderElectionThread.join(5000L);
        if (this.leaderElectionThread.isAlive()) {
            Assertions.fail((String)"Leader election thread didn't join, something went wrong.");
        }
    }

    @Test
    public void testNotificationMessageWithNegativeConfigLength() throws Exception {
        this.startMockServer(1);
        byte[] requestBytes = new byte[48];
        ByteBuffer requestBuffer = ByteBuffer.wrap(requestBytes);
        requestBuffer.clear();
        requestBuffer.putInt(QuorumPeer.ServerState.LOOKING.ordinal());
        requestBuffer.putLong(0L);
        requestBuffer.putLong(0L);
        requestBuffer.putLong(0L);
        requestBuffer.putLong(0L);
        requestBuffer.putInt(2);
        requestBuffer.putInt(-123);
        this.mockCnxManager.toSend(Long.valueOf(0L), requestBuffer);
        this.sendValidNotifications(1, 0);
        this.leaderElectionThread.join(5000L);
        if (this.leaderElectionThread.isAlive()) {
            Assertions.fail((String)"Leader election thread didn't join, something went wrong.");
        }
    }

    @Test
    public void testNotificationMessageWithInvalidConfigLength() throws Exception {
        this.startMockServer(1);
        byte[] requestBytes = new byte[48 + CONFIG_BYTES_LENGTH];
        ByteBuffer requestBuffer = ByteBuffer.wrap(requestBytes);
        requestBuffer.clear();
        requestBuffer.putInt(QuorumPeer.ServerState.LOOKING.ordinal());
        requestBuffer.putLong(0L);
        requestBuffer.putLong(0L);
        requestBuffer.putLong(0L);
        requestBuffer.putLong(0L);
        requestBuffer.putInt(2);
        requestBuffer.putInt(10000);
        requestBuffer.put(CONFIG_BYTES);
        this.mockCnxManager.toSend(Long.valueOf(0L), requestBuffer);
        this.sendValidNotifications(1, 0);
        this.leaderElectionThread.join(5000L);
        if (this.leaderElectionThread.isAlive()) {
            Assertions.fail((String)"Leader election thread didn't join, something went wrong.");
        }
    }

    @Test
    public void testNotificationMessageWithInvalidConfig() throws Exception {
        this.startMockServer(1);
        ByteBuffer requestBuffer = FastLeaderElection.buildMsg((int)QuorumPeer.ServerState.LOOKING.ordinal(), (long)1L, (long)0L, (long)0L, (long)0L, (byte[])CONFIG_BYTES);
        this.mockCnxManager.toSend(Long.valueOf(0L), requestBuffer);
        this.sendValidNotifications(1, 0);
        this.leaderElectionThread.join(5000L);
        if (this.leaderElectionThread.isAlive()) {
            Assertions.fail((String)"Leader election thread didn't join, something went wrong.");
        }
    }

    @Test
    public void testNotificationMessageWithBadProtocol() throws Exception {
        this.startMockServer(1);
        byte[] requestBytes = new byte[30];
        ByteBuffer requestBuffer = ByteBuffer.wrap(requestBytes);
        requestBuffer.clear();
        requestBuffer.putInt(QuorumPeer.ServerState.LOOKING.ordinal());
        requestBuffer.putLong(1L);
        requestBuffer.putLong(0L);
        requestBuffer.putLong(0L);
        requestBuffer.putShort((short)0);
        this.mockCnxManager.toSend(Long.valueOf(0L), requestBuffer);
        this.sendValidNotifications(1, 0);
        this.leaderElectionThread.join(5000L);
        if (this.leaderElectionThread.isAlive()) {
            Assertions.fail((String)"Leader election thread didn't join, something went wrong.");
        }
    }

    void startMockServer(int sid) throws IOException {
        QuorumPeer peer = new QuorumPeer(this.peers, this.tmpdir[sid], this.tmpdir[sid], this.port[sid], 3, (long)sid, 1000, 2, 2, 2);
        this.mockCnxManager = peer.createCnxnManager();
        this.mockCnxManager.listener.start();
    }

    void sendValidNotifications(int fromSid, int toSid) throws InterruptedException {
        this.mockCnxManager.toSend(Long.valueOf(toSid), FLETestUtils.createMsg(QuorumPeer.ServerState.LOOKING.ordinal(), fromSid, 0L, 0L));
        this.mockCnxManager.recvQueue.take();
        this.mockCnxManager.toSend(Long.valueOf(toSid), FLETestUtils.createMsg(QuorumPeer.ServerState.FOLLOWING.ordinal(), toSid, 0L, 0L));
    }
}

