/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.File;
import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.test.ClientBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class ZookeeperServerSnapshotTest
extends ZKTestCase {
    private static final String BASE_PATH = "/takeSnapshotTest";
    private static final int NODE_COUNT = 10;
    private static final String HOST_PORT = "127.0.0.1:" + PortAssignment.unique();
    @TempDir
    static File dataDir;
    @TempDir
    static File logDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTakeSnapshot() throws Exception {
        ZooKeeperServer zks = new ZooKeeperServer(dataDir, logDir, 3000);
        ZooKeeperServer.setSerializeLastProcessedZxidEnabled((boolean)true);
        int port = Integer.parseInt(HOST_PORT.split(":")[1]);
        ServerCnxnFactory serverCnxnFactory = ServerCnxnFactory.createFactory((int)port, (int)-1);
        ZooKeeper zk = null;
        try {
            String path;
            int i;
            serverCnxnFactory.startup(zks);
            Assertions.assertTrue((boolean)ClientBase.waitForServerUp(HOST_PORT, ClientBase.CONNECTION_TIMEOUT));
            zk = ClientBase.createZKClient(HOST_PORT);
            for (i = 0; i < 10; ++i) {
                path = "/takeSnapshotTest-" + i;
                zk.create(path, String.valueOf(i).getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
            zks.takeSnapshot(false, false, true);
            zk.close();
            zks.shutdown();
            zks = new ZooKeeperServer(dataDir, logDir, 3000);
            ZooKeeperServer.setSerializeLastProcessedZxidEnabled((boolean)false);
            serverCnxnFactory.startup(zks);
            Assertions.assertTrue((boolean)ClientBase.waitForServerUp(HOST_PORT, ClientBase.CONNECTION_TIMEOUT));
            zk = ClientBase.createZKClient(HOST_PORT);
            for (i = 0; i < 10; ++i) {
                path = "/takeSnapshotTest-" + i;
                String expectedData = String.valueOf(i);
                Assertions.assertArrayEquals((byte[])expectedData.getBytes(), (byte[])zk.getData(path, null, null));
            }
            Assertions.assertEquals((int)13, (int)zk.getAllChildrenNumber("/"));
        }
        finally {
            if (zk != null) {
                zk.close();
            }
            zks.shutdown();
            serverCnxnFactory.shutdown();
        }
    }
}

