/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.proto;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.ExtensionRegistry;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.AdaptiveRecvByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.DefaultEventLoop;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.local.LocalServerChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.flush.FlushConsolidationHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.incubator.channel.uring.IOUringEventLoopGroup;
import io.netty.incubator.channel.uring.IOUringServerSocketChannel;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.EventExecutor;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.bookkeeper.auth.AuthProviderFactoryFactory;
import org.apache.bookkeeper.auth.BookKeeperPrincipal;
import org.apache.bookkeeper.auth.BookieAuthProvider;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.bookie.BookieImpl;
import org.apache.bookkeeper.common.collections.BlockingMpscQueue;
import org.apache.bookkeeper.common.util.affinity.CpuAffinity;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.processor.RequestProcessor;
import org.apache.bookkeeper.proto.AuthHandler;
import org.apache.bookkeeper.proto.BookieConnectionPeer;
import org.apache.bookkeeper.proto.BookieProtoEncoding;
import org.apache.bookkeeper.proto.BookieRequestHandler;
import org.apache.bookkeeper.proto.LocalBookiesRegistry;
import org.apache.bookkeeper.stats.ThreadRegistry;
import org.apache.bookkeeper.util.ByteBufList;
import org.apache.bookkeeper.util.EventLoopUtil;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BookieNettyServer {
    private static final Logger LOG = LoggerFactory.getLogger(BookieNettyServer.class);
    public static final String CONSOLIDATION_HANDLER_NAME = "consolidation";
    final int maxFrameSize;
    final ServerConfiguration conf;
    final EventLoopGroup eventLoopGroup;
    final EventLoopGroup acceptorGroup;
    final EventLoopGroup jvmEventLoopGroup;
    RequestProcessor requestProcessor;
    final AtomicBoolean isRunning = new AtomicBoolean(false);
    final AtomicBoolean isClosed = new AtomicBoolean(false);
    final Object suspensionLock = new Object();
    volatile boolean suspended = false;
    ChannelGroup allChannels;
    final BookieSocketAddress bookieAddress;
    final BookieId bookieId;
    final InetSocketAddress bindAddress;
    final BookieAuthProvider.Factory authProviderFactory;
    final ExtensionRegistry registry = ExtensionRegistry.newInstance();
    private final ByteBufAllocator allocator;

    BookieNettyServer(final ServerConfiguration conf, RequestProcessor processor, ByteBufAllocator allocator) throws IOException, KeeperException, InterruptedException, BookieException {
        this.allocator = allocator;
        this.maxFrameSize = conf.getNettyMaxFrameSizeBytes();
        this.conf = conf;
        this.requestProcessor = processor;
        this.authProviderFactory = AuthProviderFactoryFactory.newBookieAuthProviderFactory(conf);
        if (!conf.isDisableServerSocketBind()) {
            this.eventLoopGroup = EventLoopUtil.getServerEventLoopGroup(conf, (ThreadFactory)new DefaultThreadFactory("bookie-io"){

                protected Thread newThread(Runnable r, String name) {
                    return super.newThread(ThreadRegistry.registerThread((Runnable)r, (String)"bookie-id"), name);
                }
            });
            this.acceptorGroup = EventLoopUtil.getServerAcceptorGroup(conf, (ThreadFactory)new DefaultThreadFactory("bookie-acceptor"));
            this.allChannels = new CleanupChannelGroup(this.eventLoopGroup);
        } else {
            this.eventLoopGroup = null;
            this.acceptorGroup = null;
        }
        if (conf.isEnableLocalTransport()) {
            this.jvmEventLoopGroup = new DefaultEventLoopGroup(conf.getServerNumIOThreads()){

                protected EventLoop newChild(Executor executor, Object ... args) throws Exception {
                    return new DefaultEventLoop((EventLoopGroup)this, executor){

                        protected Queue<Runnable> newTaskQueue(int maxPendingTasks) {
                            if (conf.isBusyWaitEnabled()) {
                                return new BlockingMpscQueue(Math.min(maxPendingTasks, 10000));
                            }
                            return super.newTaskQueue(maxPendingTasks);
                        }
                    };
                }
            };
            if (conf.isBusyWaitEnabled()) {
                for (int i = 0; i < conf.getServerNumIOThreads(); ++i) {
                    this.jvmEventLoopGroup.next().submit(() -> {
                        try {
                            CpuAffinity.acquireCore();
                        }
                        catch (Throwable t) {
                            LOG.warn("Failed to acquire CPU core for thread {} {}", new Object[]{Thread.currentThread().getName(), t.getMessage(), t});
                        }
                    });
                }
            }
            this.allChannels = new CleanupChannelGroup(this.jvmEventLoopGroup);
        } else {
            this.jvmEventLoopGroup = null;
        }
        this.bookieId = BookieImpl.getBookieId(conf);
        this.bookieAddress = BookieImpl.getBookieAddress(conf);
        this.bindAddress = conf.getListeningInterface() == null ? new InetSocketAddress(conf.getBookiePort()) : this.bookieAddress.getSocketAddress();
        this.listenOn(this.bindAddress, this.bookieAddress);
    }

    public BookieNettyServer setRequestProcessor(RequestProcessor processor) {
        this.requestProcessor = processor;
        return this;
    }

    boolean isRunning() {
        return this.isRunning.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void suspendProcessing() {
        Object object = this.suspensionLock;
        synchronized (object) {
            this.suspended = true;
            for (Channel channel : this.allChannels) {
                channel.eventLoop().submit(() -> {
                    while (this.suspended && this.isRunning()) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void resumeProcessing() {
        Object object = this.suspensionLock;
        synchronized (object) {
            this.suspended = false;
            for (Channel channel : this.allChannels) {
                channel.config().setAutoRead(true);
            }
            this.suspensionLock.notifyAll();
        }
    }

    private void listenOn(InetSocketAddress address, BookieSocketAddress bookieAddress) throws InterruptedException {
        if (!this.conf.isDisableServerSocketBind()) {
            ServerBootstrap bootstrap = new ServerBootstrap();
            bootstrap.option(ChannelOption.ALLOCATOR, (Object)this.allocator);
            bootstrap.childOption(ChannelOption.ALLOCATOR, (Object)this.allocator);
            bootstrap.group(this.acceptorGroup, this.eventLoopGroup);
            bootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)this.conf.getServerTcpNoDelay());
            bootstrap.childOption(ChannelOption.SO_LINGER, (Object)this.conf.getServerSockLinger());
            bootstrap.childOption(ChannelOption.RCVBUF_ALLOCATOR, (Object)new AdaptiveRecvByteBufAllocator(this.conf.getRecvByteBufAllocatorSizeMin(), this.conf.getRecvByteBufAllocatorSizeInitial(), this.conf.getRecvByteBufAllocatorSizeMax()));
            bootstrap.option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(this.conf.getServerWriteBufferLowWaterMark(), this.conf.getServerWriteBufferHighWaterMark()));
            if (this.eventLoopGroup instanceof IOUringEventLoopGroup) {
                bootstrap.channel(IOUringServerSocketChannel.class);
            } else if (this.eventLoopGroup instanceof EpollEventLoopGroup) {
                bootstrap.channel(EpollServerSocketChannel.class);
            } else {
                bootstrap.channel(NioServerSocketChannel.class);
            }
            bootstrap.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void initChannel(SocketChannel ch) throws Exception {
                    Object object = BookieNettyServer.this.suspensionLock;
                    synchronized (object) {
                        while (BookieNettyServer.this.suspended) {
                            BookieNettyServer.this.suspensionLock.wait();
                        }
                    }
                    BookieSideConnectionPeerContextHandler contextHandler = new BookieSideConnectionPeerContextHandler();
                    ChannelPipeline pipeline = ch.pipeline();
                    pipeline.addLast(BookieNettyServer.CONSOLIDATION_HANDLER_NAME, (ChannelHandler)new FlushConsolidationHandler(1024, true));
                    pipeline.addLast("bytebufList", (ChannelHandler)ByteBufList.ENCODER);
                    pipeline.addLast("lengthbaseddecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(BookieNettyServer.this.maxFrameSize, 0, 4, 0, 4));
                    pipeline.addLast("bookieProtoDecoder", (ChannelHandler)new BookieProtoEncoding.RequestDecoder(BookieNettyServer.this.registry));
                    pipeline.addLast("bookieProtoEncoder", (ChannelHandler)new BookieProtoEncoding.ResponseEncoder(BookieNettyServer.this.registry));
                    pipeline.addLast("bookieAuthHandler", (ChannelHandler)new AuthHandler.ServerSideHandler(contextHandler.getConnectionPeer(), BookieNettyServer.this.authProviderFactory));
                    ChannelInboundHandlerAdapter requestHandler = BookieNettyServer.this.isRunning.get() ? new BookieRequestHandler(BookieNettyServer.this.conf, BookieNettyServer.this.requestProcessor, BookieNettyServer.this.allChannels) : new RejectRequestHandler();
                    pipeline.addLast("bookieRequestHandler", (ChannelHandler)requestHandler);
                    pipeline.addLast("contextHandler", (ChannelHandler)contextHandler);
                }
            });
            LOG.info("Binding bookie-rpc endpoint to {}", (Object)address);
            Channel listen = bootstrap.bind(address.getAddress(), address.getPort()).sync().channel();
            if (listen.localAddress() instanceof InetSocketAddress && this.conf.getBookiePort() == 0) {
                this.conf.setBookiePort(((InetSocketAddress)listen.localAddress()).getPort());
            }
        }
        if (this.conf.isEnableLocalTransport()) {
            ServerBootstrap jvmBootstrap = new ServerBootstrap();
            jvmBootstrap.childOption(ChannelOption.ALLOCATOR, (Object)new PooledByteBufAllocator(true));
            jvmBootstrap.group(this.jvmEventLoopGroup, this.jvmEventLoopGroup);
            jvmBootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)this.conf.getServerTcpNoDelay());
            jvmBootstrap.childOption(ChannelOption.SO_KEEPALIVE, (Object)this.conf.getServerSockKeepalive());
            jvmBootstrap.childOption(ChannelOption.SO_LINGER, (Object)this.conf.getServerSockLinger());
            jvmBootstrap.childOption(ChannelOption.RCVBUF_ALLOCATOR, (Object)new AdaptiveRecvByteBufAllocator(this.conf.getRecvByteBufAllocatorSizeMin(), this.conf.getRecvByteBufAllocatorSizeInitial(), this.conf.getRecvByteBufAllocatorSizeMax()));
            jvmBootstrap.option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(this.conf.getServerWriteBufferLowWaterMark(), this.conf.getServerWriteBufferHighWaterMark()));
            if (this.jvmEventLoopGroup instanceof DefaultEventLoopGroup) {
                jvmBootstrap.channel(LocalServerChannel.class);
            } else if (this.jvmEventLoopGroup instanceof IOUringEventLoopGroup) {
                jvmBootstrap.channel(IOUringServerSocketChannel.class);
            } else if (this.jvmEventLoopGroup instanceof EpollEventLoopGroup) {
                jvmBootstrap.channel(EpollServerSocketChannel.class);
            } else {
                jvmBootstrap.channel(NioServerSocketChannel.class);
            }
            jvmBootstrap.childHandler((ChannelHandler)new ChannelInitializer<LocalChannel>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void initChannel(LocalChannel ch) throws Exception {
                    Object object = BookieNettyServer.this.suspensionLock;
                    synchronized (object) {
                        while (BookieNettyServer.this.suspended) {
                            BookieNettyServer.this.suspensionLock.wait();
                        }
                    }
                    BookieSideConnectionPeerContextHandler contextHandler = new BookieSideConnectionPeerContextHandler();
                    ChannelPipeline pipeline = ch.pipeline();
                    pipeline.addLast("lengthbaseddecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(BookieNettyServer.this.maxFrameSize, 0, 4, 0, 4));
                    pipeline.addLast("bookieProtoDecoder", (ChannelHandler)new BookieProtoEncoding.RequestDecoder(BookieNettyServer.this.registry));
                    pipeline.addLast("bookieProtoEncoder", (ChannelHandler)new BookieProtoEncoding.ResponseEncoder(BookieNettyServer.this.registry));
                    pipeline.addLast("bookieAuthHandler", (ChannelHandler)new AuthHandler.ServerSideHandler(contextHandler.getConnectionPeer(), BookieNettyServer.this.authProviderFactory));
                    ChannelInboundHandlerAdapter requestHandler = BookieNettyServer.this.isRunning.get() ? new BookieRequestHandler(BookieNettyServer.this.conf, BookieNettyServer.this.requestProcessor, BookieNettyServer.this.allChannels) : new RejectRequestHandler();
                    pipeline.addLast("bookieRequestHandler", (ChannelHandler)requestHandler);
                    pipeline.addLast("contextHandler", (ChannelHandler)contextHandler);
                }
            });
            LOG.info("Binding jvm bookie-rpc endpoint to {}", (Object)this.bookieId.toString());
            jvmBootstrap.bind((SocketAddress)new LocalAddress(this.bookieId.toString())).sync();
            LocalBookiesRegistry.registerLocalBookieAddress(this.bookieId);
        }
    }

    void start() throws InterruptedException {
        this.isRunning.set(true);
    }

    void shutdown() {
        LOG.info("Shutting down BookieNettyServer");
        this.isRunning.set(false);
        if (!this.isClosed.compareAndSet(false, true)) {
            return;
        }
        this.allChannels.close().awaitUninterruptibly();
        if (this.acceptorGroup != null) {
            try {
                this.acceptorGroup.shutdownGracefully(0L, 10L, TimeUnit.MILLISECONDS).await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (this.eventLoopGroup != null) {
            try {
                this.eventLoopGroup.shutdownGracefully(0L, 10L, TimeUnit.MILLISECONDS).await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (this.jvmEventLoopGroup != null) {
            LocalBookiesRegistry.unregisterLocalBookieAddress(this.bookieAddress.toBookieId());
            this.jvmEventLoopGroup.shutdownGracefully();
        }
        this.authProviderFactory.close();
    }

    private static class CleanupChannelGroup
    extends DefaultChannelGroup {
        private AtomicBoolean closed = new AtomicBoolean(false);

        public CleanupChannelGroup(EventLoopGroup eventLoopGroup) {
            super("BookieChannelGroup", (EventExecutor)eventLoopGroup.next());
        }

        public boolean add(Channel channel) {
            boolean ret = super.add(channel);
            if (this.closed.get()) {
                channel.close();
            }
            return ret;
        }

        public ChannelGroupFuture close() {
            this.closed.set(true);
            return super.close();
        }

        public boolean equals(Object o) {
            if (!(o instanceof CleanupChannelGroup)) {
                return false;
            }
            CleanupChannelGroup other = (CleanupChannelGroup)((Object)o);
            return other.closed.get() == this.closed.get() && super.equals((Object)other);
        }

        public int hashCode() {
            return super.hashCode() * 17 + (this.closed.get() ? 1 : 0);
        }
    }

    private static class RejectRequestHandler
    extends ChannelInboundHandlerAdapter {
        private RejectRequestHandler() {
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            ctx.channel().close();
        }
    }

    class BookieSideConnectionPeerContextHandler
    extends ChannelInboundHandlerAdapter {
        final BookieConnectionPeer connectionPeer;
        volatile Channel channel;
        volatile BookKeeperPrincipal authorizedId = BookKeeperPrincipal.ANONYMOUS;

        public BookieSideConnectionPeerContextHandler() {
            this.connectionPeer = new BookieConnectionPeer(){

                @Override
                public SocketAddress getRemoteAddr() {
                    Channel c = BookieSideConnectionPeerContextHandler.this.channel;
                    if (c != null) {
                        return c.remoteAddress();
                    }
                    return null;
                }

                @Override
                public Collection<Object> getProtocolPrincipals() {
                    Channel c = BookieSideConnectionPeerContextHandler.this.channel;
                    if (c == null) {
                        return Collections.emptyList();
                    }
                    SslHandler ssl = (SslHandler)c.pipeline().get(SslHandler.class);
                    if (ssl == null) {
                        return Collections.emptyList();
                    }
                    try {
                        Certificate[] certificates = ssl.engine().getSession().getPeerCertificates();
                        if (certificates == null) {
                            return Collections.emptyList();
                        }
                        ArrayList<Object> result = new ArrayList<Object>();
                        result.addAll(Arrays.asList(certificates));
                        return result;
                    }
                    catch (SSLPeerUnverifiedException err) {
                        LOG.error("Failed to get peer certificates", (Throwable)err);
                        return Collections.emptyList();
                    }
                }

                @Override
                public void disconnect() {
                    Channel c = BookieSideConnectionPeerContextHandler.this.channel;
                    if (c != null) {
                        c.close();
                    }
                    LOG.info("authplugin disconnected channel {}", (Object)BookieSideConnectionPeerContextHandler.this.channel);
                }

                @Override
                public BookKeeperPrincipal getAuthorizedId() {
                    return BookieSideConnectionPeerContextHandler.this.authorizedId;
                }

                @Override
                public void setAuthorizedId(BookKeeperPrincipal principal) {
                    LOG.info("connection {} authenticated as {}", (Object)BookieSideConnectionPeerContextHandler.this.channel, (Object)principal);
                    BookieSideConnectionPeerContextHandler.this.authorizedId = principal;
                }

                @Override
                public boolean isSecure() {
                    Channel c = BookieSideConnectionPeerContextHandler.this.channel;
                    if (c == null) {
                        return false;
                    }
                    return c.pipeline().get("tls") != null;
                }
            };
        }

        public BookieConnectionPeer getConnectionPeer() {
            return this.connectionPeer;
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            this.channel = ctx.channel();
        }
    }
}

