#       Licensed to the Apache Software Foundation (ASF) under one
#       or more contributor license agreements.  See the NOTICE file
#       distributed with this work for additional information
#       regarding copyright ownership.  The ASF licenses this file
#       to you under the Apache License, Version 2.0 (the
#       "License"); you may not use this file except in compliance
#       with the License.  You may obtain a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#       Unless required by applicable law or agreed to in writing,
#       software distributed under the License is distributed on an
#       "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
#       KIND, either express or implied.  See the License for the
#       specific language governing permissions and limitations
#       under the License.


from allura.lib.utils import permanent_redirect
from tg import expose
from tg.decorators import with_trailing_slash
from tg import tmpl_context as c

from allura.lib import helpers as h
from allura.controllers import repository
from allura.controllers.feed import FeedController


class BranchBrowser(repository.BranchBrowser, FeedController):

    def __init__(self):
        super().__init__(None)

    def get_feed(self, project, app, user):
        return repository.RepoRootController().get_feed(project, app, user)

    @expose('jinja:forgesvn:templates/svn/index.html')
    @with_trailing_slash
    def index(self, limit=None, page=0, count=0, **kw):
        is_empty = c.app.repo.is_empty()
        latest = c.app.repo.latest(branch=self._branch)
        if is_empty or not latest:
            return dict(allow_fork=False, log=[], is_empty=is_empty)
        permanent_redirect(h.urlquote(c.app.repo.url_for_commit(c.app.default_branch_name) + 'tree/'))

    @expose()
    def _lookup(self, rev, *remainder):
        return repository.CommitBrowser(rev), remainder
