/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier.loadbalancer;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.camel.Route;
import org.apache.camel.model.LoadBalancerDefinition;
import org.apache.camel.model.loadbalancer.CustomLoadBalancerDefinition;
import org.apache.camel.model.loadbalancer.FailoverLoadBalancerDefinition;
import org.apache.camel.model.loadbalancer.RandomLoadBalancerDefinition;
import org.apache.camel.model.loadbalancer.RoundRobinLoadBalancerDefinition;
import org.apache.camel.model.loadbalancer.StickyLoadBalancerDefinition;
import org.apache.camel.model.loadbalancer.TopicLoadBalancerDefinition;
import org.apache.camel.model.loadbalancer.WeightedLoadBalancerDefinition;
import org.apache.camel.processor.loadbalancer.LoadBalancer;
import org.apache.camel.reifier.AbstractReifier;
import org.apache.camel.reifier.loadbalancer.CustomLoadBalancerReifier;
import org.apache.camel.reifier.loadbalancer.FailoverLoadBalancerReifier;
import org.apache.camel.reifier.loadbalancer.RandomLoadBalancerReifier;
import org.apache.camel.reifier.loadbalancer.RoundRobinLoadBalancerReifier;
import org.apache.camel.reifier.loadbalancer.StickyLoadBalancerReifier;
import org.apache.camel.reifier.loadbalancer.TopicLoadBalancerReifier;
import org.apache.camel.reifier.loadbalancer.WeightedLoadBalancerReifier;
import org.apache.camel.spi.ReifierStrategy;
import org.apache.camel.util.StringHelper;

public class LoadBalancerReifier<T extends LoadBalancerDefinition>
extends AbstractReifier {
    private static final Map<Class<?>, BiFunction<Route, LoadBalancerDefinition, LoadBalancerReifier<? extends LoadBalancerDefinition>>> LOAD_BALANCERS = new HashMap(0);
    protected final T definition;

    public LoadBalancerReifier(Route route, T definition) {
        super(route);
        this.definition = definition;
    }

    public static void registerReifier(Class<?> processorClass, BiFunction<Route, LoadBalancerDefinition, LoadBalancerReifier<? extends LoadBalancerDefinition>> creator) {
        if (LOAD_BALANCERS.isEmpty()) {
            ReifierStrategy.addReifierClearer(LoadBalancerReifier::clearReifiers);
        }
        LOAD_BALANCERS.put(processorClass, creator);
    }

    public static LoadBalancerReifier<? extends LoadBalancerDefinition> reifier(Route route, LoadBalancerDefinition definition) {
        BiFunction<Route, LoadBalancerDefinition, LoadBalancerReifier<? extends LoadBalancerDefinition>> reifier;
        LoadBalancerReifier<LoadBalancerDefinition> answer = null;
        if (!LOAD_BALANCERS.isEmpty() && (reifier = LOAD_BALANCERS.get(definition.getClass())) != null) {
            answer = reifier.apply(route, definition);
        }
        if (answer == null) {
            answer = LoadBalancerReifier.coreReifier(route, definition);
        }
        if (answer == null) {
            throw new IllegalStateException("Unsupported definition: " + String.valueOf(definition));
        }
        return answer;
    }

    private static LoadBalancerReifier<? extends LoadBalancerDefinition> coreReifier(Route route, LoadBalancerDefinition definition) {
        if (definition instanceof CustomLoadBalancerDefinition) {
            return new CustomLoadBalancerReifier(route, definition);
        }
        if (definition instanceof FailoverLoadBalancerDefinition) {
            return new FailoverLoadBalancerReifier(route, definition);
        }
        if (definition instanceof RandomLoadBalancerDefinition) {
            return new RandomLoadBalancerReifier(route, definition);
        }
        if (definition instanceof RoundRobinLoadBalancerDefinition) {
            return new RoundRobinLoadBalancerReifier(route, definition);
        }
        if (definition instanceof StickyLoadBalancerDefinition) {
            return new StickyLoadBalancerReifier(route, definition);
        }
        if (definition instanceof TopicLoadBalancerDefinition) {
            return new TopicLoadBalancerReifier(route, definition);
        }
        if (definition instanceof WeightedLoadBalancerDefinition) {
            return new WeightedLoadBalancerReifier(route, definition);
        }
        return null;
    }

    public static void clearReifiers() {
        LOAD_BALANCERS.clear();
    }

    public LoadBalancer createLoadBalancer() {
        String loadBalancerTypeName = this.definition.getLoadBalancerTypeName();
        StringHelper.notEmpty((String)loadBalancerTypeName, (String)"loadBalancerTypeName", (Object)this);
        LoadBalancer answer = null;
        if (loadBalancerTypeName != null) {
            Class type = this.camelContext.getClassResolver().resolveClass(loadBalancerTypeName, LoadBalancer.class);
            if (type == null) {
                throw new IllegalArgumentException("Cannot find class: " + loadBalancerTypeName + " in the classpath");
            }
            answer = (LoadBalancer)this.camelContext.getInjector().newInstance(type, false);
        }
        return answer;
    }
}

