/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region.policy;

import javax.jms.MessageFormatRuntimeException;
import org.apache.activemq.broker.ProducerBrokerExchange;
import org.apache.activemq.broker.region.policy.MessageInterceptorStrategy;
import org.apache.activemq.command.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeaderMessageInterceptorStrategy
implements MessageInterceptorStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(HeaderMessageInterceptorStrategy.class);
    boolean forceDeliveryMode = false;
    boolean persistent = true;
    boolean forceExpiration = false;
    long zeroExpirationOverride = 0L;
    long expirationCeiling = 0L;
    boolean futureOnly = false;
    boolean processNetworkMessages = false;

    public void setZeroExpirationOverride(long ttl) {
        this.zeroExpirationOverride = ttl;
    }

    public void setExpirationCeiling(long expirationCeiling) {
        this.expirationCeiling = expirationCeiling;
    }

    public void setFutureOnly(boolean futureOnly) {
        this.futureOnly = futureOnly;
    }

    public void setProcessNetworkMessages(Boolean processNetworkMessages) {
        this.processNetworkMessages = processNetworkMessages;
    }

    @Override
    public void process(ProducerBrokerExchange producerBrokerExchange, Message message) throws MessageFormatRuntimeException {
        if (!this.isProcessNetworkMessages() && producerBrokerExchange.getConnectionContext().isNetworkConnection()) {
            return;
        }
        if (this.isForceExpiration() && message.getTimestamp() > 0L && !message.getDestination().isDLQ()) {
            long oldExpiration = message.getExpiration();
            long newTimeStamp = System.currentTimeMillis();
            long timeToLive = this.zeroExpirationOverride;
            long oldTimestamp = message.getTimestamp();
            if (oldExpiration > 0L) {
                timeToLive = oldExpiration - oldTimestamp;
            }
            if (timeToLive > 0L && this.expirationCeiling > 0L && timeToLive > this.expirationCeiling) {
                timeToLive = this.expirationCeiling;
            }
            long expiration = timeToLive + newTimeStamp;
            if (!this.futureOnly || expiration > oldExpiration) {
                if (timeToLive > 0L && expiration > 0L) {
                    message.setExpiration(expiration);
                }
                message.setTimestamp(newTimeStamp);
                LOG.debug("Set message {} timestamp from {} to {}", message.getMessageId(), oldTimestamp, newTimeStamp);
            }
        }
        if (this.forceDeliveryMode) {
            message.setPersistent(this.isPersistent());
        }
    }

    public void setForceDeliveryMode(boolean forceDeliveryMode) {
        this.forceDeliveryMode = forceDeliveryMode;
    }

    public boolean isForceDeliveryMode() {
        return this.forceDeliveryMode;
    }

    public void setForceExpiration(boolean forceExpiration) {
        this.forceExpiration = forceExpiration;
    }

    public boolean isForceExpiration() {
        return this.forceExpiration;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void setProcessNetworkMessages(boolean processNetworkMessages) {
        this.processNetworkMessages = processNetworkMessages;
    }

    public boolean isProcessNetworkMessages() {
        return this.processNetworkMessages;
    }
}

