/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TMemoryBuffer;
import org.apache.thrift.transport.TMemoryInputTransport;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class ThriftMessageUtil {
    private final int initialCapacity;
    private final TMemoryInputTransport inputTransport;
    private final TCompactProtocol inputProtocol;

    public ThriftMessageUtil() throws IOException {
        this.initialCapacity = 64;
        try {
            this.inputTransport = new TMemoryInputTransport();
        }
        catch (TTransportException e) {
            throw new IOException(e);
        }
        this.inputProtocol = new TCompactProtocol((TTransport)this.inputTransport);
    }

    public ByteBuffer serialize(TBase<?, ?> msg) throws IOException {
        Objects.requireNonNull(msg);
        try {
            TMemoryBuffer transport = new TMemoryBuffer(this.initialCapacity);
            TCompactProtocol protocol = new TCompactProtocol((TTransport)transport);
            msg.write((TProtocol)protocol);
            return ByteBuffer.wrap(transport.getArray(), 0, transport.length());
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    public <T extends TBase<?, ?>> T deserialize(byte[] serialized, T instance) throws IOException {
        return this.deserialize(serialized, 0, serialized.length, instance);
    }

    public <T extends TBase<?, ?>> T deserialize(byte[] serialized, int offset, int length, T instance) throws IOException {
        Objects.requireNonNull(instance);
        this.inputTransport.reset(serialized, offset, length);
        try {
            instance.read((TProtocol)this.inputProtocol);
        }
        catch (TException e) {
            throw new IOException(e);
        }
        return instance;
    }
}

