/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.metadata.schema;

import java.util.Objects;
import org.apache.accumulo.core.client.admin.TimeType;

public final class MetadataTime
implements Comparable<MetadataTime> {
    private final long time;
    private final TimeType type;

    public MetadataTime(long time, TimeType type) {
        this.time = time;
        this.type = type;
    }

    public static MetadataTime parse(String timestr) throws IllegalArgumentException {
        if (timestr != null && timestr.length() > 1) {
            return new MetadataTime(Long.parseLong(timestr.substring(1)), MetadataTime.getType(timestr.charAt(0)));
        }
        throw new IllegalArgumentException("Unknown metadata time value " + timestr);
    }

    public static TimeType getType(char code) {
        switch (code) {
            case 'M': {
                return TimeType.MILLIS;
            }
            case 'L': {
                return TimeType.LOGICAL;
            }
        }
        throw new IllegalArgumentException("Unknown time type code : " + code);
    }

    public static char getCode(TimeType type) {
        switch (type) {
            case MILLIS: {
                return 'M';
            }
            case LOGICAL: {
                return 'L';
            }
        }
        throw new IllegalArgumentException("Unknown time type: " + String.valueOf((Object)type));
    }

    public char getCode() {
        return MetadataTime.getCode(this.type);
    }

    public String encode() {
        return "" + this.getCode() + this.time;
    }

    public TimeType getType() {
        return this.type;
    }

    public long getTime() {
        return this.time;
    }

    public boolean equals(Object o) {
        if (o instanceof MetadataTime) {
            MetadataTime t = (MetadataTime)o;
            return this.time == t.getTime() && this.type == t.getType();
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.time, this.type});
    }

    @Override
    public int compareTo(MetadataTime mtime) {
        if (this.type.equals((Object)mtime.getType())) {
            return Long.compare(this.time, mtime.getTime());
        }
        throw new IllegalArgumentException("Cannot compare different time types: " + String.valueOf(this) + " and " + String.valueOf(mtime));
    }
}

